/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.curl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.curl.Curl;
import nbbrd.io.sys.EndOfProcessException;
import nbbrd.io.sys.OS;
import nbbrd.io.sys.ProcessReader;
import nbbrd.io.sys.SystemProperties;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CurlHttpURLConnection
extends HttpURLConnection {
    private final Proxy proxy;
    private final boolean insecure;
    private final File tempDir;
    private final UUID id;
    private final BiConsumer<String, Exception> onError;
    private final File inputFile;
    private final File outputFile;
    private Map<String, List<String>> headerFields = NO_HEADER_FIELDS;
    private InputStream inputStream = NO_INPUT_STREAM;
    private OutputStream outputStream = NO_OUTPUT_STREAM;
    @VisibleForTesting
    static final boolean WINDOWS_SCHANNEL = OS.NAME.equals((Object)OS.Name.WINDOWS);
    private static final Proxy DEFAULT_PROXY = Proxy.NO_PROXY;
    private static final File DEFAULT_TEMP_DIR = Objects.requireNonNull(SystemProperties.DEFAULT.getJavaIoTmpdir()).toFile();
    private static final BiConsumer<String, Exception> DEFAULT_ON_ERROR = (ignoreMessage, ignoreException) -> {};
    private static final int NO_RESPONSE_CODE = -1;
    private static final String NO_RESPONSE_MESSAGE = null;
    private static final Map<String, List<String>> NO_HEADER_FIELDS = Collections.emptyMap();
    private static final InputStream NO_INPUT_STREAM = null;
    private static final OutputStream NO_OUTPUT_STREAM = null;
    private static final Curl.Head NO_HEAD = new Curl.Head(new Curl.Status(-1, NO_RESPONSE_MESSAGE), Collections.emptySortedMap());

    @NonNull
    public static CurlHttpURLConnection of(@NonNull URL url, @NonNull Proxy proxy) throws IOException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (proxy == null) {
            throw new NullPointerException("proxy is marked non-null but is null");
        }
        return CurlHttpURLConnection.builder(url).proxy(proxy).build();
    }

    @VisibleForTesting
    @NonNull
    public static CurlHttpURLConnection insecureForTestOnly(@NonNull URL url, @NonNull Proxy proxy) throws IOException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (proxy == null) {
            throw new NullPointerException("proxy is marked non-null but is null");
        }
        return CurlHttpURLConnection.builder(url).proxy(proxy).insecure(true).build();
    }

    @NonNull
    static Builder builder(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return new Builder().url(url);
    }

    private CurlHttpURLConnection(@NonNull URL url, Proxy proxy, boolean insecure, File tempDir, UUID id, BiConsumer<String, Exception> onError) {
        super(url);
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.proxy = proxy != null ? proxy : DEFAULT_PROXY;
        this.insecure = insecure;
        this.tempDir = tempDir != null ? tempDir : DEFAULT_TEMP_DIR;
        this.id = id != null ? id : UUID.randomUUID();
        this.onError = onError != null ? onError : DEFAULT_ON_ERROR;
        this.inputFile = new File(this.tempDir, "curl_" + this.id + "_input.tmp");
        this.outputFile = new File(this.tempDir, "curl_" + this.id + "_output.tmp");
    }

    @Override
    public boolean usingProxy() {
        return Curl.hasProxy(this.proxy);
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        String[] request = this.createCurlCommand();
        Curl.Head responseHead = this.executeCurlCommand(request);
        this.responseCode = responseHead.getStatus().getCode();
        this.responseMessage = responseHead.getStatus().getMessage();
        this.headerFields = responseHead.getHeaders();
        this.connected = true;
    }

    @Override
    public void disconnect() {
        if (!this.connected) {
            return;
        }
        this.responseCode = -1;
        this.responseMessage = NO_RESPONSE_MESSAGE;
        this.headerFields = NO_HEADER_FIELDS;
        this.connected = false;
        this.cleanupResource(this.inputStream, this.inputFile, "input");
        this.inputStream = NO_INPUT_STREAM;
        this.cleanupResource(this.outputStream, this.outputFile, "output");
        this.outputStream = NO_OUTPUT_STREAM;
    }

    @Override
    public String getHeaderField(String name) {
        return CurlHttpURLConnection.lastValueOrNull(this.headerFields, name);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        this.connect();
        if (this.inputStream == NO_INPUT_STREAM) {
            this.inputStream = Files.newInputStream(this.inputFile.toPath(), new OpenOption[0]);
        }
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
        }
        if (this.inputStream != NO_INPUT_STREAM) {
            throw new ProtocolException("Cannot write output after reading input.");
        }
        if (this.outputStream == NO_OUTPUT_STREAM) {
            this.outputStream = Files.newOutputStream(this.outputFile.toPath(), new OpenOption[0]);
        }
        return this.outputStream;
    }

    @VisibleForTesting
    String[] createCurlCommand() {
        return new Curl.CommandBuilder().request(this.getRequestMethod()).pathAsIs().url(this.getURL()).http1_1().silent(true).sslRevokeBestEffort(WINDOWS_SCHANNEL).insecure(this.insecure).proxy(this.proxy).output(this.inputFile).dumpHeader("-").connectTimeout((float)this.getConnectTimeout() / 1000.0f).maxTime((float)this.getReadTimeout() / 1000.0f).headers(this.getRequestProperties()).dataBinary(this.getDoOutput() ? this.outputFile : null).location(this.getInstanceFollowRedirects()).build();
    }

    private Curl.Head executeCurlCommand(String[] command) throws IOException {
        Curl.Head head;
        block14: {
            BufferedReader reader = ProcessReader.newReader((String[])command);
            try {
                LinkedList<Curl.Head> curlHeads = Curl.Head.parseResponse(reader);
                Curl.Head head2 = head = curlHeads.isEmpty() ? NO_HEAD : curlHeads.getLast();
                if (reader == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EndOfProcessException ex) {
                    switch (ex.getExitValue()) {
                        case 1: {
                            throw new IOException("Unsupported protocol '" + this.getURL().getProtocol() + "'");
                        }
                        case 6: {
                            throw new UnknownHostException(this.getURL().getHost());
                        }
                        case 28: {
                            throw new IOException("Read timed out");
                        }
                        case 56: {
                            throw new IOException(CurlHttpURLConnection.getFailureReceivingNetworkDataMessage(this.proxy));
                        }
                    }
                    throw ex;
                }
            }
            reader.close();
        }
        return head;
    }

    private void cleanupResource(Closeable stream, File file, String label) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                this.onError.accept("Error while closing stream " + label, ex);
            }
        }
        if (file != null) {
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException ex) {
                this.onError.accept("Error while deleting file " + label, ex);
            }
        }
    }

    private static String getFailureReceivingNetworkDataMessage(Proxy proxy) {
        String result = "Failure in receiving network data.";
        if (Curl.hasProxy(proxy)) {
            result = "Unable to tunnel through proxy. " + result;
        }
        return result;
    }

    private static @Nullable String lastValueOrNull(@NonNull Map<String, List<String>> headers, @NonNull String name) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        List<String> header = headers.get(name);
        return header != null && !header.isEmpty() ? header.get(header.size() - 1) : null;
    }

    @Generated
    Proxy getProxy() {
        return this.proxy;
    }

    @Generated
    boolean isInsecure() {
        return this.insecure;
    }

    @Generated
    File getTempDir() {
        return this.tempDir;
    }

    @Generated
    UUID getId() {
        return this.id;
    }

    @Generated
    BiConsumer<String, Exception> getOnError() {
        return this.onError;
    }

    @Generated
    File getInputFile() {
        return this.inputFile;
    }

    @Generated
    File getOutputFile() {
        return this.outputFile;
    }

    public static final class Builder {
        @Generated
        private URL url;
        @Generated
        private Proxy proxy;
        @Generated
        private boolean insecure;
        @Generated
        private File tempDir;
        @Generated
        private UUID id;
        @Generated
        private BiConsumer<String, Exception> onError;

        @Generated
        Builder() {
        }

        @Generated
        @org.checkerframework.checker.nullness.qual.NonNull Builder url(@NonNull URL url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        @Generated
        @org.checkerframework.checker.nullness.qual.NonNull Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        @Generated
        @org.checkerframework.checker.nullness.qual.NonNull Builder insecure(boolean insecure) {
            this.insecure = insecure;
            return this;
        }

        @Generated
        @org.checkerframework.checker.nullness.qual.NonNull Builder tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        @Generated
        @org.checkerframework.checker.nullness.qual.NonNull Builder id(UUID id) {
            this.id = id;
            return this;
        }

        @Generated
        @org.checkerframework.checker.nullness.qual.NonNull Builder onError(BiConsumer<String, Exception> onError) {
            this.onError = onError;
            return this;
        }

        @Generated
        @org.checkerframework.checker.nullness.qual.NonNull CurlHttpURLConnection build() {
            return new CurlHttpURLConnection(this.url, this.proxy, this.insecure, this.tempDir, this.id, this.onError);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "CurlHttpURLConnection.Builder(url=" + this.url + ", proxy=" + this.proxy + ", insecure=" + this.insecure + ", tempDir=" + this.tempDir + ", id=" + this.id + ", onError=" + this.onError + ")";
        }
    }
}

