/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.curl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class Curl {
    public static final int CURL_UNSUPPORTED_PROTOCOL = 1;
    public static final int CURL_COULD_NOT_RESOLVE_HOST = 6;
    public static final int CURL_OPERATION_TIMEOUT = 28;
    public static final int CURL_FAILURE_RECEIVING = 56;

    static boolean hasProxy(@NonNull Proxy proxy) {
        if (proxy == null) {
            throw new NullPointerException("proxy is marked non-null but is null");
        }
        return !proxy.equals(Proxy.NO_PROXY);
    }

    @Generated
    private Curl() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static @interface MinVersion {
        public String value();
    }

    static final class CommandBuilder {
        public static final String STDOUT_FILENAME = "-";
        private final List<String> items = new ArrayList<String>();

        public CommandBuilder() {
            this.items.add("curl");
        }

        private CommandBuilder push(String item) {
            this.items.add(item);
            return this;
        }

        public CommandBuilder request(String method) {
            return this.isDefaultMethod(method) ? this : this.push("-X").push(method);
        }

        public CommandBuilder url(URL url) {
            return this.push(url.toString());
        }

        public CommandBuilder proxy(Proxy proxy) {
            if (Curl.hasProxy(proxy)) {
                InetSocketAddress address = (InetSocketAddress)proxy.address();
                this.push("-x").push(address.getHostString() + ":" + address.getPort());
            }
            return this;
        }

        public CommandBuilder output(File file) {
            return this.push("-o").push(file.toString());
        }

        public CommandBuilder silent(boolean silent) {
            return silent ? this.push("-s") : this;
        }

        public CommandBuilder dumpHeader(String filename) {
            return this.push("-D").push(filename);
        }

        public CommandBuilder connectTimeout(float seconds) {
            return this.push("--connect-timeout").push(this.fixNumericalParameter(seconds));
        }

        public CommandBuilder maxTime(float seconds) {
            return this.push("-m").push(this.fixNumericalParameter(seconds));
        }

        @MinVersion(value="7.70.0")
        public CommandBuilder sslRevokeBestEffort(boolean sslRevokeBestEffort) {
            return sslRevokeBestEffort ? this.push("--ssl-revoke-best-effort") : this;
        }

        public CommandBuilder insecure(boolean insecure) {
            return insecure ? this.push("-k") : this;
        }

        public CommandBuilder header(String key, String value) {
            return this.push("-H").push(key + ": " + value);
        }

        public CommandBuilder headers(Map<String, List<String>> headers) {
            headers.forEach((key, values) -> values.forEach(value -> this.header((String)key, (String)value)));
            return this;
        }

        public CommandBuilder version() {
            return this.push("-V");
        }

        @MinVersion(value="7.33.0")
        public CommandBuilder http1_1() {
            return this.push("--http1.1");
        }

        public CommandBuilder dataRaw(@Nullable String data) {
            return data != null ? this.push("--data-raw").push(data) : this;
        }

        public CommandBuilder dataBinary(@Nullable File data) {
            return data != null ? this.push("--data-binary").push("@" + data) : this;
        }

        public CommandBuilder location(boolean location) {
            return location ? this.push("-L") : this;
        }

        public CommandBuilder maxRedirs(int maxRedirs) {
            return this.push("--max-redirs").push(Integer.toString(maxRedirs));
        }

        @MinVersion(value="7.42.0")
        public CommandBuilder pathAsIs() {
            return this.push("--path-as-is");
        }

        public String[] build() {
            return this.items.toArray(new String[0]);
        }

        private String fixNumericalParameter(float seconds) {
            return Integer.toString((int)seconds);
        }

        private boolean isDefaultMethod(String method) {
            return method.equals("GET");
        }
    }

    static final class Version {
        private final List<String> lines;

        public static Version parseText(BufferedReader reader) throws IOException {
            Builder result = new Builder();
            try {
                reader.lines().forEach(result::line);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
            return result.build();
        }

        @Generated
        Version(List<String> lines) {
            this.lines = lines;
        }

        @Generated
        public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
            return new Builder();
        }

        @Generated
        public List<String> getLines() {
            return this.lines;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            Version other = (Version)o;
            List<String> this$lines = this.getLines();
            List<String> other$lines = other.getLines();
            return !(this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $lines = this.getLines();
            result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
            return result;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "Curl.Version(lines=" + this.getLines() + ")";
        }

        public static final class Builder {
            @Generated
            private ArrayList<String> lines;

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder line(String line) {
                if (this.lines == null) {
                    this.lines = new ArrayList();
                }
                this.lines.add(line);
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder lines(@org.checkerframework.checker.nullness.qual.NonNull Collection<? extends String> lines) {
                if (lines == null) {
                    throw new NullPointerException("lines cannot be null");
                }
                if (this.lines == null) {
                    this.lines = new ArrayList();
                }
                this.lines.addAll(lines);
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder clearLines() {
                if (this.lines != null) {
                    this.lines.clear();
                }
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Version build() {
                List<String> lines;
                switch (this.lines == null ? 0 : this.lines.size()) {
                    case 0: {
                        lines = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        lines = Collections.singletonList(this.lines.get(0));
                        break;
                    }
                    default: {
                        lines = Collections.unmodifiableList(new ArrayList<String>(this.lines));
                    }
                }
                return new Version(lines);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Curl.Version.Builder(lines=" + this.lines + ")";
            }
        }
    }

    static final class Head {
        @NonNull
        private final Status status;
        @NonNull
        private final SortedMap<String, List<String>> headers;
        private static char SP = (char)32;

        public static LinkedList<Head> parseResponse(BufferedReader reader) throws IOException {
            LinkedList<Head> result = new LinkedList<Head>();
            String line = reader.readLine();
            while (line != null) {
                Status status = Head.parseStatusLine(line);
                TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                while ((line = reader.readLine()) != null && !line.isEmpty()) {
                    Head.parseHeaders(line, headers);
                }
                if (line != null) {
                    line = reader.readLine();
                }
                result.add(new Head(status, Collections.unmodifiableSortedMap(headers)));
            }
            return result;
        }

        private static Status parseStatusLine(String statusLine) {
            if (statusLine == null) {
                return new Status(-1, null);
            }
            int codeStart = statusLine.indexOf(SP);
            if (codeStart == -1) {
                return new Status(-1, null);
            }
            int codeEnd = statusLine.indexOf(SP, codeStart + 1);
            if (codeEnd == -1) {
                return new Status(Integer.parseInt(statusLine.substring(codeStart + 1)), null);
            }
            return new Status(Integer.parseInt(statusLine.substring(codeStart + 1, codeEnd)), statusLine.substring(codeEnd + 1));
        }

        private static void parseHeaders(String line, SortedMap<String, List<String>> result) {
            int index = line.indexOf(":");
            if (index != -1) {
                String key = line.substring(0, index);
                String value = line.substring(index + 1).trim();
                if (!value.isEmpty()) {
                    result.computeIfAbsent(key, ignore -> new ArrayList()).add(value);
                }
            }
        }

        @Generated
        public Head(@NonNull Status status, @NonNull SortedMap<String, List<String>> headers) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            if (headers == null) {
                throw new NullPointerException("headers is marked non-null but is null");
            }
            this.status = status;
            this.headers = headers;
        }

        @NonNull
        @Generated
        public Status getStatus() {
            return this.status;
        }

        @NonNull
        @Generated
        public SortedMap<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Head)) {
                return false;
            }
            Head other = (Head)o;
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            SortedMap<String, List<String>> this$headers = this.getHeaders();
            SortedMap<String, List<String>> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            SortedMap<String, List<String>> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
            return result;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "Curl.Head(status=" + this.getStatus() + ", headers=" + this.getHeaders() + ")";
        }
    }

    static final class Status {
        private final int code;
        private final String message;

        @Generated
        public Status(int code, String message) {
            this.code = code;
            this.message = message;
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Status)) {
                return false;
            }
            Status other = (Status)o;
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "Curl.Status(code=" + this.getCode() + ", message=" + this.getMessage() + ")";
        }
    }
}

