/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http;

import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class URLQueryBuilder {
    @lombok.NonNull
    private final URL endPoint;
    private boolean trailingSlash = false;
    private final Charset encoding = StandardCharsets.UTF_8;
    private final List<String> paths = new ArrayList<String>();
    private final Map<String, String> params = new LinkedHashMap<String, String>();

    @lombok.NonNull
    public URLQueryBuilder trailingSlash(boolean trailingSlash) {
        this.trailingSlash = trailingSlash;
        return this;
    }

    @lombok.NonNull
    public URLQueryBuilder path(@lombok.NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.paths.add(path);
        return this;
    }

    @lombok.NonNull
    public URLQueryBuilder path(@lombok.NonNull List<String> path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.paths.addAll(path);
        return this;
    }

    @lombok.NonNull
    public URLQueryBuilder param(@lombok.NonNull String key, @lombok.NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.params.put(key, value);
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.endPoint);
        for (String path : this.paths) {
            result.append('/').append(URLQueryBuilder.encode(path, this.encoding));
        }
        if (this.trailingSlash) {
            result.append('/');
        }
        boolean first = true;
        for (Map.Entry<String, String> o : this.params.entrySet()) {
            result.append(first ? (char)'?' : '&');
            result.append(URLQueryBuilder.encode(o.getKey(), this.encoding)).append('=').append(URLQueryBuilder.encode(o.getValue(), this.encoding));
            first = false;
        }
        return result.toString();
    }

    @lombok.NonNull
    public URL build() throws MalformedURLException {
        return new URL(this.toString());
    }

    private static String encode(String s, Charset charset) {
        try {
            return URLEncoder.encode(s, charset.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Generated
    private URLQueryBuilder(@lombok.NonNull URL endPoint) {
        if (endPoint == null) {
            throw new NullPointerException("endPoint is marked non-null but is null");
        }
        this.endPoint = endPoint;
    }

    @Generated
    public static @NonNull URLQueryBuilder of(@lombok.NonNull URL endPoint) {
        if (endPoint == null) {
            throw new NullPointerException("endPoint is marked non-null but is null");
        }
        return new URLQueryBuilder(endPoint);
    }
}

