/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http;

import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class URLQueryBuilder {
    @NonNull
    private final URL endPoint;
    private boolean trailingSlash = false;
    private final Charset encoding = StandardCharsets.UTF_8;
    private final List<String> paths = new ArrayList<String>();
    private final Map<String, String> params = new LinkedHashMap<String, String>();

    @NonNull
    public static URLQueryBuilder of(@NonNull URL endPoint) {
        if (endPoint == null) {
            throw new NullPointerException("endPoint is marked non-null but is null");
        }
        return new URLQueryBuilder(endPoint);
    }

    @NonNull
    public URLQueryBuilder trailingSlash(boolean trailingSlash) {
        this.trailingSlash = trailingSlash;
        return this;
    }

    @NonNull
    public URLQueryBuilder path(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.paths.add(path);
        return this;
    }

    @NonNull
    public URLQueryBuilder path(@NonNull List<String> path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.paths.addAll(path);
        return this;
    }

    @NonNull
    public URLQueryBuilder param(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.params.put(key, value);
        return this;
    }

    @NonNull
    public URLQueryBuilder param(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.params.put(key, null);
        return this;
    }

    public String toString() {
        Iterator<Map.Entry<String, String>> paramsIterator;
        StringBuilder result = new StringBuilder();
        String endPointAsString = this.endPoint.toString();
        if (!this.paths.isEmpty() && endPointAsString.charAt(endPointAsString.length() - 1) == '/') {
            result.append(endPointAsString, 0, endPointAsString.length() - 1);
        } else {
            result.append(endPointAsString);
        }
        for (String path : this.paths) {
            result.append('/').append(URLQueryBuilder.encode(path, this.encoding));
        }
        if (this.trailingSlash) {
            result.append('/');
        }
        if ((paramsIterator = this.params.entrySet().iterator()).hasNext()) {
            result.append('?');
            this.appendParam(result, paramsIterator.next());
            while (paramsIterator.hasNext()) {
                result.append('&');
                this.appendParam(result, paramsIterator.next());
            }
        }
        return result.toString();
    }

    private void appendParam(StringBuilder result, Map.Entry<String, String> o) {
        result.append(URLQueryBuilder.encode(o.getKey(), this.encoding));
        String value = o.getValue();
        if (value != null) {
            result.append('=').append(URLQueryBuilder.encode(value, this.encoding));
        }
    }

    @NonNull
    public URL build() throws MalformedURLException {
        return new URL(this.toString());
    }

    private static String encode(String s, Charset charset) {
        try {
            return URLEncoder.encode(s, charset.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Generated
    private URLQueryBuilder(@NonNull URL endPoint) {
        if (endPoint == null) {
            throw new NullPointerException("endPoint is marked non-null but is null");
        }
        this.endPoint = endPoint;
    }
}

