/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http.ext;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;

final class TeeInputStream
extends InputStream {
    @NonNull
    private final InputStream input;
    @NonNull
    private final OutputStream output;

    @Override
    public int read() throws IOException {
        int result = this.input.read();
        if (TeeInputStream.isNotEndOfStream(result)) {
            this.output.write(result);
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.input.read(b);
        if (TeeInputStream.isNotEndOfStream(result)) {
            this.output.write(b, 0, result);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.input.read(b, off, len);
        if (TeeInputStream.isNotEndOfStream(result)) {
            this.output.write(b, off, result);
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public void close() throws IOException {
        try {
            TeeInputStream.copyRemaining(this.input, this.output);
        }
        finally {
            Resource.closeBoth((Closeable)this.input, (Closeable)this.output);
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private static void copyRemaining(InputStream source, OutputStream target) {
        byte[] buf = new byte[8192];
        try {
            int length;
            while ((length = source.read(buf)) > 0) {
                target.write(buf, 0, length);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isNotEndOfStream(int result) {
        return result != -1;
    }

    @Generated
    public TeeInputStream(@NonNull InputStream input, @NonNull OutputStream output) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        this.input = input;
        this.output = output;
    }
}

