/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import nbbrd.io.http.DisconnectingInputStream;
import nbbrd.io.net.MediaType;

public interface HttpResponse
extends Closeable {
    @NonNull
    public MediaType getContentType() throws IOException;

    @NonNull
    public InputStream getBody() throws IOException;

    @NonNull
    default public Reader getBodyAsReader() throws IOException {
        return new InputStreamReader(this.getBody(), this.getContentType().getCharset().orElse(StandardCharsets.UTF_8));
    }

    @NonNull
    default public InputStream asDisconnectingInputStream() throws IOException {
        return DisconnectingInputStream.of(this);
    }
}

