/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http.ext;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.http.HttpClient;
import nbbrd.io.http.HttpRequest;
import nbbrd.io.http.HttpResponse;
import nbbrd.io.http.ext.TeeInputStream;
import nbbrd.io.net.MediaType;

public final class DumpingClient
implements HttpClient {
    @NonNull
    private final Path folder;
    @NonNull
    private final HttpClient delegate;
    @NonNull
    private final Consumer<? super Path> onDump;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public HttpResponse send(@NonNull HttpRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String prefix = "http_" + DumpingClient.getUniqueTimeStamp();
        try {
            DumpingResponse dumpingResponse = new DumpingResponse(this.folder, this.delegate.send(request), this.onDump, prefix);
            return dumpingResponse;
        }
        finally {
            this.dumpRequestBody(request, prefix);
        }
    }

    private void dumpRequestBody(HttpRequest request, String prefix) throws IOException {
        if (request.getBody() != null) {
            Files.createDirectories(this.folder, new FileAttribute[0]);
            Path requestDump = this.folder.resolve(prefix + "_request.tmp");
            this.onDump.accept(requestDump);
            Files.write(requestDump, request.getBody(), new OpenOption[0]);
        }
    }

    private static synchronized String getUniqueTimeStamp() {
        return String.valueOf(System.nanoTime());
    }

    @Generated
    public DumpingClient(@NonNull Path folder, @NonNull HttpClient delegate, @NonNull Consumer<? super Path> onDump) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (onDump == null) {
            throw new NullPointerException("onDump is marked non-null but is null");
        }
        this.folder = folder;
        this.delegate = delegate;
        this.onDump = onDump;
    }

    private static final class DumpingResponse
    implements HttpResponse {
        @NonNull
        private final Path folder;
        @NonNull
        private final HttpResponse delegate;
        @NonNull
        private final Consumer<? super Path> onDump;
        @NonNull
        private final String prefix;

        @Override
        @NonNull
        public MediaType getContentType() throws IOException {
            return this.delegate.getContentType();
        }

        @Override
        @NonNull
        public InputStream getBody() throws IOException {
            InputStream inputStream = this.delegate.getBody();
            try {
                OutputStream outputStream = this.getDumpStream();
                return new TeeInputStream(inputStream, outputStream);
            }
            catch (IOException ex) {
                Resource.ensureClosed((Throwable)ex, (Closeable)inputStream);
                throw ex;
            }
        }

        private OutputStream getDumpStream() throws IOException {
            Files.createDirectories(this.folder, new FileAttribute[0]);
            Path responseDump = this.folder.resolve(this.prefix + "_response.tmp");
            this.onDump.accept(responseDump);
            return Files.newOutputStream(responseDump, new OpenOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Generated
        public DumpingResponse(@NonNull Path folder, @NonNull HttpResponse delegate, @NonNull Consumer<? super Path> onDump, @NonNull String prefix) {
            if (folder == null) {
                throw new NullPointerException("folder is marked non-null but is null");
            }
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (onDump == null) {
                throw new NullPointerException("onDump is marked non-null but is null");
            }
            if (prefix == null) {
                throw new NullPointerException("prefix is marked non-null but is null");
            }
            this.folder = folder;
            this.delegate = delegate;
            this.onDump = onDump;
            this.prefix = prefix;
        }
    }
}

