/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http.ext;

import java.io.Closeable;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.http.HttpClient;
import nbbrd.io.http.HttpRequest;
import nbbrd.io.http.HttpResponse;

public final class InterceptingClient
implements HttpClient {
    @NonNull
    private final HttpClient delegate;
    @NonNull
    private final Interceptor interceptor;

    @Override
    @NonNull
    public HttpResponse send(@NonNull HttpRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        HttpResponse result = this.delegate.send(request);
        try {
            return this.interceptor.handle(this.delegate, request, result);
        }
        catch (Throwable ex) {
            Resource.ensureClosed((Throwable)ex, (Closeable)result);
            throw ex;
        }
    }

    @Generated
    public InterceptingClient(@NonNull HttpClient delegate, @NonNull Interceptor interceptor) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (interceptor == null) {
            throw new NullPointerException("interceptor is marked non-null but is null");
        }
        this.delegate = delegate;
        this.interceptor = interceptor;
    }

    @FunctionalInterface
    public static interface Interceptor {
        @NonNull
        public HttpResponse handle(@NonNull HttpClient var1, @NonNull HttpRequest var2, @NonNull HttpResponse var3) throws IOException;
    }
}

