/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.http.HttpAuthScheme;
import nbbrd.io.http.HttpAuthenticator;
import nbbrd.io.http.HttpEventListener;
import nbbrd.io.http.HttpRequest;
import nbbrd.io.http.StreamDecoder;
import org.checkerframework.checker.nullness.qual.Nullable;

final class HttpImpl {
    @Generated
    private HttpImpl() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static enum StreamDecoders implements StreamDecoder
    {
        NONE{

            @Override
            @NonNull
            public InputStream decode(@NonNull InputStream stream) {
                if (stream == null) {
                    throw new NullPointerException("stream is marked non-null but is null");
                }
                return stream;
            }
        }
        ,
        GZIP{

            @Override
            @NonNull
            public InputStream decode(@NonNull InputStream stream) throws IOException {
                if (stream == null) {
                    throw new NullPointerException("stream is marked non-null but is null");
                }
                return new GZIPInputStream(stream);
            }
        }
        ,
        DEFLATE{

            @Override
            @NonNull
            public InputStream decode(@NonNull InputStream stream) {
                if (stream == null) {
                    throw new NullPointerException("stream is marked non-null but is null");
                }
                return new InflaterInputStream(stream);
            }
        };


        @Override
        @NonNull
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    static enum EventListeners implements HttpEventListener
    {
        NONE{

            @Override
            public void onOpen(@NonNull HttpRequest request, @NonNull Proxy proxy, @NonNull HttpAuthScheme scheme) {
                if (request == null) {
                    throw new NullPointerException("request is marked non-null but is null");
                }
                if (proxy == null) {
                    throw new NullPointerException("proxy is marked non-null but is null");
                }
                if (scheme == null) {
                    throw new NullPointerException("scheme is marked non-null but is null");
                }
            }

            @Override
            public void onSuccess(@NonNull Supplier<String> contentType) {
                if (contentType == null) {
                    throw new NullPointerException("contentType is marked non-null but is null");
                }
            }

            @Override
            public void onRedirection(@NonNull URL oldUrl, @NonNull URL newUrl) {
                if (oldUrl == null) {
                    throw new NullPointerException("oldUrl is marked non-null but is null");
                }
                if (newUrl == null) {
                    throw new NullPointerException("newUrl is marked non-null but is null");
                }
            }

            @Override
            public void onUnauthorized(@NonNull URL url, @NonNull HttpAuthScheme oldScheme, @NonNull HttpAuthScheme newScheme) {
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
                if (oldScheme == null) {
                    throw new NullPointerException("oldScheme is marked non-null but is null");
                }
                if (newScheme == null) {
                    throw new NullPointerException("newScheme is marked non-null but is null");
                }
            }

            @Override
            public void onEvent(@NonNull String message) {
                if (message == null) {
                    throw new NullPointerException("message is marked non-null but is null");
                }
            }
        };

    }

    static enum Authenticators implements HttpAuthenticator
    {
        NONE{

            @Override
            public @Nullable PasswordAuthentication getPasswordAuthentication(@NonNull URL url) {
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
                return null;
            }

            @Override
            public void invalidate(@NonNull URL url) {
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
            }
        };

    }
}

