/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.http.HttpAuthScheme;
import nbbrd.io.http.HttpAuthenticator;
import nbbrd.io.http.HttpClient;
import nbbrd.io.http.HttpConstants;
import nbbrd.io.http.HttpContext;
import nbbrd.io.http.HttpHeadersBuilder;
import nbbrd.io.http.HttpRequest;
import nbbrd.io.http.HttpResponse;
import nbbrd.io.http.HttpResponseException;
import nbbrd.io.http.StreamDecoder;
import nbbrd.io.http.URLConnectionFactory;
import nbbrd.io.net.MediaType;

public final class DefaultHttpClient
implements HttpClient {
    @NonNull
    private final HttpContext context;
    private final AtomicReference<Object> lazyFactory = new AtomicReference();

    private URLConnectionFactory initURLConnectionFactory() {
        return this.getContext().getUrlConnectionFactory().get();
    }

    @Override
    @NonNull
    public HttpResponse send(@NonNull HttpRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.open(request, 0, AuthSchemeHelper.of(this.context.getAuthScheme()));
    }

    private HttpResponse open(HttpRequest request, int redirects, AuthSchemeHelper requestScheme) throws IOException {
        if (!HttpConstants.isHttpProtocol(request.getQuery()) && !HttpConstants.isHttpsProtocol(request.getQuery())) {
            throw new IOException("Unsupported protocol '" + request.getQuery().getProtocol() + "'");
        }
        if (!requestScheme.isSecureRequest(request.getQuery())) {
            throw new IOException("Insecure protocol for " + (Object)((Object)requestScheme) + " auth on '" + request.getQuery() + "'");
        }
        Proxy proxy = this.getProxy(request.getQuery());
        HttpURLConnection connection = this.openConnection(request, requestScheme, proxy);
        switch (HttpConstants.ResponseType.ofResponseCode(connection.getResponseCode())) {
            case REDIRECTION: {
                return this.redirect(connection, request, redirects);
            }
            case SUCCESSFUL: {
                return this.getResponse(connection);
            }
            case CLIENT_ERROR: {
                return this.recoverClientError(connection, request, redirects, requestScheme);
            }
        }
        throw this.getError(connection);
    }

    private HttpURLConnection openConnection(HttpRequest request, AuthSchemeHelper requestScheme, Proxy proxy) throws IOException {
        HttpURLConnection result = (HttpURLConnection)this.getLazyFactory().openConnection(request.getQuery(), proxy);
        result.setReadTimeout(this.context.getReadTimeout());
        result.setConnectTimeout(this.context.getConnectTimeout());
        if (result instanceof HttpsURLConnection) {
            ((HttpsURLConnection)result).setSSLSocketFactory(this.context.getSslSocketFactory().get());
            ((HttpsURLConnection)result).setHostnameVerifier(this.context.getHostnameVerifier().get());
        }
        Map<String, List<String>> headers = new HttpHeadersBuilder().put("Accept", DefaultHttpClient.toAcceptHeader(request.getMediaTypes())).put("Accept-Language", request.getLangs()).put("Accept-Encoding", this.getEncodingHeader()).put("User-Agent", this.context.getUserAgent()).put(requestScheme.getRequestHeaders(request.getQuery(), this.context.getAuthenticator())).build();
        result.setRequestMethod(request.getMethod().name());
        result.setInstanceFollowRedirects(false);
        HttpHeadersBuilder.keyValues(headers).forEach(header -> result.setRequestProperty((String)header.getKey(), (String)header.getValue()));
        if (request.getBody() != null) {
            result.setDoOutput(true);
            try (OutputStream stream = result.getOutputStream();){
                stream.write(request.getBody());
            }
        }
        this.context.getListener().onOpen(request, proxy, requestScheme.authScheme);
        result.connect();
        return result;
    }

    private String getEncodingHeader() {
        return this.context.getDecoders().stream().map(StreamDecoder::getName).collect(Collectors.joining(", "));
    }

    private Proxy getProxy(URL url) throws IOException {
        List<Proxy> proxies = this.context.getProxySelector().get().select(DefaultHttpClient.toURI(url));
        return proxies.isEmpty() ? Proxy.NO_PROXY : proxies.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse redirect(HttpURLConnection connection, HttpRequest request, int redirects) throws IOException {
        URL newUrl;
        URL oldUrl = request.getQuery();
        try {
            if (redirects == this.context.getMaxRedirects()) {
                throw new IOException("Max redirection reached");
            }
            String location = connection.getHeaderField("Location");
            if (location == null || location.isEmpty()) {
                throw new IOException("Missing redirection url");
            }
            newUrl = new URL(oldUrl, URLDecoder.decode(location, StandardCharsets.UTF_8.name()));
        }
        finally {
            DefaultHttpClient.doClose(connection);
        }
        if (HttpConstants.isDowngradingProtocolOnRedirect(oldUrl, newUrl)) {
            throw new IOException("Downgrading protocol on redirect from '" + oldUrl + "' to '" + newUrl + "'");
        }
        this.context.getListener().onRedirection(oldUrl, newUrl);
        return this.open(request.toBuilder().query(newUrl).build(), redirects + 1, AuthSchemeHelper.of(this.context.getAuthScheme()));
    }

    private HttpResponse recoverClientError(HttpURLConnection connection, HttpRequest request, int redirects, AuthSchemeHelper requestScheme) throws IOException {
        if (connection.getResponseCode() == 401) {
            AuthSchemeHelper responseScheme = AuthSchemeHelper.find(connection).orElse(null);
            if (responseScheme != null && !requestScheme.equals((Object)responseScheme)) {
                this.context.getListener().onUnauthorized(connection.getURL(), requestScheme.authScheme, responseScheme.authScheme);
                return this.open(request, redirects + 1, responseScheme);
            }
            this.context.getAuthenticator().invalidate(connection.getURL());
        }
        throw this.getError(connection);
    }

    private HttpResponse getResponse(HttpURLConnection connection) {
        DefaultResponse result = new DefaultResponse(connection, this.context.getDecoders());
        this.context.getListener().onSuccess(result::httpContentTypeOrNull);
        return result;
    }

    private IOException getError(HttpURLConnection connection) throws IOException {
        try {
            HttpResponseException httpResponseException = new HttpResponseException(connection.getResponseCode(), connection.getResponseMessage(), connection.getHeaderFields());
            return httpResponseException;
        }
        finally {
            DefaultHttpClient.doClose(connection);
        }
    }

    private static void doClose(HttpURLConnection connection) throws IOException {
        try {
            connection.disconnect();
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    @NonNull
    static String toAcceptHeader(@NonNull List<MediaType> mediaTypes) {
        if (mediaTypes == null) {
            throw new NullPointerException("mediaTypes is marked non-null but is null");
        }
        return mediaTypes.stream().map(MediaType::toString).collect(Collectors.joining(", "));
    }

    private static URI toURI(URL url) throws IOException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    @Generated
    public DefaultHttpClient(@NonNull HttpContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
    }

    @NonNull
    @Generated
    private HttpContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    private URLConnectionFactory getLazyFactory() {
        Object $value = this.lazyFactory.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.lazyFactory;
            synchronized (atomicReference) {
                $value = this.lazyFactory.get();
                if ($value == null) {
                    URLConnectionFactory actualValue = this.initURLConnectionFactory();
                    $value = actualValue == null ? this.lazyFactory : actualValue;
                    this.lazyFactory.set($value);
                }
            }
        }
        return (URLConnectionFactory)($value == this.lazyFactory ? null : $value);
    }

    private static enum AuthSchemeHelper {
        NONE(HttpAuthScheme.NONE){

            @Override
            boolean isSecureRequest(URL query) {
                return true;
            }

            @Override
            Map<String, List<String>> getRequestHeaders(URL query, HttpAuthenticator authenticator) {
                return Collections.emptyMap();
            }

            @Override
            boolean hasResponseHeader(HttpURLConnection http) {
                return false;
            }
        }
        ,
        BASIC(HttpAuthScheme.BASIC){

            @Override
            boolean isSecureRequest(URL url) {
                return HttpConstants.isHttpsProtocol(url);
            }

            @Override
            Map<String, List<String>> getRequestHeaders(URL url, HttpAuthenticator authenticator) throws IOException {
                PasswordAuthentication auth = authenticator.getPasswordAuthentication(url);
                if (auth == null) {
                    throw new IOException("Missing BASIC authentication for " + url);
                }
                return new HttpHeadersBuilder().put("Authorization", this.getBasicAuthHeader(auth)).build();
            }

            @Override
            boolean hasResponseHeader(HttpURLConnection http) {
                String value = http.getHeaderField("WWW-Authenticate");
                return value != null && value.startsWith("Basic");
            }

            private String getBasicAuthHeader(PasswordAuthentication auth) {
                String basicAuth = auth.getUserName() + ':' + String.valueOf(auth.getPassword());
                return "Basic " + this.toBase64(basicAuth);
            }

            private String toBase64(String input) {
                return Base64.getEncoder().encodeToString(input.getBytes(StandardCharsets.UTF_8));
            }
        }
        ,
        BEARER(HttpAuthScheme.BEARER){

            @Override
            boolean isSecureRequest(URL url) {
                return HttpConstants.isHttpsProtocol(url);
            }

            @Override
            Map<String, List<String>> getRequestHeaders(URL url, HttpAuthenticator authenticator) throws IOException {
                PasswordAuthentication auth = authenticator.getPasswordAuthentication(url);
                if (auth == null) {
                    throw new IOException("Missing BEARER authentication for " + url);
                }
                return new HttpHeadersBuilder().put("Authorization", this.getBearerAuthHeader(auth)).build();
            }

            @Override
            boolean hasResponseHeader(HttpURLConnection http) {
                return false;
            }

            private String getBearerAuthHeader(PasswordAuthentication auth) {
                return "Bearer " + String.valueOf(auth.getPassword());
            }
        };

        private final HttpAuthScheme authScheme;

        abstract boolean isSecureRequest(URL var1);

        abstract Map<String, List<String>> getRequestHeaders(URL var1, HttpAuthenticator var2) throws IOException;

        abstract boolean hasResponseHeader(HttpURLConnection var1) throws IOException;

        public static Optional<AuthSchemeHelper> find(HttpURLConnection http) {
            return Stream.of(AuthSchemeHelper.values()).filter(authScheme -> {
                try {
                    return authScheme.hasResponseHeader(http);
                }
                catch (IOException exception) {
                    throw new UncheckedIOException(exception);
                }
            }).findFirst();
        }

        public static AuthSchemeHelper of(HttpAuthScheme authScheme) {
            switch (authScheme) {
                case NONE: {
                    return NONE;
                }
                case BASIC: {
                    return BASIC;
                }
                case BEARER: {
                    return BEARER;
                }
            }
            throw new IllegalArgumentException("Unknown auth scheme: " + (Object)((Object)authScheme));
        }

        @Generated
        private AuthSchemeHelper(HttpAuthScheme authScheme) {
            this.authScheme = authScheme;
        }
    }

    private static final class DefaultResponse
    implements HttpResponse {
        @NonNull
        private final HttpURLConnection conn;
        @NonNull
        private final List<StreamDecoder> decoders;

        String httpContentTypeOrNull() {
            return this.conn.getHeaderField("Content-Type");
        }

        @Override
        @NonNull
        public MediaType getContentType() throws IOException {
            String contentTypeOrNull = this.httpContentTypeOrNull();
            if (contentTypeOrNull == null) {
                throw new IOException("Missing content-type in HTTP response header");
            }
            try {
                return MediaType.parse((CharSequence)contentTypeOrNull);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Invalid content-type in HTTP response header: '" + contentTypeOrNull + "'", ex);
            }
        }

        @Override
        @NonNull
        public InputStream getBody() throws IOException {
            String encodingOrNull = this.conn.getHeaderField("Content-Encoding");
            return this.decoders.stream().filter(decoder -> decoder.getName().equals(encodingOrNull)).findFirst().orElse(StreamDecoder.noOp()).decode(this.conn.getInputStream());
        }

        @Override
        public void close() throws IOException {
            DefaultHttpClient.doClose(this.conn);
        }

        @Generated
        public DefaultResponse(@NonNull HttpURLConnection conn, @NonNull List<StreamDecoder> decoders) {
            if (conn == null) {
                throw new NullPointerException("conn is marked non-null but is null");
            }
            if (decoders == null) {
                throw new NullPointerException("decoders is marked non-null but is null");
            }
            this.conn = conn;
            this.decoders = decoders;
        }
    }
}

