/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public interface HttpAuthenticator {
    public @Nullable PasswordAuthentication getPasswordAuthentication(@NonNull URL var1) throws IOException;

    default public void invalidate(@NonNull URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
    }

    @NonNull
    public static HttpAuthenticator noOp() {
        return ignore -> null;
    }

    @NonNull
    public static PasswordAuthentication newPassword(@NonNull String username, @NonNull String password) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        return new PasswordAuthentication(username, password.toCharArray());
    }

    @NonNull
    public static PasswordAuthentication newToken(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return new PasswordAuthentication(null, token.toCharArray());
    }
}

