/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http;

import java.net.URL;
import lombok.Generated;

public final class HttpConstants {
    public static final String HTTP_ACCEPT_HEADER = "Accept";
    public static final String HTTP_ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    public static final String HTTP_ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    public static final String HTTP_LOCATION_HEADER = "Location";
    public static final String HTTP_AUTHORIZATION_HEADER = "Authorization";
    public static final String HTTP_AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final String HTTP_USER_AGENT_HEADER = "User-Agent";
    public static final String HTTP_CONTENT_TYPE_HEADER = "Content-Type";
    public static final String HTTP_CONTENT_ENCODING_HEADER = "Content-Encoding";

    public static boolean isDowngradingProtocolOnRedirect(URL oldUrl, URL newUrl) {
        return HttpConstants.isHttpsProtocol(oldUrl) && !HttpConstants.isHttpsProtocol(newUrl);
    }

    public static boolean isHttpsProtocol(URL oldUrl) {
        return "https".equalsIgnoreCase(oldUrl.getProtocol());
    }

    public static boolean isHttpProtocol(URL oldUrl) {
        return "http".equalsIgnoreCase(oldUrl.getProtocol());
    }

    @Generated
    private HttpConstants() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum ResponseType {
        UNKNOWN,
        INFORMATIONAL,
        SUCCESSFUL,
        REDIRECTION,
        CLIENT_ERROR,
        SERVER_ERROR;


        public static ResponseType ofResponseCode(int code) {
            switch (code / 100) {
                case 1: {
                    return INFORMATIONAL;
                }
                case 2: {
                    return SUCCESSFUL;
                }
                case 3: {
                    return REDIRECTION;
                }
                case 4: {
                    return CLIENT_ERROR;
                }
                case 5: {
                    return SERVER_ERROR;
                }
            }
            return UNKNOWN;
        }
    }
}

