/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class HttpHeadersBuilder {
    private final List<Map.Entry<String, String>> data = new ArrayList<Map.Entry<String, String>>();
    private BiPredicate<String, String> filter = HttpHeadersBuilder::valueNotNullNorEmpty;
    private static final Collector<Map.Entry<String, String>, ?, Map<String, List<String>>> COLLECTOR = Collectors.collectingAndThen(Collectors.groupingBy(Map.Entry::getKey, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER), HttpHeadersBuilder.toUnmodifiableList(Map.Entry::getValue)), Collections::unmodifiableMap);

    private static boolean valueNotNullNorEmpty(String k, String v) {
        return v != null && !v.isEmpty();
    }

    @NonNull
    public HttpHeadersBuilder put(@NonNull Map<String, List<String>> headers) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        HttpHeadersBuilder.keyValues(headers).forEach(this.data::add);
        return this;
    }

    @NonNull
    public HttpHeadersBuilder put(@NonNull String key, @Nullable String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.data.add(HttpHeadersBuilder.headerOf(key, value));
        return this;
    }

    @NonNull
    public HttpHeadersBuilder filter(@NonNull BiPredicate<String, String> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        this.filter = filter;
        return this;
    }

    @NonNull
    public Map<String, List<String>> build() {
        return this.data.stream().filter((? super T header) -> this.filter.test((String)header.getKey(), (String)header.getValue())).collect(COLLECTOR);
    }

    private static <T, U> Collector<T, ?, List<U>> toUnmodifiableList(Function<? super T, ? extends U> mapper) {
        return Collectors.mapping(mapper, HttpHeadersBuilder.toUnmodifiableList());
    }

    private static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList);
    }

    private static @NonNull Map.Entry<String, String> headerOf(@NonNull String key, @Nullable String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
    }

    @NonNull
    public static Stream<Map.Entry<String, String>> keyValues(@NonNull Map<String, List<String>> headers) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return headers.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> HttpHeadersBuilder.headerOf((String)entry.getKey(), value)));
    }
}

