/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.http.HttpMethod;
import nbbrd.io.net.MediaType;
import org.jspecify.annotations.Nullable;

public final class HttpRequest {
    @NonNull
    private final HttpMethod method;
    @NonNull
    private final URL query;
    private final List<MediaType> mediaTypes;
    @NonNull
    private final String langs;
    private final byte[] body;

    @Generated
    private static HttpMethod $default$method() {
        return HttpMethod.GET;
    }

    @Generated
    private static String $default$langs() {
        return "";
    }

    @Generated
    private static byte[] $default$body() {
        return null;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().method(this.method).query(this.query).langs(this.langs).body(this.body);
        if (this.mediaTypes != null) {
            builder.mediaTypes(this.mediaTypes);
        }
        return builder;
    }

    @NonNull
    @Generated
    public HttpMethod getMethod() {
        return this.method;
    }

    @NonNull
    @Generated
    public URL getQuery() {
        return this.query;
    }

    @Generated
    public List<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    @NonNull
    @Generated
    public String getLangs() {
        return this.langs;
    }

    @Generated
    public byte[] getBody() {
        return this.body;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        URL this$query = this.getQuery();
        URL other$query = other.getQuery();
        if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
            return false;
        }
        List<MediaType> this$mediaTypes = this.getMediaTypes();
        List<MediaType> other$mediaTypes = other.getMediaTypes();
        if (this$mediaTypes == null ? other$mediaTypes != null : !((Object)this$mediaTypes).equals(other$mediaTypes)) {
            return false;
        }
        String this$langs = this.getLangs();
        String other$langs = other.getLangs();
        if (this$langs == null ? other$langs != null : !this$langs.equals(other$langs)) {
            return false;
        }
        return Arrays.equals(this.getBody(), other.getBody());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        URL $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
        List<MediaType> $mediaTypes = this.getMediaTypes();
        result = result * 59 + ($mediaTypes == null ? 43 : ((Object)$mediaTypes).hashCode());
        String $langs = this.getLangs();
        result = result * 59 + ($langs == null ? 43 : $langs.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "HttpRequest(method=" + (Object)((Object)this.getMethod()) + ", query=" + this.getQuery() + ", mediaTypes=" + this.getMediaTypes() + ", langs=" + this.getLangs() + ", body=" + Arrays.toString(this.getBody()) + ")";
    }

    @Generated
    private HttpRequest(@NonNull HttpMethod method, @NonNull URL query, List<MediaType> mediaTypes, @NonNull String langs, byte[] body) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (langs == null) {
            throw new NullPointerException("langs is marked non-null but is null");
        }
        this.method = method;
        this.query = query;
        this.mediaTypes = mediaTypes;
        this.langs = langs;
        this.body = body;
    }

    public static final class Builder {
        @Generated
        private boolean method$set;
        @Generated
        private HttpMethod method$value;
        @Generated
        private URL query;
        @Generated
        private ArrayList<MediaType> mediaTypes;
        @Generated
        private boolean langs$set;
        @Generated
        private String langs$value;
        @Generated
        private boolean body$set;
        @Generated
        private byte[] body$value;

        public Builder bodyOf(String content) {
            return this.body(content.getBytes(StandardCharsets.UTF_8));
        }

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder method(@NonNull HttpMethod method) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            this.method$value = method;
            this.method$set = true;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder query(@NonNull URL query) {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            this.query = query;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder mediaType(MediaType mediaType) {
            if (this.mediaTypes == null) {
                this.mediaTypes = new ArrayList();
            }
            this.mediaTypes.add(mediaType);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder mediaTypes(@org.jspecify.annotations.NonNull Collection<? extends MediaType> mediaTypes) {
            if (mediaTypes == null) {
                throw new NullPointerException("mediaTypes cannot be null");
            }
            if (this.mediaTypes == null) {
                this.mediaTypes = new ArrayList();
            }
            this.mediaTypes.addAll(mediaTypes);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearMediaTypes() {
            if (this.mediaTypes != null) {
                this.mediaTypes.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder langs(@NonNull String langs) {
            if (langs == null) {
                throw new NullPointerException("langs is marked non-null but is null");
            }
            this.langs$value = langs;
            this.langs$set = true;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder body(byte[] body) {
            this.body$value = body;
            this.body$set = true;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull HttpRequest build() {
            List<Object> mediaTypes;
            switch (this.mediaTypes == null ? 0 : this.mediaTypes.size()) {
                case 0: {
                    mediaTypes = Collections.emptyList();
                    break;
                }
                case 1: {
                    mediaTypes = Collections.singletonList(this.mediaTypes.get(0));
                    break;
                }
                default: {
                    mediaTypes = Collections.unmodifiableList(new ArrayList<MediaType>(this.mediaTypes));
                }
            }
            HttpMethod method$value = this.method$value;
            if (!this.method$set) {
                method$value = HttpRequest.$default$method();
            }
            String langs$value = this.langs$value;
            if (!this.langs$set) {
                langs$value = HttpRequest.$default$langs();
            }
            byte[] body$value = this.body$value;
            if (!this.body$set) {
                body$value = HttpRequest.$default$body();
            }
            return new HttpRequest(method$value, this.query, mediaTypes, langs$value, body$value);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "HttpRequest.Builder(method$value=" + (Object)((Object)this.method$value) + ", query=" + this.query + ", mediaTypes=" + this.mediaTypes + ", langs$value=" + this.langs$value + ", body$value=" + Arrays.toString(this.body$value) + ")";
        }
    }
}

