/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class HttpResponseException
extends IOException {
    private final int responseCode;
    private final String responseMessage;
    private final Map<String, List<String>> headerFields;

    public HttpResponseException(int responseCode, @Nullable String responseMessage) {
        this(responseCode, responseMessage, Collections.emptyMap());
    }

    public HttpResponseException(int responseCode, @Nullable String responseMessage, @NonNull Map<String, List<String>> headerFields) {
        super(responseCode + ": " + responseMessage);
        if (headerFields == null) {
            throw new NullPointerException("headerFields is marked non-null but is null");
        }
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.headerFields = headerFields;
    }

    @Generated
    public int getResponseCode() {
        return this.responseCode;
    }

    @Generated
    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Generated
    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }
}

