/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.win;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.sys.EndOfProcessException;
import nbbrd.io.sys.ProcessReader;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class RegWrapper {
    public static final String COMMAND = "reg";

    public static @org.checkerframework.checker.nullness.qual.NonNull Map<String, List<RegValue>> query(@org.checkerframework.checker.nullness.qual.NonNull String keyName, boolean recursive) throws IOException {
        Map<String, List<RegValue>> map;
        block9: {
            Objects.requireNonNull(keyName);
            BufferedReader reader = ProcessReader.newReader((String[])RegWrapper.getArgs(keyName, recursive));
            try {
                map = RegWrapper.parse(reader);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EndOfProcessException ex) {
                    if (ex.getExitValue() == 1) {
                        return Collections.emptyMap();
                    }
                    throw ex;
                }
            }
            reader.close();
        }
        return map;
    }

    @VisibleForTesting
    static String[] getArgs(String keyName, boolean recursive) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(COMMAND);
        args.add("query");
        args.add(keyName);
        if (recursive) {
            args.add("/s");
        }
        return args.toArray(new String[0]);
    }

    @VisibleForTesting
    static Map<String, List<RegValue>> parse(BufferedReader reader) throws IOException {
        String line;
        LinkedHashMap<String, List<RegValue>> result = new LinkedHashMap<String, List<RegValue>>();
        String subKey = null;
        ArrayList<RegValue> values = null;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty()) continue;
            if (subKey == null) {
                subKey = line;
                values = new ArrayList<RegValue>();
                continue;
            }
            RegValue regValue = RegValue.parseOrNull(line);
            if (regValue != null) {
                values.add(regValue);
                continue;
            }
            result.put(subKey, values);
            subKey = line;
            values = new ArrayList();
        }
        if (subKey != null) {
            result.put(subKey, values);
        }
        return result;
    }

    private RegWrapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum RegType {
        REG_SZ,
        REG_MULTI_SZ,
        REG_EXPAND_SZ,
        REG_DWORD,
        REG_QWORD,
        REG_BINARY,
        REG_NONE;

    }

    public static final class RegValue {
        private static final Pattern PATTERN = Pattern.compile("^[ ]{4}(.+)[ ]{4}(REG_(?:SZ|MULTI_SZ|EXPAND_SZ|DWORD|QWORD|BINARY|NONE))[ ]{4}(.*)$");
        @NonNull
        private final String name;
        @NonNull
        private final RegType dataType;
        @NonNull
        private final String value;

        @VisibleForTesting
        static @Nullable RegValue parseOrNull(@org.checkerframework.checker.nullness.qual.NonNull CharSequence line) {
            Matcher m = PATTERN.matcher(line);
            return m.matches() ? new RegValue(m.group(1), RegType.valueOf(m.group(2)), m.group(3)) : null;
        }

        public RegValue(@NonNull String name, @NonNull RegType dataType, @NonNull String value) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (dataType == null) {
                throw new NullPointerException("dataType is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.name = name;
            this.dataType = dataType;
            this.value = value;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public RegType getDataType() {
            return this.dataType;
        }

        @NonNull
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegValue)) {
                return false;
            }
            RegValue other = (RegValue)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            RegType this$dataType = this.getDataType();
            RegType other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            RegType $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "RegWrapper.RegValue(name=" + this.getName() + ", dataType=" + (Object)((Object)this.getDataType()) + ", value=" + this.getValue() + ")";
        }
    }
}

