/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.win;

import java.io.IOException;
import nbbrd.io.sys.EndOfProcessException;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class WhereWrapper {
    public static final String COMMAND = "where";
    private static final int SUCCESSFUL_EXIT_CODE = 0;
    private static final int UNSUCCESSFUL_EXIT_CODE = 1;
    private static final int ERRORS_EXIT_CODE = 2;

    public static boolean isAvailable(@NonNull String command) throws IOException {
        Process process = new ProcessBuilder(COMMAND, "/Q", command).start();
        try {
            switch (process.waitFor()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            throw EndOfProcessException.of((Process)process);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    private WhereWrapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

