/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.win;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;

public final class CScriptWrapper {
    public static final String COMMAND = "cscript";
    public static final short NO_TIMEOUT = -1;

    @NonNull
    public static Process exec(@NonNull Path script, short timeoutInSeconds, String ... args) throws IOException {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return CScriptWrapper.exec(script.toFile(), timeoutInSeconds, args);
    }

    @NonNull
    public static Process exec(@NonNull File script, short timeoutInSeconds, String ... args) throws IOException {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(COMMAND);
        result.add(script.getName());
        result.add("//NoLogo");
        if (timeoutInSeconds > 0) {
            result.add("//T:" + timeoutInSeconds);
        }
        result.addAll(Arrays.asList(args));
        return new ProcessBuilder(result).directory(script.getParentFile()).start();
    }

    @Generated
    private CScriptWrapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

