/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.xml;

import internal.io.text.LegacyFiles;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import lombok.NonNull;
import nbbrd.io.WrappedIOException;
import nbbrd.io.function.IORunnable;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.xml.Xml;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class Sax {
    private static final Logger log = Logger.getLogger(Sax.class.getName());
    private static final SAXParserFactory DEFAULT_FACTORY = Sax.initFactory();
    private static final DefaultHandler DEFAULT_HANDLER = new DefaultHandler();

    public static void preventXXE(@org.checkerframework.checker.nullness.qual.NonNull XMLReader reader) {
        Sax.setFeatureQuietly(reader, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        Sax.setFeatureQuietly(reader, "http://xml.org/sax/features/external-general-entities", false);
        Sax.setFeatureQuietly(reader, "http://xml.org/sax/features/external-parameter-entities", false);
    }

    public static @org.checkerframework.checker.nullness.qual.NonNull XMLReader createReader() throws IOException {
        try {
            return DEFAULT_FACTORY.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw WrappedIOException.wrap((Throwable)ex);
        }
        catch (SAXException ex) {
            throw Sax.toIOException(ex);
        }
    }

    public static InputSource newInputSource(File file) {
        return new InputSource(LegacyFiles.toSystemId((File)file));
    }

    public static InputSource newInputSource(File file, Charset encoding) {
        InputSource result = new InputSource(LegacyFiles.toSystemId((File)file));
        result.setEncoding(encoding.name());
        return result;
    }

    private static SAXParserFactory initFactory() {
        SAXParserFactory result = SAXParserFactory.newInstance();
        result.setNamespaceAware(true);
        return result;
    }

    private static void setFeatureQuietly(XMLReader reader, String feature, boolean value) {
        try {
            reader.setFeature(feature, value);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException ex) {
            log.log(Level.FINE, ex, () -> String.format("Failed to set feature '%s' to '%s'", feature, value));
        }
    }

    public static IOException toIOException(SAXException ex) {
        if (ex instanceof SAXParseException) {
            return Sax.toIOException((SAXParseException)ex);
        }
        return WrappedIOException.wrap((Throwable)ex);
    }

    private static IOException toIOException(SAXParseException ex) {
        if (Sax.isEOF(ex)) {
            return new EOFException(Objects.toString(Sax.getFile(ex)));
        }
        return WrappedIOException.wrap((Throwable)ex);
    }

    private static boolean isEOF(SAXParseException ex) {
        return ex.getMessage() != null && ex.getMessage().contains("end of file");
    }

    private static File getFile(SAXParseException ex) {
        String result = ex.getSystemId();
        return result != null && result.startsWith("file:/") ? LegacyFiles.fromSystemId((String)result) : null;
    }

    private Sax() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Parser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final IOSupplier<? extends XMLReader> factory;
        @NonNull
        private final ContentHandler contentHandler;
        @NonNull
        private final DTDHandler dtdHandler;
        @NonNull
        private final EntityResolver entityResolver;
        @NonNull
        private final ErrorHandler errorHandler;
        @NonNull
        private final IORunnable before;
        @NonNull
        private final IOSupplier<? extends T> after;
        private final boolean ignoreXXE;

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Parser<T> of(@org.checkerframework.checker.nullness.qual.NonNull ContentHandler handler, IOSupplier<? extends T> after) {
            Builder<? extends T> result = Parser.builder().contentHandler(handler);
            if (handler instanceof DTDHandler) {
                result.dtdHandler((DTDHandler)((Object)handler));
            }
            if (handler instanceof EntityResolver) {
                result.entityResolver((EntityResolver)((Object)handler));
            }
            if (handler instanceof ErrorHandler) {
                result.errorHandler((ErrorHandler)((Object)handler));
            }
            return result.after(after).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder().factory((IOSupplier<XMLReader>)((IOSupplier)Sax::createReader)).dtdHandler(DEFAULT_HANDLER).entityResolver(DEFAULT_HANDLER).errorHandler(DEFAULT_HANDLER).before(IORunnable.noOp()).ignoreXXE(false);
        }

        public T parseFile(File source) throws IOException {
            LegacyFiles.checkSource((File)source);
            return this.parse(Sax.newInputSource(source));
        }

        public T parseFile(File source, Charset encoding) throws IOException {
            LegacyFiles.checkSource((File)source);
            Objects.requireNonNull(encoding, "encoding");
            return this.parse(Sax.newInputSource(source, encoding));
        }

        public T parseReader(Reader resource) throws IOException {
            Objects.requireNonNull(resource, "resource");
            return this.parse(new InputSource(resource));
        }

        public T parseStream(InputStream resource) throws IOException {
            Objects.requireNonNull(resource, "resource");
            return this.parse(new InputSource(resource));
        }

        public T parseStream(InputStream resource, Charset encoding) throws IOException {
            Objects.requireNonNull(resource, "resource");
            Objects.requireNonNull(encoding, "encoding");
            InputSource input = new InputSource(resource);
            input.setEncoding(encoding.name());
            return this.parse(input);
        }

        private T parse(InputSource input) throws IOException {
            XMLReader engine = (XMLReader)this.factory.getWithIO();
            if (!this.ignoreXXE) {
                Sax.preventXXE(engine);
            }
            engine.setContentHandler(this.contentHandler);
            engine.setDTDHandler(this.dtdHandler);
            engine.setEntityResolver(this.entityResolver);
            engine.setErrorHandler(this.errorHandler);
            this.before.runWithIO();
            try {
                engine.parse(input);
            }
            catch (SAXException ex) {
                throw Sax.toIOException(ex);
            }
            return (T)this.after.getWithIO();
        }

        Parser(@NonNull IOSupplier<? extends XMLReader> factory, @NonNull ContentHandler contentHandler, @NonNull DTDHandler dtdHandler, @NonNull EntityResolver entityResolver, @NonNull ErrorHandler errorHandler, @NonNull IORunnable before, @NonNull IOSupplier<? extends T> after, boolean ignoreXXE) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            if (contentHandler == null) {
                throw new NullPointerException("contentHandler is marked non-null but is null");
            }
            if (dtdHandler == null) {
                throw new NullPointerException("dtdHandler is marked non-null but is null");
            }
            if (entityResolver == null) {
                throw new NullPointerException("entityResolver is marked non-null but is null");
            }
            if (errorHandler == null) {
                throw new NullPointerException("errorHandler is marked non-null but is null");
            }
            if (before == null) {
                throw new NullPointerException("before is marked non-null but is null");
            }
            if (after == null) {
                throw new NullPointerException("after is marked non-null but is null");
            }
            this.factory = factory;
            this.contentHandler = contentHandler;
            this.dtdHandler = dtdHandler;
            this.entityResolver = entityResolver;
            this.errorHandler = errorHandler;
            this.before = before;
            this.after = after;
            this.ignoreXXE = ignoreXXE;
        }

        public Builder<T> toBuilder() {
            return new Builder().factory(this.factory).contentHandler(this.contentHandler).dtdHandler(this.dtdHandler).entityResolver(this.entityResolver).errorHandler(this.errorHandler).before(this.before).after(this.after).ignoreXXE(this.ignoreXXE);
        }

        public Parser<T> withFactory(@NonNull IOSupplier<? extends XMLReader> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new Parser<T>(factory, this.contentHandler, this.dtdHandler, this.entityResolver, this.errorHandler, this.before, this.after, this.ignoreXXE);
        }

        public Parser<T> withContentHandler(@NonNull ContentHandler contentHandler) {
            if (contentHandler == null) {
                throw new NullPointerException("contentHandler is marked non-null but is null");
            }
            return this.contentHandler == contentHandler ? this : new Parser<T>(this.factory, contentHandler, this.dtdHandler, this.entityResolver, this.errorHandler, this.before, this.after, this.ignoreXXE);
        }

        public Parser<T> withDtdHandler(@NonNull DTDHandler dtdHandler) {
            if (dtdHandler == null) {
                throw new NullPointerException("dtdHandler is marked non-null but is null");
            }
            return this.dtdHandler == dtdHandler ? this : new Parser<T>(this.factory, this.contentHandler, dtdHandler, this.entityResolver, this.errorHandler, this.before, this.after, this.ignoreXXE);
        }

        public Parser<T> withEntityResolver(@NonNull EntityResolver entityResolver) {
            if (entityResolver == null) {
                throw new NullPointerException("entityResolver is marked non-null but is null");
            }
            return this.entityResolver == entityResolver ? this : new Parser<T>(this.factory, this.contentHandler, this.dtdHandler, entityResolver, this.errorHandler, this.before, this.after, this.ignoreXXE);
        }

        public Parser<T> withErrorHandler(@NonNull ErrorHandler errorHandler) {
            if (errorHandler == null) {
                throw new NullPointerException("errorHandler is marked non-null but is null");
            }
            return this.errorHandler == errorHandler ? this : new Parser<T>(this.factory, this.contentHandler, this.dtdHandler, this.entityResolver, errorHandler, this.before, this.after, this.ignoreXXE);
        }

        public Parser<T> withBefore(@NonNull IORunnable before) {
            if (before == null) {
                throw new NullPointerException("before is marked non-null but is null");
            }
            return this.before == before ? this : new Parser<T>(this.factory, this.contentHandler, this.dtdHandler, this.entityResolver, this.errorHandler, before, this.after, this.ignoreXXE);
        }

        public Parser<T> withAfter(@NonNull IOSupplier<? extends T> after) {
            if (after == null) {
                throw new NullPointerException("after is marked non-null but is null");
            }
            return this.after == after ? this : new Parser<T>(this.factory, this.contentHandler, this.dtdHandler, this.entityResolver, this.errorHandler, this.before, after, this.ignoreXXE);
        }

        public Parser<T> withIgnoreXXE(boolean ignoreXXE) {
            return this.ignoreXXE == ignoreXXE ? this : new Parser<T>(this.factory, this.contentHandler, this.dtdHandler, this.entityResolver, this.errorHandler, this.before, this.after, ignoreXXE);
        }

        @Override
        public boolean isIgnoreXXE() {
            return this.ignoreXXE;
        }

        public static final class Builder<T> {
            private IOSupplier<? extends XMLReader> factory;
            private ContentHandler contentHandler;
            private DTDHandler dtdHandler;
            private EntityResolver entityResolver;
            private ErrorHandler errorHandler;
            private IORunnable before;
            private IOSupplier<? extends T> after;
            private boolean ignoreXXE;

            Builder() {
            }

            public Builder<T> factory(@NonNull IOSupplier<? extends XMLReader> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory = factory;
                return this;
            }

            public Builder<T> contentHandler(@NonNull ContentHandler contentHandler) {
                if (contentHandler == null) {
                    throw new NullPointerException("contentHandler is marked non-null but is null");
                }
                this.contentHandler = contentHandler;
                return this;
            }

            public Builder<T> dtdHandler(@NonNull DTDHandler dtdHandler) {
                if (dtdHandler == null) {
                    throw new NullPointerException("dtdHandler is marked non-null but is null");
                }
                this.dtdHandler = dtdHandler;
                return this;
            }

            public Builder<T> entityResolver(@NonNull EntityResolver entityResolver) {
                if (entityResolver == null) {
                    throw new NullPointerException("entityResolver is marked non-null but is null");
                }
                this.entityResolver = entityResolver;
                return this;
            }

            public Builder<T> errorHandler(@NonNull ErrorHandler errorHandler) {
                if (errorHandler == null) {
                    throw new NullPointerException("errorHandler is marked non-null but is null");
                }
                this.errorHandler = errorHandler;
                return this;
            }

            public Builder<T> before(@NonNull IORunnable before) {
                if (before == null) {
                    throw new NullPointerException("before is marked non-null but is null");
                }
                this.before = before;
                return this;
            }

            public Builder<T> after(@NonNull IOSupplier<? extends T> after) {
                if (after == null) {
                    throw new NullPointerException("after is marked non-null but is null");
                }
                this.after = after;
                return this;
            }

            public Builder<T> ignoreXXE(boolean ignoreXXE) {
                this.ignoreXXE = ignoreXXE;
                return this;
            }

            public Parser<T> build() {
                return new Parser<T>(this.factory, this.contentHandler, this.dtdHandler, this.entityResolver, this.errorHandler, this.before, this.after, this.ignoreXXE);
            }

            public String toString() {
                return "Sax.Parser.Builder(factory=" + this.factory + ", contentHandler=" + this.contentHandler + ", dtdHandler=" + this.dtdHandler + ", entityResolver=" + this.entityResolver + ", errorHandler=" + this.errorHandler + ", before=" + this.before + ", after=" + this.after + ", ignoreXXE=" + this.ignoreXXE + ")";
            }
        }
    }
}

