/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.xml.bind;

import internal.io.text.LegacyFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.WrappedIOException;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.xml.Sax;
import nbbrd.io.xml.Stax;
import nbbrd.io.xml.Xml;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Jaxb {
    public static @org.checkerframework.checker.nullness.qual.NonNull Unmarshaller createUnmarshaller(@org.checkerframework.checker.nullness.qual.NonNull Class<?> type) throws IOException {
        Objects.requireNonNull(type);
        try {
            return JAXBContext.newInstance((Class[])new Class[]{type}).createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw Jaxb.toIOException(ex);
        }
    }

    public static @org.checkerframework.checker.nullness.qual.NonNull Unmarshaller createUnmarshaller(@org.checkerframework.checker.nullness.qual.NonNull JAXBContext context) throws IOException {
        Objects.requireNonNull(context);
        try {
            return context.createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw Jaxb.toIOException(ex);
        }
    }

    public static @org.checkerframework.checker.nullness.qual.NonNull Marshaller createMarshaller(@org.checkerframework.checker.nullness.qual.NonNull Class<?> type) throws IOException {
        Objects.requireNonNull(type);
        try {
            return JAXBContext.newInstance((Class[])new Class[]{type}).createMarshaller();
        }
        catch (JAXBException ex) {
            throw Jaxb.toIOException(ex);
        }
    }

    public static @org.checkerframework.checker.nullness.qual.NonNull Marshaller createMarshaller(@org.checkerframework.checker.nullness.qual.NonNull JAXBContext context) throws IOException {
        Objects.requireNonNull(context);
        try {
            return context.createMarshaller();
        }
        catch (JAXBException ex) {
            throw Jaxb.toIOException(ex);
        }
    }

    private static IOException toIOException(JAXBException ex) {
        if (Jaxb.hasLinkedException(ex)) {
            if (ex.getCause() instanceof XMLStreamException) {
                return Stax.toIOException((XMLStreamException)ex.getCause());
            }
            if (ex.getCause() instanceof SAXParseException) {
                return Sax.toIOException((SAXException)((SAXParseException)ex.getCause()));
            }
        }
        return WrappedIOException.wrap((Throwable)ex);
    }

    private static boolean hasLinkedException(JAXBException ex) {
        return ex.getCause() != null && ex.getMessage() == null;
    }

    @Generated
    private Jaxb() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Formatter<T>
    implements Xml.Formatter<T> {
        @NonNull
        private final IOSupplier<? extends Marshaller> factory;
        private final boolean formatted;
        @NonNull
        private final Charset encoding;

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Formatter<T> of(@org.checkerframework.checker.nullness.qual.NonNull Class<T> type) throws IOException {
            Objects.requireNonNull(type);
            return Formatter.builder().factory((IOSupplier<Marshaller>)((IOSupplier)() -> Jaxb.createMarshaller(type))).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Formatter<T> of(@org.checkerframework.checker.nullness.qual.NonNull JAXBContext context) throws IOException {
            Objects.requireNonNull(context);
            return Formatter.builder().factory((IOSupplier<Marshaller>)((IOSupplier)() -> Jaxb.createMarshaller(context))).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder().formatted(false).encoding(StandardCharsets.UTF_8);
        }

        @Override
        public Charset getDefaultEncoding() {
            return this.encoding;
        }

        public void formatFile(T value, File target) throws IOException {
            Objects.requireNonNull(value, "value");
            LegacyFiles.checkTarget((File)target);
            try {
                this.getEngine(this.getDefaultEncoding()).marshal(value, target);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        public void formatWriter(T value, Writer resource) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(resource, "resource");
            try {
                this.getEngine(this.getDefaultEncoding()).marshal(value, resource);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        public void formatStream(T value, OutputStream resource) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(resource, "resource");
            try {
                this.getEngine(this.getDefaultEncoding()).marshal(value, resource);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        public void formatStream(T value, OutputStream resource, Charset encoding) throws IOException {
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(resource, "resource");
            Objects.requireNonNull(encoding, "encoding");
            try {
                this.getEngine(encoding).marshal(value, resource);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        private Marshaller getEngine(Charset selectedEncoding) throws PropertyException, IOException {
            Marshaller result = (Marshaller)this.factory.getWithIO();
            result.setProperty("jaxb.formatted.output", (Object)this.formatted);
            result.setProperty("jaxb.encoding", (Object)selectedEncoding.name());
            return result;
        }

        @Generated
        Formatter(@NonNull IOSupplier<? extends Marshaller> factory, boolean formatted, @NonNull Charset encoding) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.factory = factory;
            this.formatted = formatted;
            this.encoding = encoding;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder().factory(this.factory).formatted(this.formatted).encoding(this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Formatter<T> withFactory(@NonNull IOSupplier<? extends Marshaller> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new Formatter<T>(factory, this.formatted, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Formatter<T> withFormatted(boolean formatted) {
            return this.formatted == formatted ? this : new Formatter<T>(this.factory, formatted, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Formatter<T> withEncoding(@NonNull Charset encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return this.encoding == encoding ? this : new Formatter<T>(this.factory, this.formatted, encoding);
        }

        @Override
        @Generated
        public boolean isFormatted() {
            return this.formatted;
        }

        public static final class Builder<T> {
            @Generated
            private IOSupplier<? extends Marshaller> factory;
            @Generated
            private boolean formatted;
            @Generated
            private Charset encoding;

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends Marshaller> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory = factory;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> formatted(boolean formatted) {
                this.formatted = formatted;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> encoding(@NonNull Charset encoding) {
                if (encoding == null) {
                    throw new NullPointerException("encoding is marked non-null but is null");
                }
                this.encoding = encoding;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Formatter<T> build() {
                return new Formatter(this.factory, this.formatted, this.encoding);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Jaxb.Formatter.Builder(factory=" + this.factory + ", formatted=" + this.formatted + ", encoding=" + this.encoding + ")";
            }
        }
    }

    public static final class Parser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final IOSupplier<? extends Unmarshaller> factory;
        private final boolean ignoreXXE;
        @NonNull
        private final IOSupplier<? extends XMLInputFactory> xxeFactory;

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Parser<T> of(@org.checkerframework.checker.nullness.qual.NonNull Class<T> type) throws IOException {
            Objects.requireNonNull(type);
            return Parser.builder().factory((IOSupplier<Unmarshaller>)((IOSupplier)() -> Jaxb.createUnmarshaller(type))).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Parser<T> of(@org.checkerframework.checker.nullness.qual.NonNull JAXBContext context) throws IOException {
            Objects.requireNonNull(context);
            return Parser.builder().factory((IOSupplier<Unmarshaller>)((IOSupplier)() -> Jaxb.createUnmarshaller(context))).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder().ignoreXXE(false).xxeFactory((IOSupplier<XMLInputFactory>)((IOSupplier)Parser::getStaxFactory));
        }

        public T parseFile(File source) throws IOException {
            LegacyFiles.checkSource((File)source);
            Unmarshaller engine = (Unmarshaller)this.factory.getWithIO();
            return !this.ignoreXXE ? Parser.parseFileXXE(engine, source, (XMLInputFactory)this.xxeFactory.getWithIO()) : Parser.parseFile(engine, source);
        }

        public T parseFile(File source, Charset encoding) throws IOException {
            LegacyFiles.checkSource((File)source);
            Objects.requireNonNull(encoding, "encoding");
            Unmarshaller engine = (Unmarshaller)this.factory.getWithIO();
            return !this.ignoreXXE ? Parser.parseFileXXE(engine, source, (XMLInputFactory)this.xxeFactory.getWithIO()) : Parser.parseFile(engine, source, encoding);
        }

        public T parseReader(Reader resource) throws IOException {
            Objects.requireNonNull(resource, "resource");
            Unmarshaller engine = (Unmarshaller)this.factory.getWithIO();
            return !this.ignoreXXE ? Parser.parseReaderXXE(engine, resource, (XMLInputFactory)this.xxeFactory.getWithIO()) : Parser.parseReader(engine, resource);
        }

        public T parseStream(InputStream resource) throws IOException {
            Objects.requireNonNull(resource, "resource");
            Unmarshaller engine = (Unmarshaller)this.factory.getWithIO();
            return !this.ignoreXXE ? Parser.parseStreamXXE(engine, resource, (XMLInputFactory)this.xxeFactory.getWithIO()) : Parser.parseStream(engine, resource);
        }

        public T parseStream(InputStream resource, Charset encoding) throws IOException {
            Objects.requireNonNull(resource, "resource");
            Objects.requireNonNull(encoding, "encoding");
            Unmarshaller engine = (Unmarshaller)this.factory.getWithIO();
            return !this.ignoreXXE ? Parser.parseStreamXXE(engine, resource, (XMLInputFactory)this.xxeFactory.getWithIO()) : Parser.parseStream(engine, resource);
        }

        private static XMLInputFactory getStaxFactory() {
            XMLInputFactory result = XMLInputFactory.newFactory();
            Stax.preventXXE(result);
            return result;
        }

        private static <T> T parseFile(Unmarshaller engine, File source) throws IOException {
            try {
                return (T)engine.unmarshal(Sax.newInputSource(source));
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        private static <T> T parseFile(Unmarshaller engine, File source, Charset encoding) throws IOException {
            try {
                return (T)engine.unmarshal(Sax.newInputSource(source, encoding));
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        private static <T> T parseReader(Unmarshaller engine, Reader resource) throws IOException {
            try {
                return (T)engine.unmarshal(resource);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        private static <T> T parseStream(Unmarshaller engine, InputStream resource) throws IOException {
            try {
                return (T)engine.unmarshal(resource);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        private static <T> T parseFileXXE(Unmarshaller engine, File source, XMLInputFactory xxe) throws IOException {
            try (InputStream resource = LegacyFiles.newInputStream((File)source);){
                Object object;
                XMLStreamReader reader = xxe.createXMLStreamReader(LegacyFiles.toSystemId((File)source), resource);
                try {
                    object = engine.unmarshal(reader);
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return (T)object;
            }
            catch (XMLStreamException ex) {
                throw Stax.toIOException(ex);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static <T> T parseReaderXXE(Unmarshaller engine, Reader resource, XMLInputFactory xxe) throws IOException {
            try (XMLStreamReader reader = xxe.createXMLStreamReader(resource);){
                Object object = engine.unmarshal(reader);
                return (T)object;
            }
            catch (XMLStreamException ex) {
                throw Stax.toIOException(ex);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static <T> T parseStreamXXE(Unmarshaller engine, InputStream resource, XMLInputFactory xxe) throws IOException {
            try (XMLStreamReader reader = xxe.createXMLStreamReader(resource);){
                Object object = engine.unmarshal(reader);
                return (T)object;
            }
            catch (XMLStreamException ex) {
                throw Stax.toIOException(ex);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        @Generated
        Parser(@NonNull IOSupplier<? extends Unmarshaller> factory, boolean ignoreXXE, @NonNull IOSupplier<? extends XMLInputFactory> xxeFactory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            if (xxeFactory == null) {
                throw new NullPointerException("xxeFactory is marked non-null but is null");
            }
            this.factory = factory;
            this.ignoreXXE = ignoreXXE;
            this.xxeFactory = xxeFactory;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder().factory(this.factory).ignoreXXE(this.ignoreXXE).xxeFactory(this.xxeFactory);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withFactory(@NonNull IOSupplier<? extends Unmarshaller> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new Parser<T>(factory, this.ignoreXXE, this.xxeFactory);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withIgnoreXXE(boolean ignoreXXE) {
            return this.ignoreXXE == ignoreXXE ? this : new Parser<T>(this.factory, ignoreXXE, this.xxeFactory);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withXxeFactory(@NonNull IOSupplier<? extends XMLInputFactory> xxeFactory) {
            if (xxeFactory == null) {
                throw new NullPointerException("xxeFactory is marked non-null but is null");
            }
            return this.xxeFactory == xxeFactory ? this : new Parser<T>(this.factory, this.ignoreXXE, xxeFactory);
        }

        @Override
        @Generated
        public boolean isIgnoreXXE() {
            return this.ignoreXXE;
        }

        public static final class Builder<T> {
            @Generated
            private IOSupplier<? extends Unmarshaller> factory;
            @Generated
            private boolean ignoreXXE;
            @Generated
            private IOSupplier<? extends XMLInputFactory> xxeFactory;

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends Unmarshaller> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory = factory;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> ignoreXXE(boolean ignoreXXE) {
                this.ignoreXXE = ignoreXXE;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> xxeFactory(@NonNull IOSupplier<? extends XMLInputFactory> xxeFactory) {
                if (xxeFactory == null) {
                    throw new NullPointerException("xxeFactory is marked non-null but is null");
                }
                this.xxeFactory = xxeFactory;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> build() {
                return new Parser(this.factory, this.ignoreXXE, this.xxeFactory);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Jaxb.Parser.Builder(factory=" + this.factory + ", ignoreXXE=" + this.ignoreXXE + ", xxeFactory=" + this.xxeFactory + ")";
            }
        }
    }
}

