/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.FileFormatter;
import nbbrd.io.FileParser;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.text.TextFormatter;
import nbbrd.io.text.TextParser;

public final class Xml {
    @Generated
    private Xml() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class AdaptedFormatter<V>
    implements Formatter<V> {
        @NonNull
        private final Formatter<?> delegate;
        @NonNull
        private final FileFormatter<V> fileFormatter;
        @NonNull
        private final TextFormatter<V> textFormatter;

        @Override
        public boolean isFormatted() {
            return this.delegate.isFormatted();
        }

        @Override
        public Charset getDefaultEncoding() {
            return this.delegate.getDefaultEncoding();
        }

        public void formatFile(@org.checkerframework.checker.nullness.qual.NonNull V value, @org.checkerframework.checker.nullness.qual.NonNull File target) throws IOException {
            this.fileFormatter.formatFile(value, target);
        }

        public void formatPath(@org.checkerframework.checker.nullness.qual.NonNull V value, @org.checkerframework.checker.nullness.qual.NonNull Path target) throws IOException {
            this.fileFormatter.formatPath(value, target);
        }

        public void formatStream(@org.checkerframework.checker.nullness.qual.NonNull V value, IOSupplier<? extends OutputStream> target) throws IOException {
            this.fileFormatter.formatStream(value, target);
        }

        public void formatStream(@org.checkerframework.checker.nullness.qual.NonNull V value, @org.checkerframework.checker.nullness.qual.NonNull OutputStream resource) throws IOException {
            this.fileFormatter.formatStream(value, resource);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull String formatToString(@org.checkerframework.checker.nullness.qual.NonNull V value) throws IOException {
            return this.textFormatter.formatToString(value);
        }

        public void formatChars(@org.checkerframework.checker.nullness.qual.NonNull V value, @org.checkerframework.checker.nullness.qual.NonNull Appendable target) throws IOException {
            this.textFormatter.formatChars(value, target);
        }

        public void formatFile(@org.checkerframework.checker.nullness.qual.NonNull V value, @org.checkerframework.checker.nullness.qual.NonNull File target, @org.checkerframework.checker.nullness.qual.NonNull Charset encoding) throws IOException {
            this.textFormatter.formatFile(value, target, encoding);
        }

        public void formatPath(@org.checkerframework.checker.nullness.qual.NonNull V value, @org.checkerframework.checker.nullness.qual.NonNull Path target, @org.checkerframework.checker.nullness.qual.NonNull Charset encoding) throws IOException {
            this.textFormatter.formatPath(value, target, encoding);
        }

        public void formatWriter(@org.checkerframework.checker.nullness.qual.NonNull V value, IOSupplier<? extends Writer> target) throws IOException {
            this.textFormatter.formatWriter(value, target);
        }

        public void formatStream(@org.checkerframework.checker.nullness.qual.NonNull V value, IOSupplier<? extends OutputStream> target, @org.checkerframework.checker.nullness.qual.NonNull Charset encoding) throws IOException {
            this.textFormatter.formatStream(value, target, encoding);
        }

        public void formatWriter(@org.checkerframework.checker.nullness.qual.NonNull V value, @org.checkerframework.checker.nullness.qual.NonNull Writer resource) throws IOException {
            this.textFormatter.formatWriter(value, resource);
        }

        public void formatStream(@org.checkerframework.checker.nullness.qual.NonNull V value, @org.checkerframework.checker.nullness.qual.NonNull OutputStream resource, @org.checkerframework.checker.nullness.qual.NonNull Charset encoding) throws IOException {
            this.textFormatter.formatStream(value, resource, encoding);
        }

        @Generated
        public AdaptedFormatter(@NonNull Formatter<?> delegate, @NonNull FileFormatter<V> fileFormatter, @NonNull TextFormatter<V> textFormatter) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (fileFormatter == null) {
                throw new NullPointerException("fileFormatter is marked non-null but is null");
            }
            if (textFormatter == null) {
                throw new NullPointerException("textFormatter is marked non-null but is null");
            }
            this.delegate = delegate;
            this.fileFormatter = fileFormatter;
            this.textFormatter = textFormatter;
        }
    }

    private static final class AdaptedParser<V>
    implements Parser<V> {
        @NonNull
        private final Parser<?> delegate;
        @NonNull
        private final FileParser<V> fileParser;
        @NonNull
        private final TextParser<V> textParser;

        @Override
        public boolean isIgnoreXXE() {
            return this.delegate.isIgnoreXXE();
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parseFile(@org.checkerframework.checker.nullness.qual.NonNull File source) throws IOException {
            return (V)this.fileParser.parseFile(source);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parsePath(@org.checkerframework.checker.nullness.qual.NonNull Path source) throws IOException {
            return (V)this.fileParser.parsePath(source);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parseResource(@org.checkerframework.checker.nullness.qual.NonNull Class<?> type, @org.checkerframework.checker.nullness.qual.NonNull String name) throws IOException {
            return (V)this.fileParser.parseResource(type, name);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parseStream(IOSupplier<? extends InputStream> source) throws IOException {
            return (V)this.fileParser.parseStream(source);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parseStream(@org.checkerframework.checker.nullness.qual.NonNull InputStream resource) throws IOException {
            return (V)this.fileParser.parseStream(resource);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parseChars(@org.checkerframework.checker.nullness.qual.NonNull CharSequence source) throws IOException {
            return (V)this.textParser.parseChars(source);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parseFile(@org.checkerframework.checker.nullness.qual.NonNull File source, @org.checkerframework.checker.nullness.qual.NonNull Charset encoding) throws IOException {
            return (V)this.textParser.parseFile(source, encoding);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parsePath(@org.checkerframework.checker.nullness.qual.NonNull Path source, @org.checkerframework.checker.nullness.qual.NonNull Charset encoding) throws IOException {
            return (V)this.textParser.parsePath(source, encoding);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parseResource(@org.checkerframework.checker.nullness.qual.NonNull Class<?> type, @org.checkerframework.checker.nullness.qual.NonNull String name, @org.checkerframework.checker.nullness.qual.NonNull Charset encoding) throws IOException {
            return (V)this.textParser.parseResource(type, name, encoding);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parseReader(IOSupplier<? extends Reader> source) throws IOException {
            return (V)this.textParser.parseReader(source);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parseStream(IOSupplier<? extends InputStream> source, @org.checkerframework.checker.nullness.qual.NonNull Charset encoding) throws IOException {
            return (V)this.textParser.parseStream(source, encoding);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parseReader(@org.checkerframework.checker.nullness.qual.NonNull Reader resource) throws IOException {
            return (V)this.textParser.parseReader(resource);
        }

        public @org.checkerframework.checker.nullness.qual.NonNull V parseStream(@org.checkerframework.checker.nullness.qual.NonNull InputStream resource, @org.checkerframework.checker.nullness.qual.NonNull Charset encoding) throws IOException {
            return (V)this.textParser.parseStream(resource, encoding);
        }

        @Generated
        public AdaptedParser(@NonNull Parser<?> delegate, @NonNull FileParser<V> fileParser, @NonNull TextParser<V> textParser) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (fileParser == null) {
                throw new NullPointerException("fileParser is marked non-null but is null");
            }
            if (textParser == null) {
                throw new NullPointerException("textParser is marked non-null but is null");
            }
            this.delegate = delegate;
            this.fileParser = fileParser;
            this.textParser = textParser;
        }
    }

    public static interface Formatter<T>
    extends FileFormatter<T>,
    TextFormatter<T> {
        public boolean isFormatted();

        public @org.checkerframework.checker.nullness.qual.NonNull Charset getDefaultEncoding();

        default public <V> @org.checkerframework.checker.nullness.qual.NonNull Formatter<V> compose(@org.checkerframework.checker.nullness.qual.NonNull Function<? super V, ? extends T> before) {
            return new AdaptedFormatter(this, super.compose(before), super.compose(before));
        }
    }

    public static interface Parser<T>
    extends FileParser<T>,
    TextParser<T> {
        public boolean isIgnoreXXE();

        default public <V> @org.checkerframework.checker.nullness.qual.NonNull Parser<V> andThen(@org.checkerframework.checker.nullness.qual.NonNull Function<? super T, ? extends V> after) {
            return new AdaptedParser(this, super.andThen(after), super.andThen(after));
        }
    }
}

