/*
 * Decompiled with CFR 0.152.
 */
package _test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;

public class Meta<T> {
    private final String name;
    private final Class<? extends Throwable> expectedException;
    private final T target;

    public String toString() {
        return this.name;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static Class<? extends Throwable> lookupExpectedException(Meta<?> ... list) {
        return Stream.of(list).map(Meta::getExpectedException).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Generated
    public Meta(String name, Class<? extends Throwable> expectedException, T target) {
        this.name = name;
        this.expectedException = expectedException;
        this.target = target;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Class<? extends Throwable> getExpectedException() {
        return this.expectedException;
    }

    @Generated
    public T getTarget() {
        return this.target;
    }

    public static final class ExceptionStep<T> {
        private final Class<? extends Throwable> ex;
        private final Builder<T> builder;
        private String name = "";

        public ExceptionStep<T> as(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> isThrownBy(T target) {
            return this.builder.invalid(this.name, target, this.ex);
        }

        @Generated
        public ExceptionStep(Class<? extends Throwable> ex, Builder<T> builder) {
            this.ex = ex;
            this.builder = builder;
        }
    }

    public static final class CodeStep<T> {
        private final Builder<T> builder;
        private String name = "";

        public CodeStep<T> as(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> xxx() {
            return this.builder;
        }

        public Builder<T> doesNotRaiseExceptionWhen(T target) {
            return this.builder.valid(this.name, target);
        }

        @Generated
        public CodeStep(Builder<T> builder) {
            this.builder = builder;
        }
    }

    public static final class Builder<T> {
        private final List<Meta<T>> result = new ArrayList<Meta<T>>();
        private String group = "";

        private Builder<T> addItem(String name, T target, Class<? extends Throwable> expectedException) {
            this.result.add(new Meta<T>(this.group + (this.group.isEmpty() ? "" : "/") + name, expectedException, target));
            return this;
        }

        public Builder<T> group(String group) {
            this.group = group;
            return this;
        }

        public Builder<T> valid(String name, T target) {
            return this.of(name, false, target);
        }

        public Builder<T> invalid(String name, T target) {
            return this.of(name, true, target);
        }

        public Builder<T> invalid(String name, T target, Class<? extends Throwable> expectedException) {
            return this.addItem(name, target, expectedException);
        }

        public Builder<T> of(String name, boolean invalid, T target) {
            return this.addItem(name, target, invalid ? Throwable.class : null);
        }

        public CodeStep<T> code() {
            return new CodeStep(this);
        }

        public ExceptionStep<T> exception(Class<? extends Throwable> ex) {
            return new ExceptionStep(ex, this);
        }

        public List<Meta<T>> build() {
            return Collections.unmodifiableList(new ArrayList<Meta<T>>(this.result));
        }
    }
}

