/*
 * Decompiled with CFR 0.152.
 */
package _test.sample;

import _test.Meta;
import _test.ResourceCounter;
import _test.sample.Person;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import nbbrd.io.function.IORunnable;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.xml.Xml;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssertAlternative;
import org.junit.rules.TemporaryFolder;

public class FormatAssertions {
    public static void assertFormatterCompliance(Xml.Formatter<Person> p, boolean formatted, TemporaryFolder temp) throws IOException {
        FormatAssertions.testFormatToString(p, formatted);
        FormatAssertions.testFormatChars(p, formatted);
        FormatAssertions.testFormatFile(p, formatted, temp);
        FormatAssertions.testFormatFileCharset(p, formatted, temp);
        FormatAssertions.testFormatPath(p, formatted, temp);
        FormatAssertions.testFormatPathCharset(p, formatted, temp);
        FormatAssertions.testFormatWriterFromSupplier(p, formatted);
        FormatAssertions.testFormatStreamFromSupplier(p, formatted);
        FormatAssertions.testFormatStreamFromSupplierCharset(p, formatted);
        FormatAssertions.testFormatWriter(p, formatted);
        FormatAssertions.testFormatStream(p, formatted);
        FormatAssertions.testFormatStreamCharset(p, formatted);
    }

    private static void testFormatToString(Xml.Formatter<Person> p, boolean formatted) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatToString(null)).withMessageContaining("value");
        Assertions.assertThat((String)p.formatToString((Object)Person.JOHN_DOE)).isEqualTo(Person.getString(StandardCharsets.UTF_8, formatted));
    }

    private static void testFormatChars(Xml.Formatter<Person> p, boolean formatted) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatChars(null, (Appendable)new StringBuilder())).withMessageContaining("value");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatChars((Object)Person.JOHN_DOE, null));
        StringBuilder appendable = new StringBuilder();
        p.formatChars((Object)Person.JOHN_DOE, (Appendable)appendable);
        Assertions.assertThat((String)appendable.toString()).isEqualTo(Person.getString(StandardCharsets.UTF_8, formatted));
    }

    private static void testFormatFile(Xml.Formatter<Person> p, boolean formatted, TemporaryFolder temp) throws IOException {
        File target = temp.newFile();
        target.delete();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(null, target)).withMessageContaining("value");
        Assertions.assertThat((File)target).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile((Object)Person.JOHN_DOE, null)).withMessageContaining("target");
        Assertions.assertThat((File)target).doesNotExist();
        p.formatFile((Object)Person.JOHN_DOE, target);
        Assertions.assertThat((File)target).exists().isFile();
        Assertions.assertThat((File)target).usingCharset(StandardCharsets.UTF_8).hasContent(Person.getString(StandardCharsets.UTF_8, formatted));
        Assertions.assertThatIOException().isThrownBy(() -> p.formatFile((Object)Person.JOHN_DOE, temp.newFolder())).isInstanceOf(AccessDeniedException.class);
    }

    private static void testFormatFileCharset(Xml.Formatter<Person> p, boolean formatted, TemporaryFolder temp) throws IOException {
        File target = temp.newFile();
        target.delete();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(null, target, StandardCharsets.UTF_8)).withMessageContaining("value");
        Assertions.assertThat((File)target).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile((Object)Person.JOHN_DOE, null, StandardCharsets.UTF_8)).withMessageContaining("target");
        Assertions.assertThat((File)target).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile((Object)Person.JOHN_DOE, target, null)).withMessageContaining("encoding");
        Assertions.assertThat((File)target).doesNotExist();
        Assertions.assertThatIOException().isThrownBy(() -> p.formatFile((Object)Person.JOHN_DOE, temp.newFolder(), StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class);
        for (Charset encoding : Person.ENCODINGS) {
            p.formatFile((Object)Person.JOHN_DOE, target, encoding);
            Assertions.assertThat((File)target).exists().isFile();
            Assertions.assertThat((File)target).usingCharset(encoding).hasContent(Person.getString(encoding, formatted));
        }
    }

    private static void testFormatPath(Xml.Formatter<Person> p, boolean formatted, TemporaryFolder temp) throws IOException {
        Path target = temp.newFile().toPath();
        Files.delete(target);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(null, target)).withMessageContaining("value");
        Assertions.assertThat((Path)target).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath((Object)Person.JOHN_DOE, null)).withMessageContaining("target");
        Assertions.assertThat((Path)target).doesNotExist();
        p.formatPath((Object)Person.JOHN_DOE, target);
        Assertions.assertThat((Path)target).exists().isReadable();
        Assertions.assertThat((Path)target).usingCharset(StandardCharsets.UTF_8).hasContent(Person.getString(StandardCharsets.UTF_8, formatted));
        Assertions.assertThatIOException().isThrownBy(() -> p.formatPath((Object)Person.JOHN_DOE, temp.newFolder().toPath())).isInstanceOf(AccessDeniedException.class);
    }

    private static void testFormatPathCharset(Xml.Formatter<Person> p, boolean formatted, TemporaryFolder temp) throws IOException {
        Path target = temp.newFile().toPath();
        Files.delete(target);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(null, target, StandardCharsets.UTF_8)).withMessageContaining("value");
        Assertions.assertThat((Path)target).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath((Object)Person.JOHN_DOE, null, StandardCharsets.UTF_8)).withMessageContaining("target");
        Assertions.assertThat((Path)target).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath((Object)Person.JOHN_DOE, target, null)).withMessageContaining("encoding");
        Assertions.assertThat((Path)target).doesNotExist();
        Assertions.assertThatIOException().isThrownBy(() -> p.formatPath((Object)Person.JOHN_DOE, temp.newFolder().toPath(), StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class);
        for (Charset encoding : Person.ENCODINGS) {
            p.formatPath((Object)Person.JOHN_DOE, target, encoding);
            Assertions.assertThat((Path)target).exists().isReadable();
            Assertions.assertThat((Path)target).usingCharset(encoding).hasContent(Person.getString(encoding, formatted));
        }
    }

    private static void testFormatWriterFromSupplier(Xml.Formatter<Person> p, boolean formatted) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter(null, StringWriter::new)).withMessageContaining("value");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter((Object)Person.JOHN_DOE, (IOSupplier)null)).withMessageContaining("target");
        StringWriter writer = new StringWriter();
        p.formatWriter((Object)Person.JOHN_DOE, () -> writer);
        Assertions.assertThat((String)writer.toString()).isEqualTo(Person.getString(StandardCharsets.UTF_8, formatted));
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatWriter((Object)Person.JOHN_DOE, IOSupplier.of(null))).isInstanceOf(IOException.class)).withMessageContaining("Missing Writer");
        Assertions.assertThatIOException().isThrownBy(() -> p.formatWriter((Object)Person.JOHN_DOE, FormatAssertions.targetErrorSupplier())).isInstanceOf(TargetError.class);
    }

    private static void testFormatStreamFromSupplier(Xml.Formatter<Person> p, boolean formatted) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(null, ByteArrayOutputStream::new)).withMessageContaining("value");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, (IOSupplier)null)).withMessageContaining("target");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        p.formatStream((Object)Person.JOHN_DOE, () -> stream);
        Assertions.assertThat((String)stream.toString(StandardCharsets.UTF_8.name())).isEqualTo(Person.getString(StandardCharsets.UTF_8, formatted));
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, IOSupplier.of(null))).isInstanceOf(IOException.class)).withMessageContaining("Missing OutputStream");
        Assertions.assertThatIOException().isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, FormatAssertions.targetErrorSupplier())).isInstanceOf(TargetError.class);
    }

    private static void testFormatStreamFromSupplierCharset(Xml.Formatter<Person> p, boolean formatted) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(null, ByteArrayOutputStream::new, StandardCharsets.UTF_8)).withMessageContaining("value");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, (IOSupplier)null, StandardCharsets.UTF_8)).withMessageContaining("target");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, ByteArrayOutputStream::new, null)).withMessageContaining("encoding");
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, IOSupplier.of(null), StandardCharsets.UTF_8)).isInstanceOf(IOException.class)).withMessageContaining("Missing OutputStream");
        Assertions.assertThatIOException().isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, FormatAssertions.targetErrorSupplier(), StandardCharsets.UTF_8)).isInstanceOf(TargetError.class);
        for (Charset encoding : Person.ENCODINGS) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            p.formatStream((Object)Person.JOHN_DOE, () -> stream, encoding);
            Assertions.assertThat((String)stream.toString(encoding.name())).isEqualTo(Person.getString(encoding, formatted));
        }
    }

    private static void testFormatWriter(Xml.Formatter<Person> p, boolean formatted) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter(null, StringWriter::new)).withMessageContaining("value");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter((Object)Person.JOHN_DOE, (Writer)null)).withMessageContaining("resource");
        StringWriter resource = new StringWriter();
        p.formatWriter((Object)Person.JOHN_DOE, (Writer)resource);
        Assertions.assertThat((String)resource.toString()).isEqualTo(Person.getString(StandardCharsets.UTF_8, formatted));
    }

    private static void testFormatStream(Xml.Formatter<Person> p, boolean formatted) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(null, ByteArrayOutputStream::new)).withMessageContaining("value");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, (OutputStream)null)).withMessageContaining("resource");
        ByteArrayOutputStream resource = new ByteArrayOutputStream();
        p.formatStream((Object)Person.JOHN_DOE, (OutputStream)resource);
        Assertions.assertThat((String)resource.toString()).isEqualTo(Person.getString(StandardCharsets.UTF_8, formatted));
    }

    private static void testFormatStreamCharset(Xml.Formatter<Person> p, boolean formatted) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(null, (OutputStream)new ByteArrayOutputStream(), StandardCharsets.UTF_8)).withMessageContaining("value");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, (OutputStream)null, StandardCharsets.UTF_8)).withMessageContaining("resource");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, (OutputStream)new ByteArrayOutputStream(), null)).withMessageContaining("encoding");
        for (Charset encoding : Person.ENCODINGS) {
            ByteArrayOutputStream resource = new ByteArrayOutputStream();
            p.formatStream((Object)Person.JOHN_DOE, (OutputStream)resource, encoding);
            Assertions.assertThat((String)resource.toString(encoding.name())).isEqualTo(Person.getString(encoding, formatted));
        }
    }

    public static void assertFormatterSafety(Xml.Formatter<Person> p, Class<? extends Throwable> expectedException, TemporaryFolder temp) {
        ResourceCounter counter = new ResourceCounter();
        Meta.builder().group("Reader").code().doesNotRaiseExceptionWhen(() -> p.formatWriter((Object)Person.JOHN_DOE, counter.onWriter((IOSupplier<Writer>)((IOSupplier)StringWriter::new)))).exception(IOException.class).as("Null").isThrownBy(() -> p.formatWriter((Object)Person.JOHN_DOE, IOSupplier.of(null))).exception(TargetError.class).as("Throwing").isThrownBy(() -> p.formatWriter((Object)Person.JOHN_DOE, FormatAssertions.targetErrorSupplier())).group("Stream").code().doesNotRaiseExceptionWhen(() -> p.formatStream((Object)Person.JOHN_DOE, counter.onOutputStream((IOSupplier<OutputStream>)((IOSupplier)ByteArrayOutputStream::new)))).exception(IOException.class).as("Null").isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, IOSupplier.of(null))).exception(TargetError.class).as("Throwing").isThrownBy(() -> p.formatStream((Object)Person.JOHN_DOE, FormatAssertions.targetErrorSupplier())).group("File").code().doesNotRaiseExceptionWhen(() -> p.formatFile((Object)Person.JOHN_DOE, temp.newFile())).exception(AccessDeniedException.class).as("Dir").isThrownBy(() -> p.formatFile((Object)Person.JOHN_DOE, temp.newFolder())).group("Path").code().doesNotRaiseExceptionWhen(() -> p.formatPath((Object)Person.JOHN_DOE, temp.newFile().toPath())).exception(AccessDeniedException.class).as("Dir").isThrownBy(() -> p.formatPath((Object)Person.JOHN_DOE, temp.newFolder().toPath())).group("Chars").code().doesNotRaiseExceptionWhen(() -> p.formatChars((Object)Person.JOHN_DOE, (Appendable)new StringBuilder())).code().doesNotRaiseExceptionWhen(() -> p.formatToString((Object)Person.JOHN_DOE)).build().forEach(callable -> FormatAssertions.testSafeFormat(counter, expectedException, callable));
    }

    private static void testSafeFormat(ResourceCounter counter, Class<? extends Throwable> expectedException, Meta<IORunnable> callable) {
        counter.reset();
        if (expectedException != null) {
            Assertions.assertThatThrownBy(() -> ((IORunnable)callable.getTarget()).runWithIO()).isInstanceOf(expectedException);
        } else if (callable.getExpectedException() != null) {
            Assertions.assertThatThrownBy(() -> ((IORunnable)callable.getTarget()).runWithIO()).isInstanceOf(callable.getExpectedException());
        } else {
            Assertions.assertThatCode(() -> ((IORunnable)callable.getTarget()).runWithIO()).doesNotThrowAnyException();
        }
        Assertions.assertThat((int)counter.getCount()).isLessThanOrEqualTo(0);
    }

    private static <X> IOSupplier<X> targetErrorSupplier() {
        return () -> {
            throw new TargetError();
        };
    }

    private static final class TargetError
    extends IOException {
        private TargetError() {
        }
    }
}

