/*
 * Decompiled with CFR 0.152.
 */
package _test.sample;

import _test.Meta;
import _test.ResourceCounter;
import _test.sample.Person;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import nbbrd.io.function.IORunnable;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.xml.Xml;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssertAlternative;
import org.junit.rules.TemporaryFolder;
import org.xml.sax.SAXParseException;

public class ParseAssertions {
    public static void assertParserCompliance(Xml.Parser<Person> p, TemporaryFolder temp) throws IOException {
        ParseAssertions.testParseChars(p);
        ParseAssertions.testParseFile(p, temp);
        ParseAssertions.testParseFileCharset(p, temp);
        ParseAssertions.testParsePath(p, temp);
        ParseAssertions.testParsePathCharset(p, temp);
        ParseAssertions.testParseResource(p);
        ParseAssertions.testParseResourceCharset(p);
        ParseAssertions.testParseReaderFromSupplier(p);
        ParseAssertions.testParseStreamFromSupplier(p);
        ParseAssertions.testParseStreamFromSupplierCharset(p);
        ParseAssertions.testParseReader(p);
        ParseAssertions.testParseStream(p);
        ParseAssertions.testParseStreamCharset(p);
    }

    private static void testParseChars(Xml.Parser<Person> p) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseChars(null)).withMessageContaining("source");
        Assertions.assertThat((Object)((Person)p.parseChars((CharSequence)Person.getString(StandardCharsets.UTF_8, false)))).isEqualTo((Object)Person.JOHN_DOE);
        Assertions.assertThatIOException().isThrownBy(() -> p.parseChars((CharSequence)Person.CHARS_EMPTY)).isInstanceOf(EOFException.class);
    }

    private static void testParseFile(Xml.Parser<Person> p, TemporaryFolder temp) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseFile(null)).withMessageContaining("source");
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(Person.FILE_EMPTY)).isInstanceOf(EOFException.class)).withMessageContaining(Person.FILE_EMPTY.toString());
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(Person.FILE_MISSING)).isInstanceOf(NoSuchFileException.class)).withMessageContaining(Person.FILE_MISSING.toString());
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(Person.FILE_DIR)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(Person.FILE_DIR.toString());
        for (Charset encoding : Person.ENCODINGS) {
            Assertions.assertThat((Object)((Person)p.parseFile(Person.getFile(encoding)))).isEqualTo((Object)Person.JOHN_DOE);
        }
    }

    private static void testParseFileCharset(Xml.Parser<Person> p, TemporaryFolder temp) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseFile(null, StandardCharsets.UTF_8)).withMessageContaining("source");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseFile(Person.getFile(StandardCharsets.UTF_8), null)).withMessageContaining("encoding");
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(Person.FILE_EMPTY, StandardCharsets.UTF_8)).isInstanceOf(EOFException.class)).withMessageContaining(Person.FILE_EMPTY.toString());
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(Person.FILE_MISSING, StandardCharsets.UTF_8)).isInstanceOf(NoSuchFileException.class)).withMessageContaining(Person.FILE_MISSING.toString());
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(Person.FILE_DIR, StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(Person.FILE_DIR.toString());
        for (Charset encoding : Person.ENCODINGS) {
            Assertions.assertThat((Object)((Person)p.parseFile(Person.getFile(encoding), encoding))).isEqualTo((Object)Person.JOHN_DOE);
        }
    }

    private static void testParsePath(Xml.Parser<Person> p, TemporaryFolder temp) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parsePath(null)).withMessageContaining("source");
        Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(Person.PATH_EMPTY)).isInstanceOf(EOFException.class);
        Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(Person.PATH_MISSING)).isInstanceOf(NoSuchFileException.class);
        Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(temp.newFolder().toPath())).isInstanceOf(AccessDeniedException.class);
        for (Charset encoding : Person.ENCODINGS) {
            Assertions.assertThat((Object)((Person)p.parsePath(Person.getPath(encoding)))).isEqualTo((Object)Person.JOHN_DOE);
        }
    }

    private static void testParsePathCharset(Xml.Parser<Person> p, TemporaryFolder temp) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parsePath(null, StandardCharsets.UTF_8)).withMessageContaining("source");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parsePath(Person.getPath(StandardCharsets.UTF_8), null)).withMessageContaining("encoding");
        Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(Person.PATH_EMPTY, StandardCharsets.UTF_8)).isInstanceOf(EOFException.class);
        Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(Person.PATH_MISSING, StandardCharsets.UTF_8)).isInstanceOf(NoSuchFileException.class);
        Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(temp.newFolder().toPath(), StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class);
        for (Charset encoding : Person.ENCODINGS) {
            Assertions.assertThat((Object)((Person)p.parsePath(Person.getPath(encoding), encoding))).isEqualTo((Object)Person.JOHN_DOE);
        }
    }

    private static void testParseResource(Xml.Parser<Person> p) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(null, "")).withMessageContaining("type");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(Person.class, null)).withMessageContaining("name");
        Assertions.assertThat((Object)((Person)p.parseResource(Person.class, "/nbbrd/io/xml/johndoe.xml"))).isEqualTo((Object)Person.JOHN_DOE);
        Assertions.assertThatIOException().isThrownBy(() -> p.parseResource(Person.class, "/johndoe.xml")).withMessageContaining("Missing").withMessageContaining("/johndoe.xml").withMessageContaining(Person.class.getName());
    }

    private static void testParseResourceCharset(Xml.Parser<Person> p) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(null, "", StandardCharsets.UTF_8)).withMessageContaining("type");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(Person.class, null, StandardCharsets.UTF_8)).withMessageContaining("name");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(Person.class, "", null)).withMessageContaining("encoding");
        Assertions.assertThat((Object)((Person)p.parseResource(Person.class, "/nbbrd/io/xml/johndoe.xml", StandardCharsets.UTF_8))).isEqualTo((Object)Person.JOHN_DOE);
        Assertions.assertThatIOException().isThrownBy(() -> p.parseResource(Person.class, "/johndoe.xml", StandardCharsets.UTF_8)).withMessageContaining("Missing").withMessageContaining("/johndoe.xml").withMessageContaining(Person.class.getName());
    }

    private static void testParseReaderFromSupplier(Xml.Parser<Person> p) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseReader((IOSupplier)null)).withMessageContaining("source");
        Assertions.assertThat((Object)((Person)p.parseReader(Person.JOHN_DOE_READER))).isEqualTo((Object)Person.JOHN_DOE);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseReader(IOSupplier.of(null))).isInstanceOf(IOException.class)).withMessageContaining("Missing Reader");
        Assertions.assertThatIOException().isThrownBy(() -> p.parseReader(ParseAssertions.sourceErrorSupplier())).isInstanceOf(SourceError.class);
    }

    private static void testParseStreamFromSupplier(Xml.Parser<Person> p) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((IOSupplier)null)).withMessageContaining("source");
        Assertions.assertThat((Object)((Person)p.parseStream(Person.JOHN_DOE_STREAM))).isEqualTo((Object)Person.JOHN_DOE);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseStream(IOSupplier.of(null))).isInstanceOf(IOException.class)).withMessageContaining("Missing InputStream");
        Assertions.assertThatIOException().isThrownBy(() -> p.parseStream(ParseAssertions.sourceErrorSupplier())).isInstanceOf(SourceError.class);
    }

    private static void testParseStreamFromSupplierCharset(Xml.Parser<Person> p) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((IOSupplier)null, StandardCharsets.UTF_8)).withMessageContaining("source");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream(Person.JOHN_DOE_STREAM, null)).withMessageContaining("encoding");
        Assertions.assertThat((Object)((Person)p.parseStream(Person.JOHN_DOE_STREAM, StandardCharsets.UTF_8))).isEqualTo((Object)Person.JOHN_DOE);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseStream(IOSupplier.of(null), StandardCharsets.UTF_8)).isInstanceOf(IOException.class)).withMessageContaining("Missing InputStream");
        Assertions.assertThatIOException().isThrownBy(() -> p.parseStream(ParseAssertions.sourceErrorSupplier(), StandardCharsets.UTF_8)).isInstanceOf(SourceError.class);
    }

    private static void testParseReader(Xml.Parser<Person> p) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseReader((Reader)null)).withMessageContaining("resource");
        try (Reader resource = (Reader)Person.JOHN_DOE_READER.getWithIO();){
            Assertions.assertThat((Object)((Person)p.parseReader(resource))).isEqualTo((Object)Person.JOHN_DOE);
        }
    }

    private static void testParseStream(Xml.Parser<Person> p) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((InputStream)null)).withMessageContaining("resource");
        try (InputStream resource = (InputStream)Person.JOHN_DOE_STREAM.getWithIO();){
            Assertions.assertThat((Object)((Person)p.parseStream(resource))).isEqualTo((Object)Person.JOHN_DOE);
        }
    }

    private static void testParseStreamCharset(Xml.Parser<Person> p) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((InputStream)null, StandardCharsets.UTF_8)).withMessageContaining("resource");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((InputStream)Person.JOHN_DOE_STREAM.getWithIO(), null)).withMessageContaining("encoding");
        try (InputStream resource = (InputStream)Person.JOHN_DOE_STREAM.getWithIO();){
            Assertions.assertThat((Object)((Person)p.parseStream(resource, StandardCharsets.UTF_8))).isEqualTo((Object)Person.JOHN_DOE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testXXE(Xml.Parser<Person> with, Xml.Parser<Person> without) throws IOException {
        UrlPattern urlPattern = WireMock.urlMatching((String)"/test.txt");
        WireMockRule wire = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort());
        wire.stubFor(WireMock.get((UrlPattern)urlPattern).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<firstName>John</firstName><lastName>Doe</lastName>")));
        wire.start();
        String xxePayload = ParseAssertions.getXxePayload(wire.port());
        try {
            Assertions.assertThatThrownBy(() -> with.parseChars((CharSequence)xxePayload)).isInstanceOf(IOException.class);
            wire.verify(0, WireMock.getRequestedFor((UrlPattern)urlPattern));
            wire.resetRequests();
            try {
                Person p = (Person)without.parseChars((CharSequence)xxePayload);
                Assertions.assertThat((Object)p).isEqualTo((Object)Person.JOHN_DOE);
                wire.verify(1, WireMock.getRequestedFor((UrlPattern)urlPattern));
            }
            catch (IOException ex) {
                Assertions.assertThat((Throwable)ex).hasRootCauseInstanceOf(SAXParseException.class);
                wire.verify(0, WireMock.getRequestedFor((UrlPattern)urlPattern));
            }
        }
        finally {
            wire.stop();
        }
    }

    private static String getXxePayload(int port) {
        return "<?xml version=\"1.0\" ?> \n<!DOCTYPE r [ \n<!ELEMENT r ANY > \n<!ENTITY sp SYSTEM \"http://localhost:" + port + "/test.txt\"> \n]> \n<person>&sp;</person> ";
    }

    public static void assertParserSafety(Xml.Parser<Person> p, Class<? extends Throwable> expectedException) {
        ResourceCounter counter = new ResourceCounter();
        Meta.builder().group("Reader").code().doesNotRaiseExceptionWhen(() -> p.parseReader(counter.onReader(Person.JOHN_DOE_READER))).exception(IOException.class).as("Null").isThrownBy(() -> p.parseReader(IOSupplier.of(null))).exception(SourceError.class).as("Throwing").isThrownBy(() -> p.parseReader(ParseAssertions.sourceErrorSupplier())).group("Stream").code().doesNotRaiseExceptionWhen(() -> p.parseStream(counter.onInputStream(Person.JOHN_DOE_STREAM))).exception(IOException.class).as("Null").isThrownBy(() -> p.parseStream(IOSupplier.of(null))).exception(SourceError.class).as("Throwing").isThrownBy(() -> p.parseStream(ParseAssertions.sourceErrorSupplier())).group("File").code().doesNotRaiseExceptionWhen(() -> p.parseFile(Person.getFile(StandardCharsets.UTF_8))).exception(EOFException.class).as("Empty").isThrownBy(() -> p.parseFile(Person.FILE_EMPTY)).exception(NoSuchFileException.class).as("Missing").isThrownBy(() -> p.parseFile(Person.FILE_MISSING)).exception(AccessDeniedException.class).as("Dir").isThrownBy(() -> p.parseFile(Person.FILE_DIR)).group("Path").code().doesNotRaiseExceptionWhen(() -> p.parsePath(Person.getPath(StandardCharsets.UTF_8))).exception(EOFException.class).as("Empty").isThrownBy(() -> p.parsePath(Person.PATH_EMPTY)).exception(NoSuchFileException.class).as("Missing").isThrownBy(() -> p.parsePath(Person.PATH_MISSING)).exception(AccessDeniedException.class).as("Dir").isThrownBy(() -> p.parsePath(Person.PATH_DIR)).group("Chars").code().doesNotRaiseExceptionWhen(() -> p.parseChars((CharSequence)Person.getString(StandardCharsets.UTF_8, false))).exception(EOFException.class).as("Empty").isThrownBy(() -> p.parseChars((CharSequence)Person.CHARS_EMPTY)).build().forEach(callable -> ParseAssertions.testSafeParse(counter, expectedException, callable));
    }

    private static void testSafeParse(ResourceCounter counter, Class<? extends Throwable> expectedException, Meta<IORunnable> callable) {
        counter.reset();
        if (expectedException != null) {
            Assertions.assertThatThrownBy(() -> ((IORunnable)callable.getTarget()).runWithIO()).isInstanceOf(expectedException);
        } else if (callable.getExpectedException() != null) {
            Assertions.assertThatThrownBy(() -> ((IORunnable)callable.getTarget()).runWithIO()).isInstanceOf(callable.getExpectedException());
        } else {
            Assertions.assertThatCode(() -> ((IORunnable)callable.getTarget()).runWithIO()).doesNotThrowAnyException();
        }
        Assertions.assertThat((int)counter.getCount()).isLessThanOrEqualTo(0);
    }

    private static <X> IOSupplier<X> sourceErrorSupplier() {
        return () -> {
            throw new SourceError();
        };
    }

    private static final class SourceError
    extends IOException {
        private SourceError() {
        }
    }
}

