/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.xml;

import internal.io.text.LegacyFiles;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.WrappedIOException;
import nbbrd.io.function.IORunnable;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.xml.Xml;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class Sax {
    @Generated
    private static final Logger log = Logger.getLogger(Sax.class.getName());
    private static final SAXParserFactory DEFAULT_FACTORY = Sax.initFactory();
    private static final DefaultHandler DEFAULT_HANDLER = new DefaultHandler();
    private static final ConcurrentHashMap<Locale, String> EOF_MESSAGES = new ConcurrentHashMap();
    private static final String SAX_FEATURES_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String SAX_FEATURES_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String XERCES_FEATURES_NONVALIDATING_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    public static void preventXXE(@NonNull XMLReader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        Sax.disableFeature(reader, XERCES_FEATURES_NONVALIDATING_LOAD_EXTERNAL_DTD);
        Sax.disableFeature(reader, SAX_FEATURES_EXTERNAL_GENERAL_ENTITIES);
        Sax.disableFeature(reader, SAX_FEATURES_EXTERNAL_PARAMETER_ENTITIES);
    }

    @NonNull
    public static XMLReader createReader() throws IOException {
        try {
            return DEFAULT_FACTORY.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw Sax.wrapConfigException(ex);
        }
        catch (SAXException ex) {
            throw Sax.toIOException(ex);
        }
    }

    @NonNull
    public static InputSource newInputSource(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return new InputSource(LegacyFiles.toSystemId((File)file));
    }

    @NonNull
    public static InputSource newInputSource(@NonNull File file, @NonNull Charset encoding) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        InputSource result = new InputSource(LegacyFiles.toSystemId((File)file));
        result.setEncoding(encoding.name());
        return result;
    }

    @NonNull
    public static IOException toIOException(@NonNull SAXException ex) {
        if (ex == null) {
            throw new NullPointerException("ex is marked non-null but is null");
        }
        if (ex instanceof SAXParseException) {
            return Sax.wrapParseException((SAXParseException)ex);
        }
        return WrappedIOException.wrap((Throwable)ex);
    }

    private static SAXParserFactory initFactory() {
        SAXParserFactory result = SAXParserFactory.newInstance();
        result.setNamespaceAware(true);
        return result;
    }

    private static void disableFeature(XMLReader reader, String feature) {
        try {
            reader.setFeature(feature, false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException ex) {
            log.log(Level.FINE, ex, () -> String.format(Locale.ROOT, "Failed to disable feature '%s'", feature));
        }
    }

    private static IOException wrapConfigException(ParserConfigurationException ex) {
        return WrappedIOException.wrap((Throwable)ex);
    }

    private static IOException wrapParseException(SAXParseException ex) {
        if (Sax.isEOF(ex)) {
            return new EOFException(Objects.toString(Sax.getFileOrNull(ex)));
        }
        return WrappedIOException.wrap((Throwable)ex);
    }

    private static boolean isEOF(SAXParseException ex) {
        return ex.getMessage() != null && Sax.isEOFMessage(ex.getMessage());
    }

    private static boolean isEOFMessage(String message) {
        return EOF_MESSAGES.computeIfAbsent(Locale.getDefault(), Sax::loadEOFMessage).equals(message);
    }

    private static String loadEOFMessage(Locale locale) {
        block2: {
            try {
                XMLReader reader = DEFAULT_FACTORY.newSAXParser().getXMLReader();
                reader.setErrorHandler(new DefaultHandler());
                reader.parse(new InputSource(new StringReader("")));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (!(e instanceof SAXParseException)) break block2;
                return e.getMessage();
            }
        }
        return "Premature end of file.";
    }

    private static File getFileOrNull(SAXParseException ex) {
        String result = ex.getSystemId();
        return result != null && result.startsWith("file:/") ? LegacyFiles.fromSystemId((String)result) : null;
    }

    @Generated
    private Sax() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Parser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final IOSupplier<? extends XMLReader> factory;
        @NonNull
        private final ContentHandler contentHandler;
        @NonNull
        private final DTDHandler dtdHandler;
        @NonNull
        private final EntityResolver entityResolver;
        @NonNull
        private final ErrorHandler errorHandler;
        @NonNull
        private final IORunnable before;
        @NonNull
        private final IOSupplier<? extends T> after;
        private final boolean ignoreXXE;

        @NonNull
        public static <T> Parser<T> of(@NonNull ContentHandler handler, IOSupplier<? extends T> after) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            Builder<? extends T> result = Parser.builder().contentHandler(handler);
            if (handler instanceof DTDHandler) {
                result.dtdHandler((DTDHandler)((Object)handler));
            }
            if (handler instanceof EntityResolver) {
                result.entityResolver((EntityResolver)((Object)handler));
            }
            if (handler instanceof ErrorHandler) {
                result.errorHandler((ErrorHandler)((Object)handler));
            }
            return result.after(after).build();
        }

        @NonNull
        public T parseFile(@NonNull File source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            return this.parse(Sax.newInputSource(LegacyFiles.checkSource((File)source)));
        }

        @NonNull
        public T parseFile(@NonNull File source, @NonNull Charset encoding) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return this.parse(Sax.newInputSource(LegacyFiles.checkSource((File)source), encoding));
        }

        @NonNull
        public T parseReader(@NonNull Reader resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            return this.parse(new InputSource(resource));
        }

        @NonNull
        public T parseStream(@NonNull InputStream resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            return this.parse(new InputSource(resource));
        }

        @NonNull
        public T parseStream(@NonNull InputStream resource, @NonNull Charset encoding) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            InputSource input = new InputSource(resource);
            input.setEncoding(encoding.name());
            return this.parse(input);
        }

        private T parse(InputSource input) throws IOException {
            XMLReader engine = (XMLReader)this.factory.getWithIO();
            if (!this.ignoreXXE) {
                Sax.preventXXE(engine);
            }
            engine.setContentHandler(this.contentHandler);
            engine.setDTDHandler(this.dtdHandler);
            engine.setEntityResolver(this.entityResolver);
            engine.setErrorHandler(this.errorHandler);
            this.before.runWithIO();
            try {
                engine.parse(input);
            }
            catch (SAXException ex) {
                throw Sax.toIOException(ex);
            }
            return (T)this.after.getWithIO();
        }

        @Generated
        private static <T> IOSupplier<? extends XMLReader> $default$factory() {
            return Sax::createReader;
        }

        @Generated
        private static <T> DTDHandler $default$dtdHandler() {
            return DEFAULT_HANDLER;
        }

        @Generated
        private static <T> EntityResolver $default$entityResolver() {
            return DEFAULT_HANDLER;
        }

        @Generated
        private static <T> ErrorHandler $default$errorHandler() {
            return DEFAULT_HANDLER;
        }

        @Generated
        private static <T> IORunnable $default$before() {
            return IORunnable.noOp();
        }

        @Generated
        private static <T> boolean $default$ignoreXXE() {
            return false;
        }

        @Generated
        Parser(@NonNull IOSupplier<? extends XMLReader> factory, @NonNull ContentHandler contentHandler, @NonNull DTDHandler dtdHandler, @NonNull EntityResolver entityResolver, @NonNull ErrorHandler errorHandler, @NonNull IORunnable before, @NonNull IOSupplier<? extends T> after, boolean ignoreXXE) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            if (contentHandler == null) {
                throw new NullPointerException("contentHandler is marked non-null but is null");
            }
            if (dtdHandler == null) {
                throw new NullPointerException("dtdHandler is marked non-null but is null");
            }
            if (entityResolver == null) {
                throw new NullPointerException("entityResolver is marked non-null but is null");
            }
            if (errorHandler == null) {
                throw new NullPointerException("errorHandler is marked non-null but is null");
            }
            if (before == null) {
                throw new NullPointerException("before is marked non-null but is null");
            }
            if (after == null) {
                throw new NullPointerException("after is marked non-null but is null");
            }
            this.factory = factory;
            this.contentHandler = contentHandler;
            this.dtdHandler = dtdHandler;
            this.entityResolver = entityResolver;
            this.errorHandler = errorHandler;
            this.before = before;
            this.after = after;
            this.ignoreXXE = ignoreXXE;
        }

        @Generated
        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder();
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder().factory(this.factory).contentHandler(this.contentHandler).dtdHandler(this.dtdHandler).entityResolver(this.entityResolver).errorHandler(this.errorHandler).before(this.before).after(this.after).ignoreXXE(this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withFactory(@NonNull IOSupplier<? extends XMLReader> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new Parser<T>(factory, this.contentHandler, this.dtdHandler, this.entityResolver, this.errorHandler, this.before, this.after, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withContentHandler(@NonNull ContentHandler contentHandler) {
            if (contentHandler == null) {
                throw new NullPointerException("contentHandler is marked non-null but is null");
            }
            return this.contentHandler == contentHandler ? this : new Parser<T>(this.factory, contentHandler, this.dtdHandler, this.entityResolver, this.errorHandler, this.before, this.after, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withDtdHandler(@NonNull DTDHandler dtdHandler) {
            if (dtdHandler == null) {
                throw new NullPointerException("dtdHandler is marked non-null but is null");
            }
            return this.dtdHandler == dtdHandler ? this : new Parser<T>(this.factory, this.contentHandler, dtdHandler, this.entityResolver, this.errorHandler, this.before, this.after, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withEntityResolver(@NonNull EntityResolver entityResolver) {
            if (entityResolver == null) {
                throw new NullPointerException("entityResolver is marked non-null but is null");
            }
            return this.entityResolver == entityResolver ? this : new Parser<T>(this.factory, this.contentHandler, this.dtdHandler, entityResolver, this.errorHandler, this.before, this.after, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withErrorHandler(@NonNull ErrorHandler errorHandler) {
            if (errorHandler == null) {
                throw new NullPointerException("errorHandler is marked non-null but is null");
            }
            return this.errorHandler == errorHandler ? this : new Parser<T>(this.factory, this.contentHandler, this.dtdHandler, this.entityResolver, errorHandler, this.before, this.after, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withBefore(@NonNull IORunnable before) {
            if (before == null) {
                throw new NullPointerException("before is marked non-null but is null");
            }
            return this.before == before ? this : new Parser<T>(this.factory, this.contentHandler, this.dtdHandler, this.entityResolver, this.errorHandler, before, this.after, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withAfter(@NonNull IOSupplier<? extends T> after) {
            if (after == null) {
                throw new NullPointerException("after is marked non-null but is null");
            }
            return this.after == after ? this : new Parser<T>(this.factory, this.contentHandler, this.dtdHandler, this.entityResolver, this.errorHandler, this.before, after, this.ignoreXXE);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withIgnoreXXE(boolean ignoreXXE) {
            return this.ignoreXXE == ignoreXXE ? this : new Parser<T>(this.factory, this.contentHandler, this.dtdHandler, this.entityResolver, this.errorHandler, this.before, this.after, ignoreXXE);
        }

        @Override
        @Generated
        public boolean isIgnoreXXE() {
            return this.ignoreXXE;
        }

        public static final class Builder<T> {
            @Generated
            private boolean factory$set;
            @Generated
            private IOSupplier<? extends XMLReader> factory$value;
            @Generated
            private ContentHandler contentHandler;
            @Generated
            private boolean dtdHandler$set;
            @Generated
            private DTDHandler dtdHandler$value;
            @Generated
            private boolean entityResolver$set;
            @Generated
            private EntityResolver entityResolver$value;
            @Generated
            private boolean errorHandler$set;
            @Generated
            private ErrorHandler errorHandler$value;
            @Generated
            private boolean before$set;
            @Generated
            private IORunnable before$value;
            @Generated
            private IOSupplier<? extends T> after;
            @Generated
            private boolean ignoreXXE$set;
            @Generated
            private boolean ignoreXXE$value;

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends XMLReader> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory$value = factory;
                this.factory$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> contentHandler(@NonNull ContentHandler contentHandler) {
                if (contentHandler == null) {
                    throw new NullPointerException("contentHandler is marked non-null but is null");
                }
                this.contentHandler = contentHandler;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> dtdHandler(@NonNull DTDHandler dtdHandler) {
                if (dtdHandler == null) {
                    throw new NullPointerException("dtdHandler is marked non-null but is null");
                }
                this.dtdHandler$value = dtdHandler;
                this.dtdHandler$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> entityResolver(@NonNull EntityResolver entityResolver) {
                if (entityResolver == null) {
                    throw new NullPointerException("entityResolver is marked non-null but is null");
                }
                this.entityResolver$value = entityResolver;
                this.entityResolver$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> errorHandler(@NonNull ErrorHandler errorHandler) {
                if (errorHandler == null) {
                    throw new NullPointerException("errorHandler is marked non-null but is null");
                }
                this.errorHandler$value = errorHandler;
                this.errorHandler$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> before(@NonNull IORunnable before) {
                if (before == null) {
                    throw new NullPointerException("before is marked non-null but is null");
                }
                this.before$value = before;
                this.before$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> after(@NonNull IOSupplier<? extends T> after) {
                if (after == null) {
                    throw new NullPointerException("after is marked non-null but is null");
                }
                this.after = after;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> ignoreXXE(boolean ignoreXXE) {
                this.ignoreXXE$value = ignoreXXE;
                this.ignoreXXE$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> build() {
                IOSupplier factory$value = this.factory$value;
                if (!this.factory$set) {
                    factory$value = Parser.$default$factory();
                }
                DTDHandler dtdHandler$value = this.dtdHandler$value;
                if (!this.dtdHandler$set) {
                    dtdHandler$value = Parser.$default$dtdHandler();
                }
                EntityResolver entityResolver$value = this.entityResolver$value;
                if (!this.entityResolver$set) {
                    entityResolver$value = Parser.$default$entityResolver();
                }
                ErrorHandler errorHandler$value = this.errorHandler$value;
                if (!this.errorHandler$set) {
                    errorHandler$value = Parser.$default$errorHandler();
                }
                IORunnable before$value = this.before$value;
                if (!this.before$set) {
                    before$value = Parser.$default$before();
                }
                boolean ignoreXXE$value = this.ignoreXXE$value;
                if (!this.ignoreXXE$set) {
                    ignoreXXE$value = Parser.$default$ignoreXXE();
                }
                return new Parser<T>((IOSupplier<? extends XMLReader>)factory$value, this.contentHandler, dtdHandler$value, entityResolver$value, errorHandler$value, before$value, this.after, ignoreXXE$value);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Sax.Parser.Builder(factory$value=" + this.factory$value + ", contentHandler=" + this.contentHandler + ", dtdHandler$value=" + this.dtdHandler$value + ", entityResolver$value=" + this.entityResolver$value + ", errorHandler$value=" + this.errorHandler$value + ", before$value=" + this.before$value + ", after=" + this.after + ", ignoreXXE$value=" + this.ignoreXXE$value + ")";
            }
        }
    }
}

