/*
 * Decompiled with CFR 0.152.
 */
package _test.sample;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.Generated;
import nbbrd.io.function.IOSupplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@XmlRootElement
public class Person {
    public String firstName;
    public String lastName;
    private static final Map<Charset, File> FILES;
    private static final Map<Charset, String> JOHN_DOE_CHARS;
    private static final Map<Charset, String> JOHN_DOE_FORMATTED_CHARS;
    public static final Person JOHN_DOE;
    public static final File FILE_EMPTY;
    public static final Path PATH_EMPTY;
    public static final String CHARS_EMPTY;
    public static final File FILE_MISSING;
    public static final Path PATH_MISSING;
    public static final File FILE_DIR;
    public static final Path PATH_DIR;
    public static final IOSupplier<Reader> JOHN_DOE_READER;
    public static final IOSupplier<InputStream> JOHN_DOE_STREAM;
    public static final List<Boolean> BOOLS;
    public static final List<Charset> ENCODINGS;

    public static File getFile(Charset encoding) {
        return FILES.get(encoding);
    }

    public static Path getPath(Charset encoding) {
        return FILES.get(encoding).toPath();
    }

    public static InputStream getStream(Charset encoding) throws IOException {
        return Files.newInputStream(FILES.get(encoding).toPath(), new OpenOption[0]);
    }

    public static String getString(Charset encoding, boolean formatted) {
        return formatted ? JOHN_DOE_FORMATTED_CHARS.get(encoding) : JOHN_DOE_CHARS.get(encoding);
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Person)) {
            return false;
        }
        Person other = (Person)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$firstName = this.firstName;
        String other$firstName = other.firstName;
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.lastName;
        String other$lastName = other.lastName;
        return !(this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Person;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $firstName = this.firstName;
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.lastName;
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Person(firstName=" + this.firstName + ", lastName=" + this.lastName + ")";
    }

    static {
        BOOLS = Arrays.asList(false, true);
        ENCODINGS = Arrays.asList(StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_16);
        try {
            JOHN_DOE = new Person();
            Person.JOHN_DOE.firstName = "John";
            Person.JOHN_DOE.lastName = "Doe";
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{Person.class}).createMarshaller();
            FILES = new HashMap<Charset, File>();
            JOHN_DOE_CHARS = new HashMap<Charset, String>();
            JOHN_DOE_FORMATTED_CHARS = new HashMap<Charset, String>();
            for (Charset encoding : ENCODINGS) {
                marshaller.setProperty("jaxb.encoding", (Object)encoding.name());
                File encodedFile = File.createTempFile("person_" + encoding.name() + "_", ".xml");
                encodedFile.deleteOnExit();
                marshaller.setProperty("jaxb.formatted.output", (Object)false);
                marshaller.marshal((Object)JOHN_DOE, encodedFile);
                FILES.put(encoding, encodedFile);
                try (StringWriter w = new StringWriter();){
                    marshaller.setProperty("jaxb.formatted.output", (Object)false);
                    marshaller.marshal((Object)JOHN_DOE, (Writer)w);
                    JOHN_DOE_CHARS.put(encoding, w.toString());
                }
                w = new StringWriter();
                try {
                    marshaller.setProperty("jaxb.formatted.output", (Object)true);
                    marshaller.marshal((Object)JOHN_DOE, (Writer)w);
                    JOHN_DOE_FORMATTED_CHARS.put(encoding, w.toString());
                }
                finally {
                    w.close();
                }
            }
            FILE_EMPTY = File.createTempFile("empty_", ".xml");
            FILE_EMPTY.deleteOnExit();
            PATH_EMPTY = FILE_EMPTY.toPath();
            CHARS_EMPTY = "";
            FILE_MISSING = File.createTempFile("missing_", ".xml");
            FILE_MISSING.delete();
            PATH_MISSING = FILE_MISSING.toPath();
            FILE_DIR = Files.createTempDirectory("xml", new FileAttribute[0]).toFile();
            FILE_DIR.deleteOnExit();
            PATH_DIR = FILE_DIR.toPath();
            JOHN_DOE_READER = () -> new StringReader(JOHN_DOE_CHARS.get(StandardCharsets.UTF_8));
            JOHN_DOE_STREAM = () -> new ByteArrayInputStream(JOHN_DOE_CHARS.get(StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException | JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }
}

