/*
 * Decompiled with CFR 0.152.
 */
package _test.sample;

import _test.Meta;
import _test.ResourceCounter;
import _test.io.FileParserAssertions;
import _test.io.ResourceId;
import _test.io.Util;
import _test.io.text.TextParserAssertions;
import _test.sample.Person;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import nbbrd.io.function.IORunnable;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.xml.Xml;
import org.assertj.core.api.Assertions;
import org.xml.sax.SAXParseException;

public final class XmlParserAssertions {
    public static void assertXmlParserCompliance(Path temp, Xml.Parser<Person> p) throws IOException {
        ResourceId resourceId = new ResourceId(Person.class, "/nbbrd/io/xml/johndoe.xml");
        TextParserAssertions.assertTextParserCompliance((Path)temp, p, (Object)Person.JOHN_DOE, encoding -> resourceId, Collections.singleton(StandardCharsets.UTF_8), (boolean)false);
        FileParserAssertions.assertFileParserCompliance((Path)temp, p, (Object)Person.JOHN_DOE, (ResourceId)resourceId, (boolean)false);
        XmlParserAssertions.assertXmlParserComplianceWithEOF(p);
        XmlParserAssertions.assertXmlParserComplianceWithEncodings(p);
    }

    private static void assertXmlParserComplianceWithEOF(Xml.Parser<Person> p) {
        for (String truncatedSource : new String[]{Person.CHARS_EMPTY, "\n"}) {
            Assertions.assertThatIOException().isThrownBy(() -> p.parseChars((CharSequence)truncatedSource)).isInstanceOf(EOFException.class);
        }
    }

    private static void assertXmlParserComplianceWithEncodings(Xml.Parser<Person> p) throws IOException {
        for (Charset encoding : Person.ENCODINGS) {
            Assertions.assertThat((Object)((Person)p.parseFile(Person.getFile(encoding)))).isEqualTo((Object)Person.JOHN_DOE);
            Assertions.assertThat((Object)((Person)p.parsePath(Person.getPath(encoding)))).isEqualTo((Object)Person.JOHN_DOE);
            InputStream stream = Person.getStream(encoding);
            try {
                Assertions.assertThat((Object)((Person)p.parseStream(stream))).isEqualTo((Object)Person.JOHN_DOE);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
    }

    public static void testXXE(WireMockExtension wire, Xml.Parser<Person> with, Xml.Parser<Person> without) {
        wire.resetRequests();
        UrlPattern urlPattern = WireMock.urlMatching((String)"/test.txt");
        wire.stubFor(WireMock.get((UrlPattern)urlPattern).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<firstName>John</firstName><lastName>Doe</lastName>")));
        String xxePayload = XmlParserAssertions.getXxePayload(wire.getPort());
        Assertions.assertThatThrownBy(() -> with.parseChars((CharSequence)xxePayload)).isInstanceOf(IOException.class);
        wire.verify(0, WireMock.getRequestedFor((UrlPattern)urlPattern));
        wire.resetRequests();
        try {
            Person p = (Person)without.parseChars((CharSequence)xxePayload);
            Assertions.assertThat((Object)p).isEqualTo((Object)Person.JOHN_DOE);
            wire.verify(1, WireMock.getRequestedFor((UrlPattern)urlPattern));
        }
        catch (IOException ex) {
            Assertions.assertThat((Throwable)ex).hasRootCauseInstanceOf(SAXParseException.class);
            wire.verify(0, WireMock.getRequestedFor((UrlPattern)urlPattern));
        }
    }

    private static String getXxePayload(int port) {
        return "<?xml version=\"1.0\" ?> \n<!DOCTYPE r [ \n<!ELEMENT r ANY > \n<!ENTITY sp SYSTEM \"http://localhost:" + port + "/test.txt\"> \n]> \n<person>&sp;</person> ";
    }

    public static void assertParserSafety(Xml.Parser<Person> p, Class<? extends Throwable> expectedException) {
        ResourceCounter counter = new ResourceCounter();
        Meta.builder().group("Reader").code().doesNotRaiseExceptionWhen(() -> p.parseReader(counter.onReader(Person.JOHN_DOE_READER))).exception(IOException.class).as("Null").isThrownBy(() -> p.parseReader(IOSupplier.of(null))).exception(XmlParserTestError.class).as("Throwing").isThrownBy(() -> p.parseReader(Util.failingSupplier(() -> new XmlParserTestError()))).group("Stream").code().doesNotRaiseExceptionWhen(() -> p.parseStream(counter.onInputStream(Person.JOHN_DOE_STREAM))).exception(IOException.class).as("Null").isThrownBy(() -> p.parseStream(IOSupplier.of(null))).exception(XmlParserTestError.class).as("Throwing").isThrownBy(() -> p.parseStream(Util.failingSupplier(() -> new XmlParserTestError()))).group("File").code().doesNotRaiseExceptionWhen(() -> p.parseFile(Person.getFile(StandardCharsets.UTF_8))).exception(EOFException.class).as("Empty").isThrownBy(() -> p.parseFile(Person.FILE_EMPTY)).exception(NoSuchFileException.class).as("Missing").isThrownBy(() -> p.parseFile(Person.FILE_MISSING)).exception(AccessDeniedException.class).as("Dir").isThrownBy(() -> p.parseFile(Person.FILE_DIR)).group("Path").code().doesNotRaiseExceptionWhen(() -> p.parsePath(Person.getPath(StandardCharsets.UTF_8))).exception(EOFException.class).as("Empty").isThrownBy(() -> p.parsePath(Person.PATH_EMPTY)).exception(NoSuchFileException.class).as("Missing").isThrownBy(() -> p.parsePath(Person.PATH_MISSING)).exception(AccessDeniedException.class).as("Dir").isThrownBy(() -> p.parsePath(Person.PATH_DIR)).group("Chars").code().doesNotRaiseExceptionWhen(() -> p.parseChars((CharSequence)Person.getString(StandardCharsets.UTF_8, false))).exception(EOFException.class).as("Empty").isThrownBy(() -> p.parseChars((CharSequence)Person.CHARS_EMPTY)).build().forEach(callable -> XmlParserAssertions.testSafeParse(counter, expectedException, callable));
    }

    private static void testSafeParse(ResourceCounter counter, Class<? extends Throwable> expectedException, Meta<IORunnable> callable) {
        counter.reset();
        if (expectedException != null) {
            Assertions.assertThatThrownBy(() -> ((IORunnable)callable.getTarget()).runWithIO()).isInstanceOf(expectedException);
        } else if (callable.getExpectedException() != null) {
            Assertions.assertThatThrownBy(() -> ((IORunnable)callable.getTarget()).runWithIO()).isInstanceOf(callable.getExpectedException());
        } else {
            Assertions.assertThatCode(() -> ((IORunnable)callable.getTarget()).runWithIO()).doesNotThrowAnyException();
        }
        Assertions.assertThat((int)counter.getCount()).isLessThanOrEqualTo(0);
    }

    private static final class XmlParserTestError
    extends IOException {
        private XmlParserTestError() {
        }
    }
}

