/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service;

import internal.com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.io.Writer;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public final class ProcessorUtil {
    public static void write(ProcessingEnvironment env, JavaFile jFile) {
        try (Writer w = env.getFiler().createSourceFile(jFile.packageName + "." + jFile.typeSpec.name, new Element[0]).openWriter();){
            jFile.writeTo(w);
        }
        catch (IOException ex) {
            env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not generate file: " + ex.getMessage());
        }
    }

    public static TypeMirror extractResultType(Supplier<Class<?>> type) {
        try {
            type.get();
            throw new RuntimeException("Expecting exeption to be raised");
        }
        catch (MirroredTypeException ex) {
            return ex.getTypeMirror();
        }
    }

    private ProcessorUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

