/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.provider;

import internal.nbbrd.service.provider.ProviderEntry;
import internal.nbbrd.service.provider.ProviderRef;
import internal.nbbrd.service.provider.ProviderRegistry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lombok.NonNull;

final class ClassPathRegistry
implements ProviderRegistry {
    @NonNull
    private final ProcessingEnvironment env;

    public List<String> readLinesByService(TypeElement service) throws IOException {
        ArrayList<String> arrayList;
        FileObject src = this.env.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.getRelativeName(service));
        BufferedReader reader = new BufferedReader(src.openReader(false));
        try {
            String rawProvider;
            ArrayList<String> result = new ArrayList<String>();
            while ((rawProvider = reader.readLine()) != null) {
                result.add(rawProvider);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException | NoSuchFileException | FilerException ex) {
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }

    public void writeLinesByService(List<String> lines, TypeElement service) throws IOException {
        FileObject dst = this.env.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", this.getRelativeName(service), new Element[0]);
        try (BufferedWriter writer = new BufferedWriter(dst.openWriter());){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }

    public List<ProviderEntry> parseAll(TypeElement service, List<String> lines) {
        String serviceName = service.getQualifiedName().toString();
        return lines.stream().map(line -> ClassPathRegistry.parse(serviceName, line)).collect(Collectors.toList());
    }

    public List<String> formatAll(TypeElement service, List<ProviderRef> refs) {
        Elements util = this.env.getElementUtils();
        return refs.stream().filter(ref -> ref.getService().equals(service)).map(ref -> util.getBinaryName(ref.getProvider()).toString()).collect(Collectors.toList());
    }

    static ProviderEntry parse(String service, String line) {
        int commentIndex = line.indexOf(35);
        if (commentIndex != -1) {
            line = line.substring(0, commentIndex);
        }
        line = line.trim();
        return new ProviderEntry(service, line);
    }

    private String getRelativeName(TypeElement service) {
        return "META-INF/services/" + this.env.getElementUtils().getBinaryName(service);
    }

    public ClassPathRegistry(@NonNull ProcessingEnvironment env) {
        if (env == null) {
            throw new NullPointerException("env is marked non-null but is null");
        }
        this.env = env;
    }
}

