/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import lombok.Generated;

public final class Instantiator {
    private final Kind kind;
    private final Element element;

    public static List<Instantiator> allOf(Types util, TypeElement service, TypeElement provider) {
        return Stream.of(Kind.values()).flatMap(kind -> kind.parse(util, service, provider).map(element -> new Instantiator((Kind)((Object)kind), (Element)element))).collect(Collectors.toList());
    }

    private static boolean isNoArgPublicMethod(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC) && method.getParameters().isEmpty();
    }

    @Generated
    public Instantiator(Kind kind, Element element) {
        this.kind = kind;
        this.element = element;
    }

    @Generated
    public Kind getKind() {
        return this.kind;
    }

    @Generated
    public Element getElement() {
        return this.element;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Instantiator)) {
            return false;
        }
        Instantiator other = (Instantiator)o;
        Kind this$kind = this.getKind();
        Kind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        Element this$element = this.getElement();
        Element other$element = other.getElement();
        return !(this$element == null ? other$element != null : !((Object)this$element).equals(other$element));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        Element $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : ((Object)$element).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Instantiator(kind=" + (Object)((Object)this.getKind()) + ", element=" + this.getElement() + ")";
    }

    public static enum Kind {
        CONSTRUCTOR{

            @Override
            public Stream<Element> parse(Types util, TypeElement service, TypeElement provider) {
                return ElementFilter.constructorsIn(provider.getEnclosedElements()).stream().filter(x$0 -> Instantiator.isNoArgPublicMethod(x$0)).map(Element.class::cast);
            }
        }
        ,
        STATIC_METHOD{

            @Override
            public Stream<Element> parse(Types util, TypeElement service, TypeElement provider) {
                return ElementFilter.methodsIn(provider.getEnclosedElements()).stream().filter(x$0 -> Instantiator.isNoArgPublicMethod(x$0)).filter(method -> method.getModifiers().contains((Object)Modifier.STATIC)).filter(method -> util.isAssignable(method.getReturnType(), service.asType())).map(Element.class::cast);
            }
        }
        ,
        ENUM_FIELD{

            @Override
            public Stream<Element> parse(Types util, TypeElement service, TypeElement provider) {
                return provider.getKind() == ElementKind.ENUM ? ElementFilter.fieldsIn(provider.getEnclosedElements()).stream().filter(field -> field.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(Element.class::cast) : Stream.empty();
            }
        }
        ,
        STATIC_FIELD{

            @Override
            public Stream<Element> parse(Types util, TypeElement service, TypeElement provider) {
                return provider.getKind() != ElementKind.ENUM ? ElementFilter.fieldsIn(provider.getEnclosedElements()).stream().filter(field -> field.getKind().equals((Object)ElementKind.FIELD)).filter(field -> field.getModifiers().containsAll(Arrays.asList(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL))).filter(field -> util.isSubtype(field.asType(), service.asType())).map(Element.class::cast) : Stream.empty();
            }
        };


        public abstract Stream<Element> parse(Types var1, TypeElement var2, TypeElement var3);
    }
}

