/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service;

import internal.nbbrd.service.com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.io.Writer;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ProcessorUtil {
    public static void write(@NonNull ProcessingEnvironment env, @NonNull JavaFile jFile) {
        try (Writer w = env.getFiler().createSourceFile(jFile.packageName + "." + jFile.typeSpec.name, new Element[0]).openWriter();){
            jFile.writeTo(w);
        }
        catch (IOException ex) {
            env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not generate file: " + ex.getMessage());
        }
    }

    public static @NonNull TypeMirror extractResultType(@NonNull Supplier<Class<?>> type) {
        try {
            type.get();
            throw new RuntimeException("Expecting exeption to be raised");
        }
        catch (MirroredTypeException ex) {
            return ex.getTypeMirror();
        }
    }

    @Generated
    private ProcessorUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

