/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.provider;

import internal.nbbrd.service.provider.ProviderConfigurationFileLine;
import internal.nbbrd.service.provider.ProviderEntry;
import internal.nbbrd.service.provider.ProviderRef;
import internal.nbbrd.service.provider.ProviderRegistry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lombok.Generated;
import lombok.NonNull;

final class ClassPathRegistry
implements ProviderRegistry {
    @NonNull
    private final ProcessingEnvironment env;

    public List<ProviderConfigurationFileLine> readLinesByService(TypeElement service) throws IOException {
        List<ProviderConfigurationFileLine> list;
        FileObject src = this.env.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.getFileRelativeName(service));
        BufferedReader reader = new BufferedReader(src.openReader(false));
        try {
            list = ClassPathRegistry.readLinesByService(reader, service, src.toUri());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException | NoSuchFileException | FilerException ex) {
                return Collections.emptyList();
            }
        }
        reader.close();
        return list;
    }

    private static List<ProviderConfigurationFileLine> readLinesByService(BufferedReader reader, TypeElement service, URI uri) throws IOException {
        String line;
        ArrayList<ProviderConfigurationFileLine> result = new ArrayList<ProviderConfigurationFileLine>();
        int lineNumber = 0;
        while ((line = reader.readLine()) != null) {
            try {
                result.add(ProviderConfigurationFileLine.parse(line));
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(service.getQualifiedName() + ": " + uri + ":" + lineNumber + ": " + ex.getMessage());
            }
            ++lineNumber;
        }
        return result;
    }

    public void writeLinesByService(List<ProviderConfigurationFileLine> lines, TypeElement service) throws IOException {
        FileObject dst = this.env.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", this.getFileRelativeName(service), new Element[0]);
        try (BufferedWriter writer = new BufferedWriter(dst.openWriter());){
            for (ProviderConfigurationFileLine line : lines) {
                writer.write(line.toString());
                writer.newLine();
            }
        }
    }

    public List<ProviderEntry> parseAll(TypeElement service, List<ProviderConfigurationFileLine> lines) {
        String serviceName = service.getQualifiedName().toString();
        return lines.stream().map(ProviderConfigurationFileLine::getProviderBinaryName).filter(Objects::nonNull).map(providerName -> new ProviderEntry(serviceName, (String)providerName)).collect(Collectors.toList());
    }

    public List<ProviderConfigurationFileLine> formatAll(TypeElement service, List<ProviderRef> refs) {
        Elements util = this.env.getElementUtils();
        return refs.stream().filter(ref -> ref.getService().equals(service)).map(ref -> util.getBinaryName(ref.getProvider())).map(ProviderConfigurationFileLine::ofProviderBinaryName).collect(Collectors.toList());
    }

    private String getFileRelativeName(TypeElement service) {
        return ProviderConfigurationFileLine.getFileRelativeName(this.env.getElementUtils().getBinaryName(service));
    }

    @Generated
    public ClassPathRegistry(@NonNull ProcessingEnvironment env) {
        if (env == null) {
            throw new NullPointerException("env is marked non-null but is null");
        }
        this.env = env;
    }
}

