/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.com.github.mustachejava.resolver;

import internal.nbbrd.service.com.github.mustachejava.MustacheResolver;
import internal.nbbrd.service.com.github.mustachejava.resolver.ClasspathResolver;
import internal.nbbrd.service.com.github.mustachejava.resolver.FileSystemResolver;
import internal.nbbrd.service.com.github.mustachejava.resolver.URIResolver;
import java.io.File;
import java.io.Reader;

public class DefaultResolver
implements MustacheResolver {
    private final ClasspathResolver classpathResolver;
    private final FileSystemResolver fileSystemResolver;
    private final URIResolver uriResolver;

    public DefaultResolver() {
        this.fileSystemResolver = new FileSystemResolver();
        this.classpathResolver = new ClasspathResolver();
        this.uriResolver = new URIResolver();
    }

    public DefaultResolver(String resourceRoot) {
        this.classpathResolver = new ClasspathResolver(resourceRoot);
        this.fileSystemResolver = new FileSystemResolver();
        this.uriResolver = new URIResolver();
    }

    public DefaultResolver(File fileRoot) {
        this.fileSystemResolver = new FileSystemResolver(fileRoot);
        this.classpathResolver = new ClasspathResolver();
        this.uriResolver = new URIResolver();
    }

    @Override
    public Reader getReader(String resourceName) {
        Reader reader = this.classpathResolver.getReader(resourceName);
        if (reader == null && (reader = this.fileSystemResolver.getReader(resourceName)) == null) {
            reader = this.uriResolver.getReader(resourceName);
        }
        return reader;
    }
}

