package internal.sql.odbc;

import java.util.Comparator;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import nbbrd.sql.odbc.OdbcRegistrySpi;

/**
 * Custom service loader for {@link nbbrd.sql.odbc.OdbcRegistrySpi}.
 * <br>This class is thread-safe.
 * <p>Properties:
 * <ul>
 * <li>Quantifier: OPTIONAL</li>
 * <li>Fallback: null</li>
 * <li>Preprocessing: wrapper: none filters:[isAvailable] sorters:[getCost]</li>
 * <li>Mutability: NONE</li>
 * <li>Singleton: false</li>
 * <li>Name: internal.sql.odbc.OdbcRegistrySpiLoader</li>
 * </ul>
 */
public final class OdbcRegistrySpiLoader {
  private final ServiceLoader<OdbcRegistrySpi> source = ServiceLoader.load(OdbcRegistrySpi.class);

  private final Optional<OdbcRegistrySpi> resource = doLoad();

  private Optional<OdbcRegistrySpi> doLoad() {
    return StreamSupport.stream(source.spliterator(), false)
        .filter(OdbcRegistrySpi::isAvailable)
        .sorted(Comparator.comparingInt(OdbcRegistrySpi::getCost))
        .findFirst();
  }

  /**
   * Gets an optional {@link nbbrd.sql.odbc.OdbcRegistrySpi} instance.
   * <br>This method is thread-safe.
   * @return the current non-null value
   */
  public Optional<OdbcRegistrySpi> get() {
    return resource;
  }

  /**
   * Gets an optional {@link nbbrd.sql.odbc.OdbcRegistrySpi} instance.
   * <br>This is equivalent to the following code: <code>new OdbcRegistrySpiLoader().get()</code>
   * <br>Therefore, the returned value might be different at each call.
   * <br>This method is thread-safe.
   * @return a non-null value
   */
  public static Optional<OdbcRegistrySpi> load() {
    return new OdbcRegistrySpiLoader().get();
  }
}
