/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.odbc;

import internal.sql.odbc.FailsafeOdbcConnectionSupplier;
import internal.sql.odbc.OdbcConnectionSupplierSpiLoader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import nbbrd.sql.jdbc.SqlConnectionSupplier;
import nbbrd.sql.odbc.OdbcConnectionString;
import nbbrd.sql.odbc.OdbcConnectionSupplierSpi;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class OdbcConnectionSupplier
implements SqlConnectionSupplier {
    @lombok.NonNull
    private final OdbcConnectionSupplierSpi spi;

    @lombok.NonNull
    public static Optional<OdbcConnectionSupplier> ofServiceLoader() {
        return OdbcConnectionSupplierSpiLoader.load().map(FailsafeOdbcConnectionSupplier::wrap).map(OdbcConnectionSupplier::new);
    }

    @lombok.NonNull
    public String getName() {
        return this.spi.getName();
    }

    @lombok.NonNull
    public Connection getConnection(@lombok.NonNull String connectionString) throws SQLException {
        if (connectionString == null) {
            throw new NullPointerException("connectionString is marked non-null but is null");
        }
        return this.spi.getConnection(connectionString);
    }

    @lombok.NonNull
    public Connection getConnection(@lombok.NonNull OdbcConnectionString connectionString) throws SQLException {
        if (connectionString == null) {
            throw new NullPointerException("connectionString is marked non-null but is null");
        }
        return this.spi.getConnection(connectionString.toString());
    }

    @Generated
    private OdbcConnectionSupplier(@lombok.NonNull OdbcConnectionSupplierSpi spi) {
        if (spi == null) {
            throw new NullPointerException("spi is marked non-null but is null");
        }
        this.spi = spi;
    }

    @Generated
    public static @NonNull OdbcConnectionSupplier of(@lombok.NonNull OdbcConnectionSupplierSpi spi) {
        if (spi == null) {
            throw new NullPointerException("spi is marked non-null but is null");
        }
        return new OdbcConnectionSupplier(spi);
    }
}

