/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws;

import com.amazonaws.mws.MarketplaceWebService;
import com.amazonaws.mws.MarketplaceWebServiceConfig;
import com.amazonaws.mws.MarketplaceWebServiceException;
import com.amazonaws.mws.model.CancelFeedSubmissionsRequest;
import com.amazonaws.mws.model.CancelFeedSubmissionsResponse;
import com.amazonaws.mws.model.CancelReportRequestsRequest;
import com.amazonaws.mws.model.CancelReportRequestsResponse;
import com.amazonaws.mws.model.Error;
import com.amazonaws.mws.model.ErrorResponse;
import com.amazonaws.mws.model.GetFeedSubmissionCountRequest;
import com.amazonaws.mws.model.GetFeedSubmissionCountResponse;
import com.amazonaws.mws.model.GetFeedSubmissionListByNextTokenRequest;
import com.amazonaws.mws.model.GetFeedSubmissionListByNextTokenResponse;
import com.amazonaws.mws.model.GetFeedSubmissionListRequest;
import com.amazonaws.mws.model.GetFeedSubmissionListResponse;
import com.amazonaws.mws.model.GetFeedSubmissionResultRequest;
import com.amazonaws.mws.model.GetFeedSubmissionResultResponse;
import com.amazonaws.mws.model.GetFeedSubmissionResultResult;
import com.amazonaws.mws.model.GetReportCountRequest;
import com.amazonaws.mws.model.GetReportCountResponse;
import com.amazonaws.mws.model.GetReportListByNextTokenRequest;
import com.amazonaws.mws.model.GetReportListByNextTokenResponse;
import com.amazonaws.mws.model.GetReportListRequest;
import com.amazonaws.mws.model.GetReportListResponse;
import com.amazonaws.mws.model.GetReportRequest;
import com.amazonaws.mws.model.GetReportRequestCountRequest;
import com.amazonaws.mws.model.GetReportRequestCountResponse;
import com.amazonaws.mws.model.GetReportRequestListByNextTokenRequest;
import com.amazonaws.mws.model.GetReportRequestListByNextTokenResponse;
import com.amazonaws.mws.model.GetReportRequestListRequest;
import com.amazonaws.mws.model.GetReportRequestListResponse;
import com.amazonaws.mws.model.GetReportResponse;
import com.amazonaws.mws.model.GetReportResult;
import com.amazonaws.mws.model.GetReportScheduleCountRequest;
import com.amazonaws.mws.model.GetReportScheduleCountResponse;
import com.amazonaws.mws.model.GetReportScheduleListByNextTokenRequest;
import com.amazonaws.mws.model.GetReportScheduleListByNextTokenResponse;
import com.amazonaws.mws.model.GetReportScheduleListRequest;
import com.amazonaws.mws.model.GetReportScheduleListResponse;
import com.amazonaws.mws.model.IdList;
import com.amazonaws.mws.model.ManageReportScheduleRequest;
import com.amazonaws.mws.model.ManageReportScheduleResponse;
import com.amazonaws.mws.model.RequestReportRequest;
import com.amazonaws.mws.model.RequestReportResponse;
import com.amazonaws.mws.model.ResponseHeaderMetadata;
import com.amazonaws.mws.model.ResponseMetadata;
import com.amazonaws.mws.model.StatusList;
import com.amazonaws.mws.model.SubmitFeedRequest;
import com.amazonaws.mws.model.SubmitFeedResponse;
import com.amazonaws.mws.model.TypeList;
import com.amazonaws.mws.model.UpdateReportAcknowledgementsRequest;
import com.amazonaws.mws.model.UpdateReportAcknowledgementsResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class MarketplaceWebServiceClient
implements MarketplaceWebService {
    private final Log log = LogFactory.getLog(MarketplaceWebServiceClient.class);
    private String awsAccessKeyId = null;
    private String awsSecretAccessKey = null;
    private MarketplaceWebServiceConfig config = null;
    private HttpClient httpClient = null;
    private CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    private HttpContext httpContext = null;
    private ExecutorService asyncExecutor;
    private List<Header> defaultHeaders = new ArrayList<Header>();
    private static JAXBContext jaxbContext;
    private static ThreadLocal<Unmarshaller> unmarshaller;
    private static Pattern ERROR_PATTERN_ONE;
    private static Pattern ERROR_PATTERN_TWO;
    private static String DEFAULT_ENCODING;
    private static final String mwsClientLibraryVersion = "2016-09-21";

    public MarketplaceWebServiceClient(String awsAccessKeyId, String awsSecretAccessKey, String applicationName, String applicationVersion) {
        this(awsAccessKeyId, awsSecretAccessKey, applicationName, applicationVersion, new MarketplaceWebServiceConfig());
    }

    public MarketplaceWebServiceClient(String awsAccessKeyId, String awsSecretAccessKey, String applicationName, String applicationVersion, int maxAsyncThreads) {
        this(awsAccessKeyId, awsSecretAccessKey, applicationName, applicationVersion, new MarketplaceWebServiceConfig().withMaxAsyncThreads(maxAsyncThreads));
    }

    public MarketplaceWebServiceClient(String awsAccessKeyId, String awsSecretAccessKey, String applicationName, String applicationVersion, MarketplaceWebServiceConfig config) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretAccessKey = awsSecretAccessKey;
        this.config = config;
        this.httpClient = this.configureHttpClient(applicationName, applicationVersion);
        this.asyncExecutor = new ThreadPoolExecutor(config.getMaxAsyncThreads(), config.getMaxAsyncThreads(), 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue<Runnable>(config.getMaxAsyncQueueSize()){

            @Override
            public boolean offer(Runnable task) {
                MarketplaceWebServiceClient.this.log.debug((Object)"Maximum number of concurrent threads reached, queuing task...");
                return super.offer(task);
            }
        }, new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable task) {
                Thread thread = new Thread(task, "MarketplaceWebServiceClient-Thread-" + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                if (thread.getPriority() != 5) {
                    thread.setPriority(5);
                }
                MarketplaceWebServiceClient.this.log.debug((Object)("ThreadFactory created new thread: " + thread.getName()));
                return thread;
            }
        }, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
                MarketplaceWebServiceClient.this.log.debug((Object)("Maximum number of concurrent threads reached, and queue is full. Running task in the calling thread..." + Thread.currentThread().getName()));
                if (!executor.isShutdown()) {
                    task.run();
                }
            }
        });
    }

    @Override
    public GetReportResponse getReport(GetReportRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetReportResponse.class, this.convertGetReport(request), request);
    }

    @Override
    public Future<GetReportResponse> getReportAsync(final GetReportRequest request) {
        Future<GetReportResponse> response = this.asyncExecutor.submit(new Callable<GetReportResponse>(){

            @Override
            public GetReportResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getReport(request);
            }
        });
        return response;
    }

    @Override
    public GetReportScheduleCountResponse getReportScheduleCount(GetReportScheduleCountRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetReportScheduleCountResponse.class, this.convertGetReportScheduleCount(request));
    }

    @Override
    public Future<GetReportScheduleCountResponse> getReportScheduleCountAsync(final GetReportScheduleCountRequest request) {
        Future<GetReportScheduleCountResponse> response = this.asyncExecutor.submit(new Callable<GetReportScheduleCountResponse>(){

            @Override
            public GetReportScheduleCountResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getReportScheduleCount(request);
            }
        });
        return response;
    }

    @Override
    public GetReportRequestListByNextTokenResponse getReportRequestListByNextToken(GetReportRequestListByNextTokenRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetReportRequestListByNextTokenResponse.class, this.convertGetReportRequestListByNextToken(request));
    }

    @Override
    public Future<GetReportRequestListByNextTokenResponse> getReportRequestListByNextTokenAsync(final GetReportRequestListByNextTokenRequest request) {
        Future<GetReportRequestListByNextTokenResponse> response = this.asyncExecutor.submit(new Callable<GetReportRequestListByNextTokenResponse>(){

            @Override
            public GetReportRequestListByNextTokenResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getReportRequestListByNextToken(request);
            }
        });
        return response;
    }

    @Override
    public UpdateReportAcknowledgementsResponse updateReportAcknowledgements(UpdateReportAcknowledgementsRequest request) throws MarketplaceWebServiceException {
        return this.invoke(UpdateReportAcknowledgementsResponse.class, this.convertUpdateReportAcknowledgements(request));
    }

    @Override
    public Future<UpdateReportAcknowledgementsResponse> updateReportAcknowledgementsAsync(final UpdateReportAcknowledgementsRequest request) {
        Future<UpdateReportAcknowledgementsResponse> response = this.asyncExecutor.submit(new Callable<UpdateReportAcknowledgementsResponse>(){

            @Override
            public UpdateReportAcknowledgementsResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.updateReportAcknowledgements(request);
            }
        });
        return response;
    }

    @Override
    public SubmitFeedResponse submitFeed(SubmitFeedRequest request) throws MarketplaceWebServiceException {
        return this.invoke(SubmitFeedResponse.class, this.convertSubmitFeed(request), request);
    }

    @Override
    public Future<SubmitFeedResponse> submitFeedAsync(final SubmitFeedRequest request) {
        Future<SubmitFeedResponse> response = this.asyncExecutor.submit(new Callable<SubmitFeedResponse>(){

            @Override
            public SubmitFeedResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.submitFeed(request);
            }
        });
        return response;
    }

    @Override
    public SubmitFeedResponse submitFeedFromFile(SubmitFeedRequest request) throws MarketplaceWebServiceException {
        try {
            String contentMd5 = this.computeContentMD5HeaderValue((FileInputStream)request.getFeedContent());
            request.setContentMD5(contentMd5);
        }
        catch (Throwable t) {
            throw new MarketplaceWebServiceException(t);
        }
        return this.submitFeed(request);
    }

    @Override
    public Future<SubmitFeedResponse> submitFeedFromFileAsync(final SubmitFeedRequest request) {
        Future<SubmitFeedResponse> response = this.asyncExecutor.submit(new Callable<SubmitFeedResponse>(){

            @Override
            public SubmitFeedResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.submitFeedFromFile(request);
            }
        });
        return response;
    }

    @Override
    public GetReportCountResponse getReportCount(GetReportCountRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetReportCountResponse.class, this.convertGetReportCount(request));
    }

    @Override
    public Future<GetReportCountResponse> getReportCountAsync(final GetReportCountRequest request) {
        Future<GetReportCountResponse> response = this.asyncExecutor.submit(new Callable<GetReportCountResponse>(){

            @Override
            public GetReportCountResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getReportCount(request);
            }
        });
        return response;
    }

    @Override
    public GetFeedSubmissionListByNextTokenResponse getFeedSubmissionListByNextToken(GetFeedSubmissionListByNextTokenRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetFeedSubmissionListByNextTokenResponse.class, this.convertGetFeedSubmissionListByNextToken(request));
    }

    @Override
    public Future<GetFeedSubmissionListByNextTokenResponse> getFeedSubmissionListByNextTokenAsync(final GetFeedSubmissionListByNextTokenRequest request) {
        Future<GetFeedSubmissionListByNextTokenResponse> response = this.asyncExecutor.submit(new Callable<GetFeedSubmissionListByNextTokenResponse>(){

            @Override
            public GetFeedSubmissionListByNextTokenResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getFeedSubmissionListByNextToken(request);
            }
        });
        return response;
    }

    @Override
    public CancelFeedSubmissionsResponse cancelFeedSubmissions(CancelFeedSubmissionsRequest request) throws MarketplaceWebServiceException {
        return this.invoke(CancelFeedSubmissionsResponse.class, this.convertCancelFeedSubmissions(request));
    }

    @Override
    public Future<CancelFeedSubmissionsResponse> cancelFeedSubmissionsAsync(final CancelFeedSubmissionsRequest request) {
        Future<CancelFeedSubmissionsResponse> response = this.asyncExecutor.submit(new Callable<CancelFeedSubmissionsResponse>(){

            @Override
            public CancelFeedSubmissionsResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.cancelFeedSubmissions(request);
            }
        });
        return response;
    }

    @Override
    public RequestReportResponse requestReport(RequestReportRequest request) throws MarketplaceWebServiceException {
        return this.invoke(RequestReportResponse.class, this.convertRequestReport(request));
    }

    @Override
    public Future<RequestReportResponse> requestReportAsync(final RequestReportRequest request) {
        Future<RequestReportResponse> response = this.asyncExecutor.submit(new Callable<RequestReportResponse>(){

            @Override
            public RequestReportResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.requestReport(request);
            }
        });
        return response;
    }

    @Override
    public GetFeedSubmissionCountResponse getFeedSubmissionCount(GetFeedSubmissionCountRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetFeedSubmissionCountResponse.class, this.convertGetFeedSubmissionCount(request));
    }

    @Override
    public Future<GetFeedSubmissionCountResponse> getFeedSubmissionCountAsync(final GetFeedSubmissionCountRequest request) {
        Future<GetFeedSubmissionCountResponse> response = this.asyncExecutor.submit(new Callable<GetFeedSubmissionCountResponse>(){

            @Override
            public GetFeedSubmissionCountResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getFeedSubmissionCount(request);
            }
        });
        return response;
    }

    @Override
    public CancelReportRequestsResponse cancelReportRequests(CancelReportRequestsRequest request) throws MarketplaceWebServiceException {
        return this.invoke(CancelReportRequestsResponse.class, this.convertCancelReportRequests(request));
    }

    @Override
    public Future<CancelReportRequestsResponse> cancelReportRequestsAsync(final CancelReportRequestsRequest request) {
        Future<CancelReportRequestsResponse> response = this.asyncExecutor.submit(new Callable<CancelReportRequestsResponse>(){

            @Override
            public CancelReportRequestsResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.cancelReportRequests(request);
            }
        });
        return response;
    }

    @Override
    public GetReportListResponse getReportList(GetReportListRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetReportListResponse.class, this.convertGetReportList(request));
    }

    @Override
    public Future<GetReportListResponse> getReportListAsync(final GetReportListRequest request) {
        Future<GetReportListResponse> response = this.asyncExecutor.submit(new Callable<GetReportListResponse>(){

            @Override
            public GetReportListResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getReportList(request);
            }
        });
        return response;
    }

    @Override
    public GetFeedSubmissionResultResponse getFeedSubmissionResult(GetFeedSubmissionResultRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetFeedSubmissionResultResponse.class, this.convertGetFeedSubmissionResult(request), request);
    }

    @Override
    public Future<GetFeedSubmissionResultResponse> getFeedSubmissionResultAsync(final GetFeedSubmissionResultRequest request) {
        Future<GetFeedSubmissionResultResponse> response = this.asyncExecutor.submit(new Callable<GetFeedSubmissionResultResponse>(){

            @Override
            public GetFeedSubmissionResultResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getFeedSubmissionResult(request);
            }
        });
        return response;
    }

    @Override
    public GetFeedSubmissionListResponse getFeedSubmissionList(GetFeedSubmissionListRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetFeedSubmissionListResponse.class, this.convertGetFeedSubmissionList(request));
    }

    @Override
    public Future<GetFeedSubmissionListResponse> getFeedSubmissionListAsync(final GetFeedSubmissionListRequest request) {
        Future<GetFeedSubmissionListResponse> response = this.asyncExecutor.submit(new Callable<GetFeedSubmissionListResponse>(){

            @Override
            public GetFeedSubmissionListResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getFeedSubmissionList(request);
            }
        });
        return response;
    }

    @Override
    public GetReportRequestListResponse getReportRequestList(GetReportRequestListRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetReportRequestListResponse.class, this.convertGetReportRequestList(request));
    }

    @Override
    public Future<GetReportRequestListResponse> getReportRequestListAsync(final GetReportRequestListRequest request) {
        Future<GetReportRequestListResponse> response = this.asyncExecutor.submit(new Callable<GetReportRequestListResponse>(){

            @Override
            public GetReportRequestListResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getReportRequestList(request);
            }
        });
        return response;
    }

    @Override
    public GetReportScheduleListByNextTokenResponse getReportScheduleListByNextToken(GetReportScheduleListByNextTokenRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetReportScheduleListByNextTokenResponse.class, this.convertGetReportScheduleListByNextToken(request));
    }

    @Override
    public Future<GetReportScheduleListByNextTokenResponse> getReportScheduleListByNextTokenAsync(final GetReportScheduleListByNextTokenRequest request) {
        Future<GetReportScheduleListByNextTokenResponse> response = this.asyncExecutor.submit(new Callable<GetReportScheduleListByNextTokenResponse>(){

            @Override
            public GetReportScheduleListByNextTokenResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getReportScheduleListByNextToken(request);
            }
        });
        return response;
    }

    @Override
    public GetReportListByNextTokenResponse getReportListByNextToken(GetReportListByNextTokenRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetReportListByNextTokenResponse.class, this.convertGetReportListByNextToken(request));
    }

    @Override
    public Future<GetReportListByNextTokenResponse> getReportListByNextTokenAsync(final GetReportListByNextTokenRequest request) {
        Future<GetReportListByNextTokenResponse> response = this.asyncExecutor.submit(new Callable<GetReportListByNextTokenResponse>(){

            @Override
            public GetReportListByNextTokenResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getReportListByNextToken(request);
            }
        });
        return response;
    }

    @Override
    public ManageReportScheduleResponse manageReportSchedule(ManageReportScheduleRequest request) throws MarketplaceWebServiceException {
        return this.invoke(ManageReportScheduleResponse.class, this.convertManageReportSchedule(request));
    }

    @Override
    public Future<ManageReportScheduleResponse> manageReportScheduleAsync(final ManageReportScheduleRequest request) {
        Future<ManageReportScheduleResponse> response = this.asyncExecutor.submit(new Callable<ManageReportScheduleResponse>(){

            @Override
            public ManageReportScheduleResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.manageReportSchedule(request);
            }
        });
        return response;
    }

    @Override
    public GetReportRequestCountResponse getReportRequestCount(GetReportRequestCountRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetReportRequestCountResponse.class, this.convertGetReportRequestCount(request));
    }

    @Override
    public Future<GetReportRequestCountResponse> getReportRequestCountAsync(final GetReportRequestCountRequest request) {
        Future<GetReportRequestCountResponse> response = this.asyncExecutor.submit(new Callable<GetReportRequestCountResponse>(){

            @Override
            public GetReportRequestCountResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getReportRequestCount(request);
            }
        });
        return response;
    }

    @Override
    public GetReportScheduleListResponse getReportScheduleList(GetReportScheduleListRequest request) throws MarketplaceWebServiceException {
        return this.invoke(GetReportScheduleListResponse.class, this.convertGetReportScheduleList(request));
    }

    @Override
    public Future<GetReportScheduleListResponse> getReportScheduleListAsync(final GetReportScheduleListRequest request) {
        Future<GetReportScheduleListResponse> response = this.asyncExecutor.submit(new Callable<GetReportScheduleListResponse>(){

            @Override
            public GetReportScheduleListResponse call() throws MarketplaceWebServiceException {
                return MarketplaceWebServiceClient.this.getReportScheduleList(request);
            }
        });
        return response;
    }

    private static String clean(String s) {
        return s.replaceAll("\\s", " ").replaceAll(" {2,}", " ").trim();
    }

    public static String quoteAppName(String s) {
        return MarketplaceWebServiceClient.clean(s).replace("\\", "\\\\").replace("/", "\\/");
    }

    public static String quoteAppVersion(String s) {
        return MarketplaceWebServiceClient.clean(s).replace("\\", "\\\\").replace("(", "\\(");
    }

    public static String quoteAttributeName(String s) {
        return MarketplaceWebServiceClient.clean(s).replace("\\", "\\\\").replace("=", "\\=");
    }

    public static String quoteAttributeValue(String s) {
        return MarketplaceWebServiceClient.clean(s).replace("\\", "\\\\").replace(";", "\\;").replace(")", "\\)");
    }

    private HttpClient configureHttpClient(String applicationName, String applicationVersion) {
        if (this.config.getUserAgent() == null) {
            this.config.setUserAgent(MarketplaceWebServiceClient.quoteAppName(applicationName), MarketplaceWebServiceClient.quoteAppVersion(applicationVersion), MarketplaceWebServiceClient.quoteAttributeValue("Java/" + System.getProperty("java.version") + "/" + System.getProperty("java.class.version") + "/" + System.getProperty("java.vendor")), MarketplaceWebServiceClient.quoteAttributeName("Platform"), MarketplaceWebServiceClient.quoteAttributeValue("" + System.getProperty("os.name") + "/" + System.getProperty("os.arch") + "/" + System.getProperty("os.version")), MarketplaceWebServiceClient.quoteAttributeName("MWSClientVersion"), MarketplaceWebServiceClient.quoteAttributeValue(mwsClientLibraryVersion));
        }
        this.defaultHeaders.add((Header)new BasicHeader("X-Amazon-User-Agent", this.config.getUserAgent()));
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.useragent", (Object)this.config.getUserAgent());
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.config.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.config.getSoTimeout());
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpParams, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams, (boolean)true);
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setMaxTotal(this.config.getMaxAsyncQueueSize());
        connectionManager.setDefaultMaxPerRoute(this.config.getMaxAsyncQueueSize());
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpParams);
        this.httpContext = new BasicHttpContext();
        if (this.config.isSetProxyHost() && this.config.isSetProxyPort()) {
            String proxyProtocol = null;
            proxyProtocol = this.config.isSetProxyProtocol() ? this.config.getProxyProtocol().toString().toLowerCase() : (MarketplaceWebServiceClient.usesHttps(this.config.getServiceURL()) ? "https" : "http");
            this.log.info((Object)("Configuring Proxy. Proxy Host: " + this.config.getProxyHost() + " Proxy Port: " + this.config.getProxyPort() + " Proxy protocol: " + proxyProtocol));
            HttpHost hostConfiguration = new HttpHost(this.config.getProxyHost(), this.config.getProxyPort(), proxyProtocol);
            this.httpContext = new BasicHttpContext();
            this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)hostConfiguration);
            if (this.config.isSetProxyUsername() && this.config.isSetProxyPassword()) {
                this.credentialsProvider.setCredentials(new AuthScope(this.config.getProxyHost(), this.config.getProxyPort()), (Credentials)new UsernamePasswordCredentials(this.config.getProxyUsername(), this.config.getProxyPassword()));
                this.httpContext.setAttribute("http.auth.credentials-provider", (Object)this.credentialsProvider);
            }
        }
        return this.httpClient;
    }

    private void copyResponseToOutputStream(InputStream from, OutputStream to) throws IOException {
        byte[] buffer = new byte[0x100000];
        int read = 0;
        while ((read = from.read(buffer)) > 0) {
            to.write(buffer, 0, read);
        }
    }

    private void addRequiredParameters(Map<String, String> parameters) throws SignatureException {
        parameters.put("Version", this.config.getServiceVersion());
        parameters.put("SignatureVersion", "2");
        parameters.put("Timestamp", this.getFormattedTimestamp());
        parameters.put("AWSAccessKeyId", this.awsAccessKeyId);
        parameters.put("Signature", this.signParameters(parameters, this.awsSecretAccessKey));
    }

    private String getSubmitFeedUrlParameters(Map<String, String> parameters) throws SignatureException, MarketplaceWebServiceException {
        this.addRequiredParameters(parameters);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (sb.length() != 0) {
                sb.append("&");
            }
            try {
                String key = URLEncoder.encode(entry.getKey(), "UTF-8");
                String value = URLEncoder.encode(entry.getValue(), "UTF-8");
                sb.append(key + "=" + value);
            }
            catch (Throwable t) {
                this.log.error((Object)"Caught Exception", t);
                throw new MarketplaceWebServiceException(t);
            }
        }
        return sb.toString();
    }

    private <T> T invoke(Class<T> clazz, Map<String, String> parameters) throws MarketplaceWebServiceException {
        return this.invoke(clazz, parameters, null);
    }

    private <T, U> T invoke(Class<T> clazz, Map<String, String> parameters, U request) throws MarketplaceWebServiceException {
        String actionName = parameters.get("Action");
        T response = null;
        String responseBodyString = null;
        ResponseHeaderMetadata responseHeaderMetadata = null;
        Method responseHeaderMetadataSetter = null;
        HttpPost method = null;
        try {
            responseHeaderMetadataSetter = clazz.getMethod("setResponseHeaderMetadata", ResponseHeaderMetadata.class);
            if (!this.config.isSetServiceURL()) {
                throw new MarketplaceWebServiceException("Missing serviceUrl configuration value. You may obtain a list of valid MWS URLs by consulting the MWS Developer's Guide, or reviewing the sample code published along side this library.", -1, "InvalidServiceUrl", "Sender", null, null, null){};
            }
            if (request instanceof SubmitFeedRequest) {
                SubmitFeedRequest sfr = (SubmitFeedRequest)request;
                method = new HttpPost(this.config.getServiceURL() + "?" + this.getSubmitFeedUrlParameters(parameters));
                method.setEntity((HttpEntity)new InputStreamEntity(sfr.getFeedContent(), -1L));
                method.addHeader((Header)new BasicHeader("Content-Type", sfr.getContentType().toString()));
            } else {
                method = new HttpPost(this.config.getServiceURL());
                this.log.debug((Object)"Adding required parameters...");
                this.addRequiredParametersToRequest(method, parameters);
                this.log.debug((Object)("Setting content-type to application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase()));
                method.addHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase()));
                this.log.debug((Object)("Done adding additional required parameters. Parameters now: " + parameters));
            }
            for (Header head : this.defaultHeaders) {
                method.addHeader(head);
            }
        }
        catch (Throwable t) {
            throw new MarketplaceWebServiceException(t);
        }
        int status = -1;
        this.log.debug((Object)("Invoking" + actionName + " request. Current parameters: " + parameters));
        try {
            boolean shouldRetry = true;
            int retries = 0;
            do {
                this.log.debug((Object)("Sending Request to host:  " + this.config.getServiceURL()));
                try {
                    boolean isStreamingResponse;
                    HttpResponse postResponse = this.httpClient.execute((HttpUriRequest)method, this.httpContext);
                    status = postResponse.getStatusLine().getStatusCode();
                    responseHeaderMetadata = this.getResponseHeaderMetadata(postResponse);
                    boolean bl = isStreamingResponse = request instanceof GetFeedSubmissionResultRequest || request instanceof GetReportRequest;
                    if (!isStreamingResponse) {
                        responseBodyString = this.getResponsBodyAsString(postResponse.getEntity().getContent());
                        assert (responseBodyString != null);
                    }
                    if (status == 200 && responseBodyString != null) {
                        shouldRetry = false;
                        this.log.debug((Object)("Received Response. Status: " + status + ". Response Body: " + responseBodyString));
                        this.log.debug((Object)("Attempting to unmarshal into the " + actionName + "Response type..."));
                        response = clazz.cast(this.getUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(responseBodyString))));
                        responseHeaderMetadataSetter.invoke(response, responseHeaderMetadata);
                        this.log.debug((Object)("Unmarshalled response into " + actionName + "Response type."));
                        continue;
                    }
                    if (status == 200 && isStreamingResponse) {
                        Object r;
                        Method outputStreamGetter = null;
                        for (Method m : request.getClass().getMethods()) {
                            if (!m.getName().matches("get.+OutputStream$")) continue;
                            outputStreamGetter = m;
                        }
                        OutputStream originalOs = (OutputStream)outputStreamGetter.invoke(request, new Object[0]);
                        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                        DigestOutputStream os = new DigestOutputStream(originalOs, messageDigest);
                        String requestIdFromHeader = null;
                        requestIdFromHeader = this.getFirstHeader(postResponse, "x-amz-request-id").getValue();
                        if (requestIdFromHeader == null || requestIdFromHeader.length() == 0) {
                            throw new MarketplaceWebServiceException("no request id returned in the x-amz-request-id HTTP header for a streaming response call - please contact Amazon");
                        }
                        String returnedContentMD5 = null;
                        returnedContentMD5 = this.getFirstHeader(postResponse, "Content-MD5").getValue();
                        this.copyResponseToOutputStream(postResponse.getEntity().getContent(), os);
                        String calculatedContentMD5 = new String(Base64.encodeBase64((byte[])messageDigest.digest()), "UTF-8");
                        if (!calculatedContentMD5.equals(returnedContentMD5)) {
                            throw new MarketplaceWebServiceException("Content-MD5 HTTP header transmitted by MWS (" + returnedContentMD5 + ") does not match the calculated MD5 (" + calculatedContentMD5 + ") in request id " + requestIdFromHeader + " - please contact Amazon");
                        }
                        response = clazz.newInstance();
                        responseHeaderMetadataSetter.invoke(response, responseHeaderMetadata);
                        if (clazz == GetFeedSubmissionResultResponse.class) {
                            r = (GetFeedSubmissionResultResponse)response;
                            ((GetFeedSubmissionResultResponse)r).setGetFeedSubmissionResultResult(new GetFeedSubmissionResultResult(returnedContentMD5));
                            ((GetFeedSubmissionResultResponse)r).setResponseMetadata(new ResponseMetadata(requestIdFromHeader));
                        } else if (clazz == GetReportResponse.class) {
                            r = (GetReportResponse)response;
                            ((GetReportResponse)r).setGetReportResult(new GetReportResult(returnedContentMD5));
                            ((GetReportResponse)r).setResponseMetadata(new ResponseMetadata(requestIdFromHeader));
                        } else {
                            throw new MarketplaceWebServiceException("unexpected streaming-response class " + clazz.getName() + " - please contact Amazon");
                        }
                        shouldRetry = false;
                        this.log.debug((Object)"Received streaming response.");
                        continue;
                    }
                    if (isStreamingResponse) {
                        responseBodyString = this.getResponsBodyAsString(postResponse.getEntity().getContent());
                    }
                    this.log.debug((Object)("Received Response. Status: " + status + "."));
                    if (status == 500 && !(request instanceof SubmitFeedRequest) && this.pauseIfRetryNeeded(++retries)) {
                        shouldRetry = true;
                        continue;
                    }
                    this.log.debug((Object)"Attempting to unmarshal into the ErrorResponse type...");
                    ErrorResponse errorResponse = (ErrorResponse)this.getUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(responseBodyString)));
                    this.log.debug((Object)"Unmarshalled response into the ErrorResponse type.");
                    Error error = errorResponse.getError().get(0);
                    if (status == 503 && !error.getCode().equals("RequestThrottled") && !(request instanceof SubmitFeedRequest) && this.pauseIfRetryNeeded(++retries)) {
                        shouldRetry = true;
                        continue;
                    }
                    shouldRetry = false;
                    throw new MarketplaceWebServiceException(request instanceof SubmitFeedRequest && error.getType().equals("Receiver") ? error.getMessage() + " [Cannot retry SubmitFeed request: must reset InputStream to retry.]" : error.getMessage(), status, error.getCode(), error.getType(), errorResponse.getRequestId(), errorResponse.toXML(), responseHeaderMetadata);
                }
                catch (JAXBException je) {
                    this.log.debug((Object)"Caught JAXBException", (Throwable)je);
                    this.log.debug((Object)("Response cannot be unmarshalled neither as " + actionName + "Response or ErrorResponse types.Checking for other possible errors."));
                    MarketplaceWebServiceException awse = this.processErrors(responseBodyString, status, responseHeaderMetadata);
                    throw awse;
                }
                catch (IOException ioe) {
                    this.log.error((Object)"Caught IOException exception", (Throwable)ioe);
                    if (this.config.isSetProxyHost() && this.config.isSetProxyPort() && ioe instanceof SSLPeerUnverifiedException) {
                        String error = "\n*****\n* Perhaps you are attempting to use https protocol to communicate with the proxy that does not support it.\n* If so either enable https on the proxy, or configure the client to use http communications with the proxy.\n* See  MarketplaceWebServiceClientConfig.setProxyProtocol for details.\n*****";
                        this.log.error((Object)error);
                    }
                    throw new MarketplaceWebServiceException("Internal Error", ioe);
                }
                catch (Exception e) {
                    this.log.error((Object)"Caught Exception", (Throwable)e);
                    throw new MarketplaceWebServiceException(e);
                }
                finally {
                    method.releaseConnection();
                }
            } while (shouldRetry);
        }
        catch (MarketplaceWebServiceException se) {
            this.log.error((Object)"Caught MarketplaceWebServiceException", (Throwable)se);
            throw se;
        }
        catch (Throwable t) {
            this.log.error((Object)"Caught Exception", t);
            throw new MarketplaceWebServiceException(t);
        }
        return response;
    }

    private Header getFirstHeader(HttpResponse response, String headerName) {
        Header[] responseHeaders = response.getHeaders(headerName);
        if (responseHeaders.length > 0) {
            return responseHeaders[0];
        }
        return null;
    }

    private ResponseHeaderMetadata getResponseHeaderMetadata(HttpResponse response) {
        Header requestId = null;
        Header responseContext = null;
        Header timestamp = null;
        requestId = this.getFirstHeader(response, "x-mws-request-id");
        responseContext = this.getFirstHeader(response, "x-mws-response-context");
        timestamp = this.getFirstHeader(response, "x-mws-timestamp");
        return new ResponseHeaderMetadata(requestId != null ? requestId.getValue() : null, responseContext != null ? responseContext.getValue() : null, timestamp != null ? timestamp.getValue() : null);
    }

    private String computeContentMD5HeaderValue(FileInputStream fis) throws IOException, NoSuchAlgorithmException {
        DigestInputStream dis = new DigestInputStream(fis, MessageDigest.getInstance("MD5"));
        byte[] buffer = new byte[8192];
        while (dis.read(buffer) > 0) {
        }
        String md5Content = new String(Base64.encodeBase64((byte[])dis.getMessageDigest().digest()));
        fis.getChannel().position(0L);
        return md5Content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponsBodyAsString(InputStream input) throws IOException {
        String responsBodyString = null;
        try {
            int len;
            InputStreamReader reader = new InputStreamReader(input, DEFAULT_ENCODING);
            StringBuilder b = new StringBuilder();
            char[] c = new char[1024];
            while (0 < (len = reader.read(c))) {
                b.append(c, 0, len);
            }
            responsBodyString = b.toString();
        }
        finally {
            input.close();
        }
        return responsBodyString;
    }

    private boolean pauseIfRetryNeeded(int retries) throws InterruptedException {
        if (retries <= this.config.getMaxErrorRetry()) {
            long delay = (long)(Math.pow(4.0, retries) * 100.0);
            this.log.debug((Object)("Retriable error detected, will retry in " + delay + "ms, attempt numer: " + retries));
            Thread.sleep(delay);
            return true;
        }
        return false;
    }

    private void addRequiredParametersToRequest(HttpPost method, Map<String, String> parameters) throws SignatureException, UnsupportedEncodingException {
        this.addRequiredParameters(parameters);
        ArrayList<BasicNameValuePair> parameterList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey() == null ? "" : entry.getKey();
            String value = entry.getValue() == null ? "" : entry.getValue();
            parameterList.add(new BasicNameValuePair(key, value));
        }
        method.setEntity((HttpEntity)new UrlEncodedFormEntity(parameterList, "UTF-8"));
    }

    private MarketplaceWebServiceException processErrors(String responseString, int status, ResponseHeaderMetadata metadata) {
        MarketplaceWebServiceException ex = null;
        Matcher matcher = null;
        if (responseString != null && responseString.startsWith("<")) {
            matcher = ERROR_PATTERN_ONE.matcher(responseString);
            if (matcher.matches()) {
                ex = new MarketplaceWebServiceException(matcher.group(3), status, matcher.group(2), "Unknown", matcher.group(1), responseString, metadata);
            } else {
                matcher = ERROR_PATTERN_TWO.matcher(responseString);
                if (matcher.matches()) {
                    ex = new MarketplaceWebServiceException(matcher.group(2), status, matcher.group(1), "Unknown", matcher.group(4), responseString, metadata);
                } else {
                    ex = new MarketplaceWebServiceException("Internal Error", status, metadata);
                    this.log.error((Object)("Service Error. Response Status: " + status + ". Received message: " + responseString));
                }
            }
        } else {
            ex = new MarketplaceWebServiceException("Internal Error", status, metadata);
            this.log.error((Object)("Service Error. Response Status: " + status + ". Received message: " + responseString));
        }
        return ex;
    }

    private String getFormattedTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(new Date());
    }

    private String signParameters(Map<String, String> parameters, String key) throws SignatureException {
        String signatureVersion = parameters.get("SignatureVersion");
        String algorithm = "HmacSHA1";
        String stringToSign = null;
        if (!"2".equals(signatureVersion)) {
            throw new SignatureException("Invalid Signature Version specified");
        }
        algorithm = this.config.getSignatureMethod();
        parameters.put("SignatureMethod", algorithm);
        stringToSign = this.calculateStringToSignV2(parameters);
        this.log.debug((Object)("Calculated string to sign: " + stringToSign));
        return this.sign(stringToSign, key, algorithm);
    }

    private String calculateStringToSignV2(Map<String, String> parameters) throws SignatureException {
        StringBuilder data = new StringBuilder();
        data.append("POST");
        data.append("\n");
        URI endpoint = null;
        try {
            endpoint = new URI(this.config.getServiceURL().toLowerCase());
        }
        catch (URISyntaxException ex) {
            this.log.error((Object)"URI Syntax Exception", (Throwable)ex);
            throw new SignatureException("URI Syntax Exception thrown while constructing string to sign", ex);
        }
        data.append(endpoint.getHost());
        if (!MarketplaceWebServiceClient.usesAStandardPort(this.config.getServiceURL())) {
            data.append(":");
            data.append(endpoint.getPort());
        }
        data.append("\n");
        String uri = endpoint.getPath();
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        data.append(uri);
        data.append("\n");
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(parameters);
        Iterator pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry pair = pairs.next();
            String key = (String)pair.getKey();
            data.append(this.urlEncode(key));
            data.append("=");
            String value = (String)pair.getValue();
            data.append(this.urlEncode(value));
            if (!pairs.hasNext()) continue;
            data.append("&");
        }
        return data.toString();
    }

    private static boolean usesHttps(String url) {
        URL urlToCheck;
        try {
            urlToCheck = new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return urlToCheck.getProtocol().equals("https");
    }

    private static int extractPortNumber(String url, boolean usesHttps) {
        URL urlToCheck;
        try {
            urlToCheck = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("not a URL", e);
        }
        int portNumber = urlToCheck.getPort();
        if (portNumber == -1) {
            if (usesHttps) {
                return 443;
            }
            return 80;
        }
        return portNumber;
    }

    private static boolean usesAStandardPort(String url) {
        boolean usesHttps = MarketplaceWebServiceClient.usesHttps(url);
        int portNumber = MarketplaceWebServiceClient.extractPortNumber(url, usesHttps);
        return usesHttps && portNumber == 443 || !usesHttps && portNumber == 80;
    }

    private String urlEncode(String rawValue) {
        String value = rawValue == null ? "" : rawValue;
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, DEFAULT_ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException ex) {
            this.log.error((Object)"Unsupported Encoding Exception", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return encoded;
    }

    private String sign(String data, String key, String algorithm) throws SignatureException {
        byte[] signature;
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key.getBytes(), algorithm));
            signature = Base64.encodeBase64((byte[])mac.doFinal(data.getBytes(DEFAULT_ENCODING)));
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate signature: " + e.getMessage(), e);
        }
        return new String(signature);
    }

    private Unmarshaller getUnmarshaller() {
        return unmarshaller.get();
    }

    private Map<String, String> convertGetReport(GetReportRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetReport");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetReportId()) {
            params.put("ReportId", request.getReportId());
        }
        return params;
    }

    private Map<String, String> convertGetReportScheduleCount(GetReportScheduleCountRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetReportScheduleCount");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetReportTypeList()) {
            TypeList reportTypeList = request.getReportTypeList();
            List<String> typeList = reportTypeList.getType();
            for (String type : typeList) {
                params.put("ReportTypeList.Type." + (typeList.indexOf(type) + 1), type);
            }
        }
        return params;
    }

    private Map<String, String> convertGetReportRequestListByNextToken(GetReportRequestListByNextTokenRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetReportRequestListByNextToken");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetNextToken()) {
            params.put("NextToken", request.getNextToken());
        }
        return params;
    }

    private Map<String, String> convertUpdateReportAcknowledgements(UpdateReportAcknowledgementsRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "UpdateReportAcknowledgements");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetReportIdList()) {
            IdList reportIdList = request.getReportIdList();
            List<String> idList = reportIdList.getId();
            for (String id : idList) {
                params.put("ReportIdList.Id." + (idList.indexOf(id) + 1), id);
            }
        }
        if (request.isSetAcknowledged()) {
            params.put("Acknowledged", request.isAcknowledged() + "");
        }
        return params;
    }

    private Map<String, String> convertSubmitFeed(SubmitFeedRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "SubmitFeed");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMarketplaceIdList()) {
            IdList marketplaceIdList = request.getMarketplaceIdList();
            List<String> idList = marketplaceIdList.getId();
            for (int i = 0; i < idList.size(); ++i) {
                params.put("MarketplaceIdList.Id." + (i + 1), idList.get(i));
            }
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetFeedType()) {
            params.put("FeedType", request.getFeedType());
        }
        if (request.isSetPurgeAndReplace()) {
            params.put("PurgeAndReplace", request.isPurgeAndReplace() + "");
        }
        if (request.isSetContentMD5()) {
            params.put("ContentMD5Value", request.getContentMD5());
        }
        if (request.isSetFeedOptions()) {
            params.put("FeedOptions", request.getFeedOptions());
        }
        return params;
    }

    private Map<String, String> convertGetReportCount(GetReportCountRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetReportCount");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetReportTypeList()) {
            TypeList reportTypeList = request.getReportTypeList();
            List<String> typeList = reportTypeList.getType();
            for (String type : typeList) {
                params.put("ReportTypeList.Type." + (typeList.indexOf(type) + 1), type);
            }
        }
        if (request.isSetAcknowledged()) {
            params.put("Acknowledged", request.isAcknowledged() + "");
        }
        if (request.isSetAvailableFromDate()) {
            params.put("AvailableFromDate", request.getAvailableFromDate() + "");
        }
        if (request.isSetAvailableToDate()) {
            params.put("AvailableToDate", request.getAvailableToDate() + "");
        }
        return params;
    }

    private Map<String, String> convertGetFeedSubmissionListByNextToken(GetFeedSubmissionListByNextTokenRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetFeedSubmissionListByNextToken");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetNextToken()) {
            params.put("NextToken", request.getNextToken());
        }
        return params;
    }

    private Map<String, String> convertCancelFeedSubmissions(CancelFeedSubmissionsRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "CancelFeedSubmissions");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetFeedSubmissionIdList()) {
            IdList feedSubmissionIdList = request.getFeedSubmissionIdList();
            List<String> idList = feedSubmissionIdList.getId();
            for (String id : idList) {
                params.put("FeedSubmissionIdList.Id." + (idList.indexOf(id) + 1), id);
            }
        }
        if (request.isSetFeedTypeList()) {
            TypeList feedTypeList = request.getFeedTypeList();
            List<String> typeList = feedTypeList.getType();
            for (String type : typeList) {
                params.put("FeedTypeList.Type." + (typeList.indexOf(type) + 1), type);
            }
        }
        if (request.isSetSubmittedFromDate()) {
            params.put("SubmittedFromDate", request.getSubmittedFromDate() + "");
        }
        if (request.isSetSubmittedToDate()) {
            params.put("SubmittedToDate", request.getSubmittedToDate() + "");
        }
        return params;
    }

    private Map<String, String> convertRequestReport(RequestReportRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "RequestReport");
        if (request.isSetMarketplaceIdList()) {
            IdList marketplaceIdList = request.getMarketplaceIdList();
            List<String> idList = marketplaceIdList.getId();
            for (int i = 0; i < idList.size(); ++i) {
                params.put("MarketplaceIdList.Id." + (i + 1), idList.get(i));
            }
        }
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetReportType()) {
            params.put("ReportType", request.getReportType());
        }
        if (request.isSetStartDate()) {
            params.put("StartDate", request.getStartDate() + "");
        }
        if (request.isSetEndDate()) {
            params.put("EndDate", request.getEndDate() + "");
        }
        if (request.isSetReportOptions()) {
            params.put("ReportOptions", request.getReportOptions());
        }
        return params;
    }

    private Map<String, String> convertGetFeedSubmissionCount(GetFeedSubmissionCountRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetFeedSubmissionCount");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetFeedTypeList()) {
            TypeList feedTypeList = request.getFeedTypeList();
            List<String> typeList = feedTypeList.getType();
            for (String type : typeList) {
                params.put("FeedTypeList.Type." + (typeList.indexOf(type) + 1), type);
            }
        }
        if (request.isSetFeedProcessingStatusList()) {
            StatusList feedProcessingStatusList = request.getFeedProcessingStatusList();
            List<String> statusList = feedProcessingStatusList.getStatus();
            for (String status : statusList) {
                params.put("FeedProcessingStatusList.Status." + (statusList.indexOf(status) + 1), status);
            }
        }
        if (request.isSetSubmittedFromDate()) {
            params.put("SubmittedFromDate", request.getSubmittedFromDate() + "");
        }
        if (request.isSetSubmittedToDate()) {
            params.put("SubmittedToDate", request.getSubmittedToDate() + "");
        }
        return params;
    }

    private Map<String, String> convertCancelReportRequests(CancelReportRequestsRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "CancelReportRequests");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetReportRequestIdList()) {
            IdList reportRequestIdList = request.getReportRequestIdList();
            List<String> idList = reportRequestIdList.getId();
            for (String id : idList) {
                params.put("ReportRequestIdList.Id." + (idList.indexOf(id) + 1), id);
            }
        }
        if (request.isSetReportTypeList()) {
            TypeList reportTypeList = request.getReportTypeList();
            List<String> typeList = reportTypeList.getType();
            for (String type : typeList) {
                params.put("ReportTypeList.Type." + (typeList.indexOf(type) + 1), type);
            }
        }
        if (request.isSetReportProcessingStatusList()) {
            StatusList reportProcessingStatusList = request.getReportProcessingStatusList();
            List<String> statusList = reportProcessingStatusList.getStatus();
            for (String status : statusList) {
                params.put("ReportProcessingStatusList.Status." + (statusList.indexOf(status) + 1), status);
            }
        }
        if (request.isSetRequestedFromDate()) {
            params.put("RequestedFromDate", request.getRequestedFromDate() + "");
        }
        if (request.isSetRequestedToDate()) {
            params.put("RequestedToDate", request.getRequestedToDate() + "");
        }
        return params;
    }

    private Map<String, String> convertGetReportList(GetReportListRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetReportList");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetMaxCount()) {
            params.put("MaxCount", request.getMaxCount() + "");
        }
        if (request.isSetReportTypeList()) {
            TypeList reportTypeList = request.getReportTypeList();
            List<String> typeList = reportTypeList.getType();
            for (String type : typeList) {
                params.put("ReportTypeList.Type." + (typeList.indexOf(type) + 1), type);
            }
        }
        if (request.isSetAcknowledged()) {
            params.put("Acknowledged", request.isAcknowledged() + "");
        }
        if (request.isSetAvailableFromDate()) {
            params.put("AvailableFromDate", request.getAvailableFromDate() + "");
        }
        if (request.isSetAvailableToDate()) {
            params.put("AvailableToDate", request.getAvailableToDate() + "");
        }
        if (request.isSetReportRequestIdList()) {
            IdList reportRequestIdList = request.getReportRequestIdList();
            List<String> idList = reportRequestIdList.getId();
            for (String id : idList) {
                params.put("ReportRequestIdList.Id." + (idList.indexOf(id) + 1), id);
            }
        }
        return params;
    }

    private Map<String, String> convertGetFeedSubmissionResult(GetFeedSubmissionResultRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetFeedSubmissionResult");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetFeedSubmissionId()) {
            params.put("FeedSubmissionId", request.getFeedSubmissionId());
        }
        return params;
    }

    private Map<String, String> convertGetFeedSubmissionList(GetFeedSubmissionListRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetFeedSubmissionList");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetFeedSubmissionIdList()) {
            IdList feedSubmissionIdList = request.getFeedSubmissionIdList();
            List<String> idList = feedSubmissionIdList.getId();
            for (String id : idList) {
                params.put("FeedSubmissionIdList.Id." + (idList.indexOf(id) + 1), id);
            }
        }
        if (request.isSetMaxCount()) {
            params.put("MaxCount", request.getMaxCount() + "");
        }
        if (request.isSetFeedTypeList()) {
            TypeList feedTypeList = request.getFeedTypeList();
            List<String> typeList = feedTypeList.getType();
            for (String type : typeList) {
                params.put("FeedTypeList.Type." + (typeList.indexOf(type) + 1), type);
            }
        }
        if (request.isSetFeedProcessingStatusList()) {
            StatusList feedProcessingStatusList = request.getFeedProcessingStatusList();
            List<String> statusList = feedProcessingStatusList.getStatus();
            for (String status : statusList) {
                params.put("FeedProcessingStatusList.Status." + (statusList.indexOf(status) + 1), status);
            }
        }
        if (request.isSetSubmittedFromDate()) {
            params.put("SubmittedFromDate", request.getSubmittedFromDate() + "");
        }
        if (request.isSetSubmittedToDate()) {
            params.put("SubmittedToDate", request.getSubmittedToDate() + "");
        }
        return params;
    }

    private Map<String, String> convertGetReportRequestList(GetReportRequestListRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetReportRequestList");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetReportRequestIdList()) {
            IdList reportRequestIdList = request.getReportRequestIdList();
            List<String> idList = reportRequestIdList.getId();
            for (String id : idList) {
                params.put("ReportRequestIdList.Id." + (idList.indexOf(id) + 1), id);
            }
        }
        if (request.isSetReportTypeList()) {
            TypeList reportTypeList = request.getReportTypeList();
            List<String> typeList = reportTypeList.getType();
            for (String type : typeList) {
                params.put("ReportTypeList.Type." + (typeList.indexOf(type) + 1), type);
            }
        }
        if (request.isSetReportProcessingStatusList()) {
            StatusList reportProcessingStatusList = request.getReportProcessingStatusList();
            List<String> statusList = reportProcessingStatusList.getStatus();
            for (String status : statusList) {
                params.put("ReportProcessingStatusList.Status." + (statusList.indexOf(status) + 1), status);
            }
        }
        if (request.isSetMaxCount()) {
            params.put("MaxCount", request.getMaxCount() + "");
        }
        if (request.isSetRequestedFromDate()) {
            params.put("RequestedFromDate", request.getRequestedFromDate() + "");
        }
        if (request.isSetRequestedToDate()) {
            params.put("RequestedToDate", request.getRequestedToDate() + "");
        }
        return params;
    }

    private Map<String, String> convertGetReportScheduleListByNextToken(GetReportScheduleListByNextTokenRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetReportScheduleListByNextToken");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetNextToken()) {
            params.put("NextToken", request.getNextToken());
        }
        return params;
    }

    private Map<String, String> convertGetReportListByNextToken(GetReportListByNextTokenRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetReportListByNextToken");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetNextToken()) {
            params.put("NextToken", request.getNextToken());
        }
        return params;
    }

    private Map<String, String> convertManageReportSchedule(ManageReportScheduleRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "ManageReportSchedule");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetReportType()) {
            params.put("ReportType", request.getReportType());
        }
        if (request.isSetSchedule()) {
            params.put("Schedule", request.getSchedule());
        }
        if (request.isSetScheduleDate()) {
            params.put("ScheduleDate", request.getScheduleDate() + "");
        }
        return params;
    }

    private Map<String, String> convertGetReportRequestCount(GetReportRequestCountRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetReportRequestCount");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetReportTypeList()) {
            TypeList reportTypeList = request.getReportTypeList();
            List<String> typeList = reportTypeList.getType();
            for (String type : typeList) {
                params.put("ReportTypeList.Type." + (typeList.indexOf(type) + 1), type);
            }
        }
        if (request.isSetReportProcessingStatusList()) {
            StatusList reportProcessingStatusList = request.getReportProcessingStatusList();
            List<String> statusList = reportProcessingStatusList.getStatus();
            for (String status : statusList) {
                params.put("ReportProcessingStatusList.Status." + (statusList.indexOf(status) + 1), status);
            }
        }
        if (request.isSetRequestedFromDate()) {
            params.put("RequestedFromDate", request.getRequestedFromDate() + "");
        }
        if (request.isSetRequestedToDate()) {
            params.put("RequestedToDate", request.getRequestedToDate() + "");
        }
        return params;
    }

    private Map<String, String> convertGetReportScheduleList(GetReportScheduleListRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetReportScheduleList");
        if (request.isSetMarketplace()) {
            params.put("Marketplace", request.getMarketplace());
        }
        if (request.isSetMerchant()) {
            params.put("Merchant", request.getMerchant());
        }
        if (request.isSetMWSAuthToken()) {
            params.put("MWSAuthToken", request.getMWSAuthToken());
        }
        if (request.isSetReportTypeList()) {
            TypeList reportTypeList = request.getReportTypeList();
            List<String> typeList = reportTypeList.getType();
            for (String type : typeList) {
                params.put("ReportTypeList.Type." + (typeList.indexOf(type) + 1), type);
            }
        }
        return params;
    }

    static {
        ERROR_PATTERN_ONE = Pattern.compile(".*\\<RequestId>(.*)\\</RequestId>.*\\<Error>\\<Code>(.*)\\</Code>\\<Message>(.*)\\</Message>\\</Error>.*(\\<Error>)?.*", 40);
        ERROR_PATTERN_TWO = Pattern.compile(".*\\<Error>\\<Code>(.*)\\</Code>\\<Message>(.*)\\</Message>\\</Error>.*(\\<Error>)?.*\\<RequestID>(.*)\\</RequestID>.*", 40);
        DEFAULT_ENCODING = "UTF-8";
        try {
            jaxbContext = JAXBContext.newInstance((String)"com.amazonaws.mws.model", (ClassLoader)MarketplaceWebService.class.getClassLoader());
        }
        catch (JAXBException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        unmarshaller = new ThreadLocal<Unmarshaller>(){

            @Override
            protected synchronized Unmarshaller initialValue() {
                try {
                    return jaxbContext.createUnmarshaller();
                }
                catch (JAXBException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
        };
    }
}

