/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws;

public class MarketplaceWebServiceConfig {
    private int connectionTimeout = 50000;
    private int socketTimeout = 50000;
    private String serviceVersion = "2009-01-01";
    private String serviceURL = null;
    private String userAgent = null;
    private String signatureMethod = "HmacSHA256";
    private String proxyHost = null;
    private ProxyProtocol proxyProtocol = null;
    private int proxyPort = -1;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private int maxErrorRetry = 3;
    private int maxAsyncThreads = 30;
    private int maxAsyncQueueSize = this.maxAsyncThreads * 10;

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public MarketplaceWebServiceConfig withConnectionTimeout(int connectionTimeout) {
        this.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public boolean isSetConnectionTimeout() {
        return true;
    }

    public int getSoTimeout() {
        return this.socketTimeout;
    }

    public void setSoTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public MarketplaceWebServiceConfig withSoTimeout(int socketTimeout) {
        this.setSoTimeout(socketTimeout);
        return this;
    }

    public boolean isSetSoTimeout() {
        return true;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public MarketplaceWebServiceConfig withSignatureMethod(String signatureMethod) {
        this.setSignatureMethod(signatureMethod);
        return this;
    }

    public boolean isSetSignatureMethod() {
        return true;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String applicationName, String applicationVersion, String programmingLanguage, String ... additionalNameValuePairs) {
        if (applicationName == null) {
            throw new IllegalArgumentException("applicationName cannot be NULL");
        }
        if (applicationVersion == null) {
            throw new IllegalArgumentException("applicationVersion cannot be NULL");
        }
        if (programmingLanguage == null) {
            throw new IllegalArgumentException("programmingLanguage cannot be NULL");
        }
        if (additionalNameValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("there must be a matching value for every name you pass in");
        }
        StringBuilder b = new StringBuilder();
        b.append(applicationName);
        b.append("/");
        b.append(applicationVersion);
        b.append(" (Language=");
        b.append(programmingLanguage);
        for (int i = 0; i < additionalNameValuePairs.length; i += 2) {
            String name = additionalNameValuePairs[i];
            String value = additionalNameValuePairs[i + 1];
            b.append("; ");
            b.append(name);
            b.append("=");
            b.append(value);
        }
        b.append(")");
        this.userAgent = b.toString();
    }

    public MarketplaceWebServiceConfig withUserAgent(String applicationName, String applicationVersion, String programmingLanguage, String ... additionalNameValuePairs) {
        this.setUserAgent(applicationName, applicationVersion, programmingLanguage, additionalNameValuePairs);
        return this;
    }

    public boolean isSetUserAgent() {
        return this.userAgent != null;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public MarketplaceWebServiceConfig withServiceURL(String serviceURL) {
        this.setServiceURL(serviceURL);
        return this;
    }

    public boolean isSetServiceURL() {
        return this.serviceURL != null;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public MarketplaceWebServiceConfig withProxyHost(String proxyHost) {
        this.setProxyHost(proxyHost);
        return this;
    }

    public boolean isSetProxyHost() {
        return this.proxyHost != null;
    }

    public ProxyProtocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(ProxyProtocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public MarketplaceWebServiceConfig withProxyProtocol(ProxyProtocol proxyProtocol) {
        this.setProxyProtocol(proxyProtocol);
        return this;
    }

    public boolean isSetProxyProtocol() {
        return this.proxyProtocol != null;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public MarketplaceWebServiceConfig withProxyPort(int proxyPort) {
        this.setProxyPort(proxyPort);
        return this;
    }

    public boolean isSetProxyPort() {
        return this.proxyPort != -1;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public MarketplaceWebServiceConfig withProxyUsername(String proxyUsername) {
        this.setProxyUsername(proxyUsername);
        return this;
    }

    public boolean isSetProxyUsername() {
        return this.proxyUsername != null;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public MarketplaceWebServiceConfig withProxyPassword(String proxyPassword) {
        this.setProxyPassword(proxyPassword);
        return this;
    }

    public boolean isSetProxyPassword() {
        return this.proxyPassword != null;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public void setMaxErrorRetry(int maxErrorRetry) {
        this.maxErrorRetry = maxErrorRetry;
    }

    public MarketplaceWebServiceConfig withMaxErrorRetry(int maxErrorRetry) {
        this.setMaxErrorRetry(maxErrorRetry);
        return this;
    }

    public boolean isSetMaxErrorRetry() {
        return this.maxErrorRetry > 0;
    }

    public int getMaxAsyncThreads() {
        return this.maxAsyncThreads;
    }

    public void setMaxAsyncThreads(int maxAsyncThreads) {
        this.maxAsyncThreads = maxAsyncThreads;
    }

    public MarketplaceWebServiceConfig withMaxAsyncThreads(int maxAsyncThreads) {
        this.setMaxAsyncThreads(maxAsyncThreads);
        return this;
    }

    public boolean isSetMaxAsyncThreads() {
        return this.maxAsyncThreads > 0;
    }

    public int getMaxAsyncQueueSize() {
        return this.maxAsyncQueueSize;
    }

    public boolean isSetMaxAsyncQueueSize() {
        return this.maxAsyncQueueSize > 0;
    }

    public void setMaxAsyncQueueSize(int maxAsyncQueueSize) {
        this.maxAsyncQueueSize = maxAsyncQueueSize;
    }

    public MarketplaceWebServiceConfig withMaxAsyncQueueSize(int maxAsyncQueueSize) {
        this.setMaxAsyncQueueSize(maxAsyncQueueSize);
        return this;
    }

    public static enum ProxyProtocol {
        HTTP,
        HTTPS;

    }
}

