/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.model;

import com.amazonaws.mws.model.Error;
import com.amazonaws.mws.model.ResponseHeaderMetadata;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"error", "requestId"})
@XmlRootElement(name="ErrorResponse")
public class ErrorResponse {
    @XmlElement(name="Error", required=true)
    protected List<Error> error;
    @XmlElement(name="RequestID", required=true)
    protected String requestId;
    @XmlTransient
    private ResponseHeaderMetadata responseHeaderMetadata;

    public ErrorResponse() {
    }

    public ErrorResponse(List<Error> error, String requestId) {
        this.error = error;
        this.requestId = requestId;
    }

    public List<Error> getError() {
        if (this.error == null) {
            this.error = new ArrayList<Error>();
        }
        return this.error;
    }

    public boolean isSetError() {
        return this.error != null && !this.error.isEmpty();
    }

    public void unsetError() {
        this.error = null;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String value) {
        this.requestId = value;
    }

    public boolean isSetRequestId() {
        return this.requestId != null;
    }

    public ErrorResponse withError(Error ... values) {
        for (Error value : values) {
            this.getError().add(value);
        }
        return this;
    }

    public ErrorResponse withRequestId(String value) {
        this.setRequestId(value);
        return this;
    }

    public void setError(List<Error> error) {
        this.error = error;
    }

    public boolean isSetResponseHeaderMetadata() {
        return this.responseHeaderMetadata != null;
    }

    public void setResponseHeaderMetadata(ResponseHeaderMetadata responseHeaderMetadata) {
        this.responseHeaderMetadata = responseHeaderMetadata;
    }

    public ResponseHeaderMetadata getResponseHeaderMetadata() {
        return this.responseHeaderMetadata;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<ErrorResponse xmlns=\"http://mws.amazonaws.com/doc/2009-01-01/\">");
        List<Error> errorList = this.getError();
        for (Error error : errorList) {
            xml.append("<Error>");
            xml.append(error.toXMLFragment());
            xml.append("</Error>");
        }
        if (this.isSetRequestId()) {
            xml.append("<RequestID>");
            xml.append(this.escapeXML(this.getRequestId()));
            xml.append("</RequestID>");
        }
        xml.append("</ErrorResponse>");
        return xml.toString();
    }

    private String escapeXML(String string) {
        StringBuffer sb = new StringBuffer();
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#039;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String toJSON() {
        StringBuffer json = new StringBuffer();
        json.append("{\"ErrorResponse\" : {");
        json.append(this.quoteJSON("@xmlns"));
        json.append(" : ");
        json.append(this.quoteJSON("http://mws.amazonaws.com/doc/2009-01-01/"));
        boolean first = true;
        json.append(", ");
        if (this.isSetError()) {
            if (!first) {
                json.append(", ");
            }
            json.append("\"Error\" : [");
            List<Error> errorList = this.getError();
            for (Error error : errorList) {
                if (errorList.indexOf(error) > 0) {
                    json.append(", ");
                }
                json.append("{");
                json.append("");
                json.append(error.toJSONFragment());
                json.append("}");
                first = false;
            }
            json.append("]");
        }
        if (this.isSetRequestId()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("RequestID"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getRequestId()));
            first = false;
        }
        json.append("}");
        json.append("}");
        return json.toString();
    }

    private String quoteJSON(String string) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        int length = string.length();
        block10: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\u" + String.format("%03x", c));
                        continue block10;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }
}

