/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"marketplace", "merchant", "reportType", "schedule", "scheduleDate", "mwsAuthToken"})
@XmlRootElement(name="ManageReportScheduleRequest")
public class ManageReportScheduleRequest {
    @XmlElement(name="Marketplace")
    protected String marketplace;
    @XmlElement(name="Merchant", required=true)
    protected String merchant;
    @XmlElement(name="ReportType", required=true)
    protected String reportType;
    @XmlElement(name="Schedule", required=true)
    protected String schedule;
    @XmlElement(name="ScheduleDate")
    @XmlSchemaType(name="dateTime")
    protected XMLGregorianCalendar scheduleDate;
    @XmlElement(name="MWSAuthToken")
    protected String mwsAuthToken;

    public ManageReportScheduleRequest() {
    }

    public ManageReportScheduleRequest(String marketplace, String merchant, String reportType, String schedule, XMLGregorianCalendar scheduleDate) {
        this(marketplace, merchant, reportType, schedule, scheduleDate, null);
    }

    public ManageReportScheduleRequest(String marketplace, String merchant, String reportType, String schedule, XMLGregorianCalendar scheduleDate, String mwsAuthToken) {
        this.marketplace = marketplace;
        this.merchant = merchant;
        this.reportType = reportType;
        this.schedule = schedule;
        this.scheduleDate = scheduleDate;
        this.mwsAuthToken = mwsAuthToken;
    }

    public String getMarketplace() {
        return this.marketplace;
    }

    public void setMarketplace(String value) {
        this.marketplace = value;
    }

    public boolean isSetMarketplace() {
        return this.marketplace != null;
    }

    public String getMWSAuthToken() {
        return this.mwsAuthToken;
    }

    public void setMWSAuthToken(String authTokenValue) {
        this.mwsAuthToken = authTokenValue;
    }

    public boolean isSetMWSAuthToken() {
        return this.mwsAuthToken != null;
    }

    public String getMerchant() {
        return this.merchant;
    }

    public void setMerchant(String value) {
        this.merchant = value;
    }

    public boolean isSetMerchant() {
        return this.merchant != null;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String value) {
        this.reportType = value;
    }

    public boolean isSetReportType() {
        return this.reportType != null;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String value) {
        this.schedule = value;
    }

    public boolean isSetSchedule() {
        return this.schedule != null;
    }

    public XMLGregorianCalendar getScheduleDate() {
        return this.scheduleDate;
    }

    public void setScheduleDate(XMLGregorianCalendar value) {
        this.scheduleDate = value;
    }

    public boolean isSetScheduleDate() {
        return this.scheduleDate != null;
    }

    public ManageReportScheduleRequest withMarketplace(String value) {
        this.setMarketplace(value);
        return this;
    }

    public ManageReportScheduleRequest withMerchant(String value) {
        this.setMerchant(value);
        return this;
    }

    public ManageReportScheduleRequest withMWSAuthToken(String value) {
        this.setMWSAuthToken(value);
        return this;
    }

    public ManageReportScheduleRequest withReportType(String value) {
        this.setReportType(value);
        return this;
    }

    public ManageReportScheduleRequest withSchedule(String value) {
        this.setSchedule(value);
        return this;
    }

    public ManageReportScheduleRequest withScheduleDate(XMLGregorianCalendar value) {
        this.setScheduleDate(value);
        return this;
    }

    protected String toJSONFragment() {
        StringBuffer json = new StringBuffer();
        boolean first = true;
        if (this.isSetMarketplace()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("Marketplace"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getMarketplace()));
            first = false;
        }
        if (this.isSetMerchant()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("Merchant"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getMerchant()));
            first = false;
        }
        if (this.isSetReportType()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("ReportType"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getReportType()));
            first = false;
        }
        if (this.isSetSchedule()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("Schedule"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getSchedule()));
            first = false;
        }
        if (this.isSetScheduleDate()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("ScheduleDate"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getScheduleDate() + ""));
            first = false;
        }
        if (this.isSetMWSAuthToken()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("MWSAuthToken"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getMWSAuthToken()));
            first = false;
        }
        return json.toString();
    }

    private String quoteJSON(String string) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        int length = string.length();
        block10: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\u" + String.format("%03x", c));
                        continue block10;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }
}

