/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.model;

import com.amazonaws.mws.model.ContentType;
import com.amazonaws.mws.model.IdList;
import java.io.InputStream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"marketplace", "marketplaceIdList", "merchant", "feedContent", "contentMD5", "feedType", "purgeAndReplace", "mwsAuthToken", "feedOptions"})
@XmlRootElement(name="SubmitFeedRequest")
public class SubmitFeedRequest {
    @XmlElement(name="Marketplace")
    protected String marketplace;
    @XmlElement(name="MarketplaceIdList")
    protected IdList marketplaceIdList;
    @XmlElement(name="Merchant", required=true)
    protected String merchant;
    @XmlElement(name="FeedContent", required=true)
    protected InputStream feedContent;
    @XmlElement(name="ContentMD5", required=true)
    protected String contentMD5;
    @XmlElement(name="FeedType", required=true)
    protected String feedType;
    @XmlElement(name="PurgeAndReplace")
    protected Boolean purgeAndReplace;
    @XmlElement(name="FeedOptions")
    protected String feedOptions;
    @XmlTransient
    protected ContentType contentType = ContentType.OctetStream;
    @XmlElement(name="MWSAuthToken")
    protected String mwsAuthToken;

    public SubmitFeedRequest() {
    }

    public SubmitFeedRequest(String marketplace, IdList marketplaceIdList, String merchant, InputStream feedContent, String contentMD5, String feedType, Boolean purgeAndReplace) {
        this(marketplace, merchant, feedContent, contentMD5, feedType, purgeAndReplace, null);
    }

    public SubmitFeedRequest(String marketplace, IdList marketplaceIdList, String merchant, InputStream feedContent, String contentMD5, String feedType, Boolean purgeAndReplace, String mwsAuthToken) {
        this(marketplace, marketplaceIdList, merchant, feedContent, contentMD5, feedType, purgeAndReplace, mwsAuthToken, null);
    }

    public SubmitFeedRequest(String marketplace, IdList marketplaceIdList, String merchant, InputStream feedContent, String contentMD5, String feedType, Boolean purgeAndReplace, String mwsAuthToken, String feedOptions) {
        this();
        this.marketplace = marketplace;
        this.marketplaceIdList = marketplaceIdList;
        this.merchant = merchant;
        this.feedContent = feedContent;
        this.contentMD5 = contentMD5;
        this.feedType = feedType;
        this.purgeAndReplace = purgeAndReplace;
        this.mwsAuthToken = mwsAuthToken;
        this.feedOptions = feedOptions;
    }

    public SubmitFeedRequest(String marketplace, String merchant, InputStream feedContent, String contentMD5, String feedType, Boolean purgeAndReplace) {
        this(marketplace, merchant, feedContent, contentMD5, feedType, purgeAndReplace, null);
    }

    public SubmitFeedRequest(String marketplace, String merchant, InputStream feedContent, String contentMD5, String feedType, Boolean purgeAndReplace, String mwsAuthToken) {
        this();
        this.marketplace = marketplace;
        this.merchant = merchant;
        this.feedContent = feedContent;
        this.contentMD5 = contentMD5;
        this.feedType = feedType;
        this.purgeAndReplace = purgeAndReplace;
        this.mwsAuthToken = mwsAuthToken;
    }

    public SubmitFeedRequest(String marketplace, IdList marketplaceIdList, String merchant, InputStream feedContent, String contentMD5, String feedType, Boolean purgeAndReplace, ContentType contentType) {
        this(marketplace, marketplaceIdList, merchant, feedContent, contentMD5, feedType, purgeAndReplace);
        this.setContentType(contentType);
    }

    public SubmitFeedRequest(String marketplace, IdList marketplaceIdList, String merchant, InputStream feedContent, String contentMD5, String feedType, Boolean purgeAndReplace, ContentType contentType, String mwsAuthToken) {
        this(marketplace, marketplaceIdList, merchant, feedContent, contentMD5, feedType, purgeAndReplace, mwsAuthToken, null);
        this.setContentType(contentType);
    }

    public void setMarketplaceIdList(IdList marketplaceIdList) {
        this.marketplaceIdList = marketplaceIdList;
    }

    public IdList getMarketplaceIdList() {
        return this.marketplaceIdList;
    }

    public SubmitFeedRequest withMarketplaceIdList(IdList marketplaceIdList) {
        this.setMarketplaceIdList(marketplaceIdList);
        return this;
    }

    public boolean isSetMarketplaceIdList() {
        return this.marketplaceIdList != null;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public SubmitFeedRequest withContentType(ContentType value) {
        this.setContentType(value);
        return this;
    }

    public void setContentType(ContentType value) {
        this.contentType = value;
    }

    public boolean isSetContentType() {
        return this.contentType != null;
    }

    public String getMarketplace() {
        return this.marketplace;
    }

    public void setMarketplace(String value) {
        this.marketplace = value;
    }

    public boolean isSetMarketplace() {
        return this.marketplace != null;
    }

    public String getMerchant() {
        return this.merchant;
    }

    public void setMerchant(String value) {
        this.merchant = value;
    }

    public boolean isSetMerchant() {
        return this.merchant != null;
    }

    public InputStream getFeedContent() {
        return this.feedContent;
    }

    public void setFeedContent(InputStream value) {
        this.feedContent = value;
    }

    public boolean isSetFeedContent() {
        return this.feedContent != null;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public void setContentMD5(String value) {
        this.contentMD5 = value;
    }

    public boolean isSetContentMD5() {
        return this.contentMD5 != null;
    }

    public void setFeedOptions(String feedOptions) {
        this.feedOptions = feedOptions;
    }

    public String getFeedOptions() {
        return this.feedOptions;
    }

    public boolean isSetFeedOptions() {
        return this.feedOptions != null;
    }

    public String getFeedType() {
        return this.feedType;
    }

    public void setFeedType(String value) {
        this.feedType = value;
    }

    public boolean isSetFeedType() {
        return this.feedType != null;
    }

    public String getMWSAuthToken() {
        return this.mwsAuthToken;
    }

    public void setMWSAuthToken(String authTokenValue) {
        this.mwsAuthToken = authTokenValue;
    }

    public boolean isSetMWSAuthToken() {
        return this.mwsAuthToken != null;
    }

    public Boolean isPurgeAndReplace() {
        return this.purgeAndReplace;
    }

    public void setPurgeAndReplace(Boolean value) {
        this.purgeAndReplace = value;
    }

    public boolean isSetPurgeAndReplace() {
        return this.purgeAndReplace != null;
    }

    public SubmitFeedRequest withMarketplace(String value) {
        this.setMarketplace(value);
        return this;
    }

    public SubmitFeedRequest withMerchant(String value) {
        this.setMerchant(value);
        return this;
    }

    public SubmitFeedRequest withMWSAuthToken(String value) {
        this.setMWSAuthToken(value);
        return this;
    }

    public SubmitFeedRequest withFeedContent(InputStream value) {
        this.setFeedContent(value);
        return this;
    }

    public SubmitFeedRequest withContentMD5(String value) {
        this.setContentMD5(value);
        return this;
    }

    public SubmitFeedRequest withFeedType(String value) {
        this.setFeedType(value);
        return this;
    }

    public SubmitFeedRequest withPurgeAndReplace(Boolean value) {
        this.setPurgeAndReplace(value);
        return this;
    }

    public SubmitFeedRequest withFeedOptions(String feedOptions) {
        this.setFeedOptions(feedOptions);
        return this;
    }

    protected String toJSONFragment() {
        StringBuffer json = new StringBuffer();
        boolean first = true;
        if (this.isSetMarketplace()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("Marketplace"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getMarketplace()));
            first = false;
        }
        if (this.isSetMerchant()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("Merchant"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getMerchant()));
            first = false;
        }
        if (this.isSetFeedContent()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("FeedContent"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getFeedContent().toString()));
            first = false;
        }
        if (this.isSetFeedType()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("FeedType"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getFeedType()));
            first = false;
        }
        if (this.isSetPurgeAndReplace()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("PurgeAndReplace"));
            json.append(" : ");
            json.append(this.quoteJSON(this.isPurgeAndReplace() + ""));
            first = false;
        }
        if (this.isSetMWSAuthToken()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("MWSAuthToken"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getMWSAuthToken()));
            first = false;
        }
        if (this.isSetFeedOptions()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("FeedOptions"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getFeedOptions()));
            first = false;
        }
        return json.toString();
    }

    private String quoteJSON(String string) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        int length = string.length();
        block10: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\u" + String.format("%03x", c));
                        continue block10;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }
}

