/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TypeList", propOrder={"type"})
public class TypeList {
    @XmlElement(name="Type", required=true)
    protected List<String> type;

    public TypeList() {
    }

    public TypeList(List<String> type) {
        this.type = type;
    }

    public List<String> getType() {
        if (this.type == null) {
            this.type = new ArrayList<String>();
        }
        return this.type;
    }

    public boolean isSetType() {
        return this.type != null && !this.type.isEmpty();
    }

    public void unsetType() {
        this.type = null;
    }

    public TypeList withType(String ... values) {
        for (String value : values) {
            this.getType().add(value);
        }
        return this;
    }

    public void setType(List<String> type) {
        this.type = type;
    }

    protected String toXMLFragment() {
        StringBuffer xml = new StringBuffer();
        List<String> typeList = this.getType();
        for (String type : typeList) {
            xml.append("<Type>");
            xml.append(this.escapeXML(type));
            xml.append("</Type>");
        }
        return xml.toString();
    }

    private String escapeXML(String string) {
        StringBuffer sb = new StringBuffer();
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#039;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    protected String toJSONFragment() {
        StringBuffer json = new StringBuffer();
        boolean first = true;
        if (this.isSetType()) {
            if (!first) {
                json.append(", ");
            }
            json.append("\"Type\" : [");
            List<String> typeList = this.getType();
            for (String type : typeList) {
                if (typeList.indexOf(type) > 0) {
                    json.append(", ");
                }
                json.append(this.quoteJSON(type));
            }
            json.append("]");
            first = false;
        }
        return json.toString();
    }

    private String quoteJSON(String string) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        int length = string.length();
        block10: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\u" + String.format("%03x", c));
                        continue block10;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }
}

