/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.samples;

import com.amazonaws.mws.MarketplaceWebService;
import com.amazonaws.mws.MarketplaceWebServiceClient;
import com.amazonaws.mws.MarketplaceWebServiceConfig;
import com.amazonaws.mws.MarketplaceWebServiceException;
import com.amazonaws.mws.model.GetFeedSubmissionListRequest;
import com.amazonaws.mws.model.GetFeedSubmissionListResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

public class GetFeedSubmissionListAsyncSample {
    public static void main(String ... args) {
        String accessKeyId = "<Your Access Key ID>";
        String secretAccessKey = "<Your Secret Access Key>";
        String appName = "<Your Application or Company Name>";
        String appVersion = "<Your Application Version or Build Number or Release Date>";
        MarketplaceWebServiceConfig config = new MarketplaceWebServiceConfig();
        config.setMaxAsyncThreads(35);
        MarketplaceWebServiceClient service = new MarketplaceWebServiceClient("<Your Access Key ID>", "<Your Secret Access Key>", "<Your Application or Company Name>", "<Your Application Version or Build Number or Release Date>", config);
        String merchantId = "<Your Merchant ID>";
        String sellerDevAuthToken = "<Merchant Developer MWS Auth Token>";
        GetFeedSubmissionListRequest requestOne = new GetFeedSubmissionListRequest();
        requestOne.setMerchant("<Your Merchant ID>");
        GetFeedSubmissionListRequest requestTwo = new GetFeedSubmissionListRequest();
        requestTwo.setMerchant("<Your Merchant ID>");
        ArrayList<GetFeedSubmissionListRequest> requests = new ArrayList<GetFeedSubmissionListRequest>();
        requests.add(requestOne);
        requests.add(requestTwo);
    }

    public static void invokeGetFeedSubmissionList(MarketplaceWebService service, List<GetFeedSubmissionListRequest> requests) {
        ArrayList<Future<GetFeedSubmissionListResponse>> responses = new ArrayList<Future<GetFeedSubmissionListResponse>>();
        for (GetFeedSubmissionListRequest getFeedSubmissionListRequest : requests) {
            responses.add(service.getFeedSubmissionListAsync(getFeedSubmissionListRequest));
        }
        for (Future future : responses) {
            while (!future.isDone()) {
                Thread.yield();
            }
            try {
                GetFeedSubmissionListResponse response = (GetFeedSubmissionListResponse)future.get();
                GetFeedSubmissionListRequest originalRequest = requests.get(responses.indexOf(future));
                System.out.println("Response request id: " + response.getResponseMetadata().getRequestId());
                System.out.println(response.getResponseHeaderMetadata());
                System.out.println();
            }
            catch (Exception e) {
                if (e.getCause() instanceof MarketplaceWebServiceException) {
                    MarketplaceWebServiceException exception = (MarketplaceWebServiceException)MarketplaceWebServiceException.class.cast(e.getCause());
                    System.out.println("Caught Exception: " + exception.getMessage());
                    System.out.println("Response Status Code: " + exception.getStatusCode());
                    System.out.println("Error Code: " + exception.getErrorCode());
                    System.out.println("Error Type: " + exception.getErrorType());
                    System.out.println("Request ID: " + exception.getRequestId());
                    System.out.print("XML: " + exception.getXML());
                    System.out.println("ResponseHeaderMetadata: " + exception.getResponseHeaderMetadata());
                    continue;
                }
                e.printStackTrace();
            }
        }
    }
}

