/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.samples;

import com.amazonaws.mws.MarketplaceWebService;
import com.amazonaws.mws.MarketplaceWebServiceClient;
import com.amazonaws.mws.MarketplaceWebServiceConfig;
import com.amazonaws.mws.MarketplaceWebServiceException;
import com.amazonaws.mws.model.FeedSubmissionInfo;
import com.amazonaws.mws.model.GetFeedSubmissionListRequest;
import com.amazonaws.mws.model.GetFeedSubmissionListResponse;
import com.amazonaws.mws.model.GetFeedSubmissionListResult;
import com.amazonaws.mws.model.ResponseMetadata;
import java.util.List;

public class GetFeedSubmissionListSample {
    public static void main(String ... args) {
        String accessKeyId = "<Your Access Key ID>";
        String secretAccessKey = "<Your Secret Access Key>";
        String appName = "<Your Application or Company Name>";
        String appVersion = "<Your Application Version or Build Number or Release Date>";
        MarketplaceWebServiceConfig config = new MarketplaceWebServiceConfig();
        MarketplaceWebServiceClient service = new MarketplaceWebServiceClient("<Your Access Key ID>", "<Your Secret Access Key>", "<Your Application or Company Name>", "<Your Application Version or Build Number or Release Date>", config);
        String merchantId = "<Your Merchant ID>";
        String sellerDevAuthToken = "<Merchant Developer MWS Auth Token>";
        GetFeedSubmissionListRequest request = new GetFeedSubmissionListRequest();
        request.setMerchant("<Your Merchant ID>");
    }

    public static void invokeGetFeedSubmissionList(MarketplaceWebService service, GetFeedSubmissionListRequest request) {
        try {
            GetFeedSubmissionListResponse response = service.getFeedSubmissionList(request);
            System.out.println("GetFeedSubmissionList Action Response");
            System.out.println("=============================================================================");
            System.out.println();
            System.out.print("    GetFeedSubmissionListResponse");
            System.out.println();
            if (response.isSetGetFeedSubmissionListResult()) {
                System.out.print("        GetFeedSubmissionListResult");
                System.out.println();
                GetFeedSubmissionListResult getFeedSubmissionListResult = response.getGetFeedSubmissionListResult();
                if (getFeedSubmissionListResult.isSetNextToken()) {
                    System.out.print("            NextToken");
                    System.out.println();
                    System.out.print("                " + getFeedSubmissionListResult.getNextToken());
                    System.out.println();
                }
                if (getFeedSubmissionListResult.isSetHasNext()) {
                    System.out.print("            HasNext");
                    System.out.println();
                    System.out.print("                " + getFeedSubmissionListResult.isHasNext());
                    System.out.println();
                }
                List<FeedSubmissionInfo> feedSubmissionInfoList = getFeedSubmissionListResult.getFeedSubmissionInfoList();
                for (FeedSubmissionInfo feedSubmissionInfo : feedSubmissionInfoList) {
                    System.out.print("            FeedSubmissionInfo");
                    System.out.println();
                    if (feedSubmissionInfo.isSetFeedSubmissionId()) {
                        System.out.print("                FeedSubmissionId");
                        System.out.println();
                        System.out.print("                    " + feedSubmissionInfo.getFeedSubmissionId());
                        System.out.println();
                    }
                    if (feedSubmissionInfo.isSetFeedType()) {
                        System.out.print("                FeedType");
                        System.out.println();
                        System.out.print("                    " + feedSubmissionInfo.getFeedType());
                        System.out.println();
                    }
                    if (feedSubmissionInfo.isSetSubmittedDate()) {
                        System.out.print("                SubmittedDate");
                        System.out.println();
                        System.out.print("                    " + feedSubmissionInfo.getSubmittedDate());
                        System.out.println();
                    }
                    if (feedSubmissionInfo.isSetFeedProcessingStatus()) {
                        System.out.print("                FeedProcessingStatus");
                        System.out.println();
                        System.out.print("                    " + feedSubmissionInfo.getFeedProcessingStatus());
                        System.out.println();
                    }
                    if (feedSubmissionInfo.isSetStartedProcessingDate()) {
                        System.out.print("                StartedProcessingDate");
                        System.out.println();
                        System.out.print("                    " + feedSubmissionInfo.getStartedProcessingDate());
                        System.out.println();
                    }
                    if (!feedSubmissionInfo.isSetCompletedProcessingDate()) continue;
                    System.out.print("                CompletedProcessingDate");
                    System.out.println();
                    System.out.print("                    " + feedSubmissionInfo.getCompletedProcessingDate());
                    System.out.println();
                }
            }
            if (response.isSetResponseMetadata()) {
                System.out.print("        ResponseMetadata");
                System.out.println();
                ResponseMetadata responseMetadata = response.getResponseMetadata();
                if (responseMetadata.isSetRequestId()) {
                    System.out.print("            RequestId");
                    System.out.println();
                    System.out.print("                " + responseMetadata.getRequestId());
                    System.out.println();
                }
            }
            System.out.println();
            System.out.println(response.getResponseHeaderMetadata());
            System.out.println();
        }
        catch (MarketplaceWebServiceException ex) {
            System.out.println("Caught Exception: " + ex.getMessage());
            System.out.println("Response Status Code: " + ex.getStatusCode());
            System.out.println("Error Code: " + ex.getErrorCode());
            System.out.println("Error Type: " + ex.getErrorType());
            System.out.println("Request ID: " + ex.getRequestId());
            System.out.print("XML: " + ex.getXML());
            System.out.println("ResponseHeaderMetadata: " + ex.getResponseHeaderMetadata());
        }
    }
}

