/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.samples;

import com.amazonaws.mws.MarketplaceWebService;
import com.amazonaws.mws.MarketplaceWebServiceClient;
import com.amazonaws.mws.MarketplaceWebServiceConfig;
import com.amazonaws.mws.MarketplaceWebServiceException;
import com.amazonaws.mws.model.GetReportRequest;
import com.amazonaws.mws.model.GetReportResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

public class GetReportAsyncSample {
    public static void main(String ... args) {
        String accessKeyId = "<Your Access Key ID>";
        String secretAccessKey = "<Your Secret Access Key>";
        String appName = "<Your Application or Company Name>";
        String appVersion = "<Your Application Version or Build Number or Release Date>";
        MarketplaceWebServiceConfig config = new MarketplaceWebServiceConfig();
        config.setMaxAsyncThreads(35);
        MarketplaceWebServiceClient service = new MarketplaceWebServiceClient("<Your Access Key ID>", "<Your Secret Access Key>", "<Your Application or Company Name>", "<Your Application Version or Build Number or Release Date>", config);
        String merchantId = "<Your Merchant ID>";
        String sellerDevAuthToken = "<Merchant Developer MWS Auth Token>";
        GetReportRequest requestOne = new GetReportRequest();
        requestOne.setMerchant("<Your Merchant ID>");
        requestOne.setReportId("<Report ID 1>");
        GetReportRequest requestTwo = new GetReportRequest();
        requestTwo.setMerchant("<Your Merchant ID>");
        requestTwo.setReportId("<Report ID 2>");
        ArrayList<GetReportRequest> requests = new ArrayList<GetReportRequest>();
        requests.add(requestOne);
        requests.add(requestTwo);
    }

    public static void invokeGetReport(MarketplaceWebService service, List<GetReportRequest> requests) {
        ArrayList<Future<GetReportResponse>> responses = new ArrayList<Future<GetReportResponse>>();
        for (GetReportRequest getReportRequest : requests) {
            responses.add(service.getReportAsync(getReportRequest));
        }
        for (Future future : responses) {
            while (!future.isDone()) {
                Thread.yield();
            }
            try {
                GetReportResponse response = (GetReportResponse)future.get();
                GetReportRequest originalRequest = requests.get(responses.indexOf(future));
                System.out.println("Result md5checksum : " + response.getGetReportResult().getMD5Checksum());
                System.out.println("Response request id: " + response.getResponseMetadata().getRequestId());
                System.out.println("Report: ");
                System.out.println(requests.get(responses.indexOf(future)).getReportOutputStream().toString());
                System.out.println(response.getResponseHeaderMetadata());
                System.out.println();
            }
            catch (Exception e) {
                if (e.getCause() instanceof MarketplaceWebServiceException) {
                    MarketplaceWebServiceException exception = (MarketplaceWebServiceException)MarketplaceWebServiceException.class.cast(e.getCause());
                    System.out.println("Caught Exception: " + exception.getMessage());
                    System.out.println("Response Status Code: " + exception.getStatusCode());
                    System.out.println("Error Code: " + exception.getErrorCode());
                    System.out.println("Error Type: " + exception.getErrorType());
                    System.out.println("Request ID: " + exception.getRequestId());
                    System.out.print("XML: " + exception.getXML());
                    System.out.println("ResponseHeaderMetadata: " + exception.getResponseHeaderMetadata());
                    continue;
                }
                e.printStackTrace();
            }
        }
    }
}

