/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.samples;

import com.amazonaws.mws.MarketplaceWebService;
import com.amazonaws.mws.MarketplaceWebServiceClient;
import com.amazonaws.mws.MarketplaceWebServiceConfig;
import com.amazonaws.mws.MarketplaceWebServiceException;
import com.amazonaws.mws.model.ReportInfo;
import com.amazonaws.mws.model.ResponseMetadata;
import com.amazonaws.mws.model.UpdateReportAcknowledgementsRequest;
import com.amazonaws.mws.model.UpdateReportAcknowledgementsResponse;
import com.amazonaws.mws.model.UpdateReportAcknowledgementsResult;
import java.util.List;

public class UpdateReportAcknowledgementsSample {
    public static void main(String ... args) {
        String accessKeyId = "<Your Access Key ID>";
        String secretAccessKey = "<Your Secret Access Key>";
        String appName = "<Your Application or Company Name>";
        String appVersion = "<Your Application Version or Build Number or Release Date>";
        MarketplaceWebServiceConfig config = new MarketplaceWebServiceConfig();
        MarketplaceWebServiceClient service = new MarketplaceWebServiceClient("<Your Access Key ID>", "<Your Secret Access Key>", "<Your Application or Company Name>", "<Your Application Version or Build Number or Release Date>", config);
        String merchantId = "<Your Merchant ID>";
        String sellerDevAuthToken = "<Merchant Developer MWS Auth Token>";
        UpdateReportAcknowledgementsRequest request = new UpdateReportAcknowledgementsRequest();
        request.setMerchant("<Your Merchant ID>");
    }

    public static void invokeUpdateReportAcknowledgements(MarketplaceWebService service, UpdateReportAcknowledgementsRequest request) {
        try {
            UpdateReportAcknowledgementsResponse response = service.updateReportAcknowledgements(request);
            System.out.println("UpdateReportAcknowledgements Action Response");
            System.out.println("=============================================================================");
            System.out.println();
            System.out.print("    UpdateReportAcknowledgementsResponse");
            System.out.println();
            if (response.isSetUpdateReportAcknowledgementsResult()) {
                System.out.print("        UpdateReportAcknowledgementsResult");
                System.out.println();
                UpdateReportAcknowledgementsResult updateReportAcknowledgementsResult = response.getUpdateReportAcknowledgementsResult();
                if (updateReportAcknowledgementsResult.isSetCount()) {
                    System.out.print("            Count");
                    System.out.println();
                    System.out.print("                " + updateReportAcknowledgementsResult.getCount());
                    System.out.println();
                }
                List<ReportInfo> reportInfoList = updateReportAcknowledgementsResult.getReportInfoList();
                for (ReportInfo reportInfo : reportInfoList) {
                    System.out.print("            ReportInfo");
                    System.out.println();
                    if (reportInfo.isSetReportId()) {
                        System.out.print("                ReportId");
                        System.out.println();
                        System.out.print("                    " + reportInfo.getReportId());
                        System.out.println();
                    }
                    if (reportInfo.isSetReportType()) {
                        System.out.print("                ReportType");
                        System.out.println();
                        System.out.print("                    " + reportInfo.getReportType());
                        System.out.println();
                    }
                    if (reportInfo.isSetReportRequestId()) {
                        System.out.print("                ReportRequestId");
                        System.out.println();
                        System.out.print("                    " + reportInfo.getReportRequestId());
                        System.out.println();
                    }
                    if (reportInfo.isSetAvailableDate()) {
                        System.out.print("                AvailableDate");
                        System.out.println();
                        System.out.print("                    " + reportInfo.getAvailableDate());
                        System.out.println();
                    }
                    if (reportInfo.isSetAcknowledged()) {
                        System.out.print("                Acknowledged");
                        System.out.println();
                        System.out.print("                    " + reportInfo.isAcknowledged());
                        System.out.println();
                    }
                    if (!reportInfo.isSetAcknowledgedDate()) continue;
                    System.out.print("                AcknowledgedDate");
                    System.out.println();
                    System.out.print("                    " + reportInfo.getAcknowledgedDate());
                    System.out.println();
                }
            }
            if (response.isSetResponseMetadata()) {
                System.out.print("        ResponseMetadata");
                System.out.println();
                ResponseMetadata responseMetadata = response.getResponseMetadata();
                if (responseMetadata.isSetRequestId()) {
                    System.out.print("            RequestId");
                    System.out.println();
                    System.out.print("                " + responseMetadata.getRequestId());
                    System.out.println();
                }
            }
            System.out.println();
            System.out.println(response.getResponseHeaderMetadata());
            System.out.println();
        }
        catch (MarketplaceWebServiceException ex) {
            System.out.println("Caught Exception: " + ex.getMessage());
            System.out.println("Response Status Code: " + ex.getStatusCode());
            System.out.println("Error Code: " + ex.getErrorCode());
            System.out.println("Error Type: " + ex.getErrorType());
            System.out.println("Request ID: " + ex.getRequestId());
            System.out.print("XML: " + ex.getXML());
            System.out.println("ResponseHeaderMetadata: " + ex.getResponseHeaderMetadata());
        }
    }
}

