/*
 * Decompiled with CFR 0.152.
 */
package com.github.parze;

import com.github.parze.Queue;
import com.github.parze.QueueItem;
import com.github.parze.TdbqException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueExecutor<T> {
    private Logger logger = LoggerFactory.getLogger(QueueExecutor.class);
    private final Queue<T> queue;
    private final RunnableCreator<T> runnableCreator;
    private final long checkQueueInterval;
    private final ExecutorService executorService;
    private final CallBackWhenDone<T> callBackWhenDone;
    private final Thread queueManager;
    private final Object dequeueThreadIsWorkingLock = new Object();
    private boolean shouldBeActive = true;

    public QueueExecutor(Queue<T> queue, RunnableCreator<T> runnableCreator, int threadPoolSize, final long checkQueueInterval) {
        this.queue = queue;
        this.runnableCreator = runnableCreator;
        this.checkQueueInterval = checkQueueInterval;
        this.executorService = Executors.newFixedThreadPool(threadPoolSize);
        this.callBackWhenDone = new CallBackWhenDone<T>(){

            @Override
            public void done(QueueItem<T> queueItem) {
                QueueExecutor.this.queue.removeItem(queueItem);
            }
        };
        this.queueManager = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                QueueExecutor.this.logger.info("Starting queue manager");
                while (QueueExecutor.this.shouldBeActive) {
                    Object object = QueueExecutor.this.dequeueThreadIsWorkingLock;
                    synchronized (object) {
                        try {
                            QueueItem queueItem = QueueExecutor.this.queue.getAndLockNextItem();
                            while (queueItem != null) {
                                Runnable runnable = QueueExecutor.this.runnableCreator.createRunnable(queueItem, QueueExecutor.this.callBackWhenDone);
                                QueueExecutor.this.executorService.execute(runnable);
                                queueItem = QueueExecutor.this.queue.getAndLockNextItem();
                            }
                            if (checkQueueInterval > 0L) {
                                QueueExecutor.this.dequeueThreadIsWorkingLock.wait(checkQueueInterval);
                            } else {
                                QueueExecutor.this.dequeueThreadIsWorkingLock.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        this.queueManager.start();
    }

    public void addItem(T item) {
        this.queue.addItem(item);
        this.notifyThatItemWasAddedToQueueForProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyThatItemWasAddedToQueueForProcessing() {
        Object object = this.dequeueThreadIsWorkingLock;
        synchronized (object) {
            this.dequeueThreadIsWorkingLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.dequeueThreadIsWorkingLock;
        synchronized (object) {
            this.logger.info("Stopping queue manager ...");
            this.shouldBeActive = false;
            this.dequeueThreadIsWorkingLock.notify();
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.logger.info("Queue manager stopped");
        }
    }

    public Queue<T> getQueue() {
        return this.queue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private Queue<T> queue;
        private RunnableCreator<T> runnableCreator;
        private Long checkQueueInterval;
        private Integer threadPoolSize;

        public Builder withQueue(Queue<T> queue) {
            this.queue = queue;
            return this;
        }

        public Builder withRunnableCreator(RunnableCreator<T> runnableCreator) {
            this.runnableCreator = runnableCreator;
            return this;
        }

        public Builder withCheckQueueInterval(long checkQueueInterval) {
            this.checkQueueInterval = checkQueueInterval;
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public QueueExecutor<T> build() {
            if (this.queue == null) {
                throw new TdbqException("Queue must be set.");
            }
            if (this.checkQueueInterval == null) {
                this.checkQueueInterval = -1L;
            }
            if (this.threadPoolSize == null) {
                this.threadPoolSize = 10;
            }
            return new QueueExecutor<T>(this.queue, this.runnableCreator, this.threadPoolSize, this.checkQueueInterval);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RunnableCreator<T> {
        public Runnable createRunnable(QueueItem<T> var1, CallBackWhenDone<T> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CallBackWhenDone<T> {
        public void done(QueueItem<T> var1);
    }
}

