/*
 * Decompiled with CFR 0.152.
 */
package com.github.pellaton.springconfigvalidation;

import javax.tools.Diagnostic;

public enum SpringConfigurationMessage {
    NESTED_CLASS_NOT_STATIC(Diagnostic.Kind.ERROR, "Invalid bean definition class: Nested @Configuration classes must be static."),
    CLASS_FINAL(Diagnostic.Kind.ERROR, "Invalid bean definition class: @Configuration classes must not be final."),
    MISSING_NO_ARG_CONSTRUCTOR(Diagnostic.Kind.ERROR, "Invalid bean definition class: @Configuration classes must have a visible no-arg constructor."),
    AUTOWIRED_CONSTRUCTOR(Diagnostic.Kind.ERROR, "Invalid bean definition class: @Configuration class constructors must not be @Autowired."),
    BEAN_METHOD_FINAL(Diagnostic.Kind.ERROR, "Invalid factory method: @Bean methods must not be final."),
    BEAN_METHOD_RETURNS_VOID(Diagnostic.Kind.ERROR, "Invalid factory method: @Bean methods must have a non-void return type."),
    BEAN_METHOD_PRIVATE(Diagnostic.Kind.ERROR, "Invalid factory method: @Bean methods must not be private."),
    STATIC_BEAN_METHOD(Diagnostic.Kind.WARNING, "Only @Bean methods returning a BeanFactoryPostProcessor should be static."),
    BFPP_BEAN_METHOD_NOT_STATIC(Diagnostic.Kind.WARNING, "@Bean methods returning a BeanFactoryPostProcessor should be static.");

    private final Diagnostic.Kind kind;
    private final String message;

    private SpringConfigurationMessage(Diagnostic.Kind kind, String message) {
        this.kind = kind;
        this.message = message;
    }

    public Diagnostic.Kind getKind() {
        return this.kind;
    }

    public String getMessage() {
        return this.message;
    }
}

