/*
 * Decompiled with CFR 0.152.
 */
package com.github.qacore.testingtoolbox.managers;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.WrapsDriver;

public final class WebDriverManager {
    private static final ThreadLocal<WebDriver> webDriver = new ThreadLocal();
    private static final WrapsDriver driverContext = new WrapsDriver(){

        public WebDriver getWrappedDriver() {
            return (WebDriver)webDriver.get();
        }

        public String toString() {
            return "WebDriverManager(thread=" + Thread.currentThread().getName() + ", driver=" + webDriver.get() + ")";
        }
    };

    public static WebDriver getDriver() {
        return webDriver.get();
    }

    public static void setDriver(WebDriver driver) {
        webDriver.set(driver);
    }

    public static WrapsDriver getDriverContext() {
        return driverContext;
    }

    private WebDriverManager() {
    }
}

