/*
 * Decompiled with CFR 0.152.
 */
package com.github.qacore.testingtoolbox.patterns.pageobjects;

import com.github.qacore.testingtoolbox.managers.WebDriverManager;
import com.github.qacore.testingtoolbox.patterns.pageobjects.PageObjects;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.WrapsDriver;

public class AbstractPageObjects
implements PageObjects {
    private WrapsDriver driverContext;
    private String url;

    public AbstractPageObjects(WrapsDriver driverContext, String url) {
        this.driverContext = driverContext == null ? WebDriverManager.getDriverContext() : driverContext;
        this.url = url;
    }

    public AbstractPageObjects(final WebDriver webDriver, String url) {
        this.driverContext = webDriver == null ? WebDriverManager.getDriverContext() : new WrapsDriver(){

            public WebDriver getWrappedDriver() {
                return webDriver;
            }
        };
        this.url = url;
    }

    public AbstractPageObjects(String url) {
        this.driverContext = WebDriverManager.getDriverContext();
        this.url = url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    @Override
    public WebDriver getWrappedDriver() {
        return this.driverContext.getWrappedDriver();
    }

    protected WrapsDriver getDriverContext() {
        return this.driverContext;
    }

    protected void setDriverContext(WrapsDriver driverContext) {
        this.driverContext = driverContext;
    }

    public String toString() {
        return "Page(" + this.getUrl() + ")";
    }
}

