/*
 * Decompiled with CFR 0.152.
 */
package com.github.qacore.testingtoolbox.junit.runners;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.junit.runners.model.RunnerScheduler;

class ParallelScheduler
implements RunnerScheduler {
    protected static final ExecutorService EXECUTOR_SERVICE;
    private List<Callable<Void>> childStatements = new ArrayList<Callable<Void>>();

    ParallelScheduler() {
    }

    public void schedule(final Runnable childStatement) {
        this.getChildStatements().add(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                childStatement.run();
                return null;
            }
        });
    }

    public void finished() {
        try {
            EXECUTOR_SERVICE.invokeAll(this.getChildStatements());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected List<Callable<Void>> getChildStatements() {
        return this.childStatements;
    }

    protected void setChildStatements(List<Callable<Void>> childStatements) {
        this.childStatements = childStatements;
    }

    static {
        BigDecimal parallelTestThreadsPerCore;
        BigDecimal availableProcessors = new BigDecimal(String.valueOf(Runtime.getRuntime().availableProcessors()));
        BigDecimal availableThreads = availableProcessors.multiply(parallelTestThreadsPerCore = new BigDecimal(System.getProperty("toolbox.parallelTestThreadsPerCore", "1"))).setScale(0, 6);
        int threads = availableThreads.intValue();
        if (threads < 1) {
            threads = 1;
        }
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(threads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName("JUnit-" + thread.getName());
                thread.setDaemon(true);
                return thread;
            }
        });
    }
}

